<?php

/**
 * This is the model class for table "{{pagos}}".
 *
 * The followings are the available columns in table '{{pagos}}':
 * @property integer $id_pago
 * @property string $descripcion
 * @property string $comprobante
 * @property string $fecha
 * @property integer $id_forma_pago
 * @property integer $id_cuenta
 * @property integer $id_usuario
 * @property string $log
 *
 * The followings are the available model relations:
 * @property CuentasAgencia $idCuenta
 * @property FormaPago $idFormaPago
 * @property Users $idUsuario
 * @property PagosDetalle[] $pagosDetalles
 */
class Pagos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Pagos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pagos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha, id_forma_pago, id_usuario,', 'required'),
			array('id_forma_pago, id_cuenta, id_usuario', 'numerical', 'integerOnly'=>true),
			array('comprobante', 'length', 'max'=>200),
			array('descripcion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_pago, descripcion, comprobante, fecha, id_forma_pago, id_cuenta, id_usuario, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCuenta' => array(self::BELONGS_TO, 'CuentasAgencia', 'id_cuenta'),
			'idFormaPago' => array(self::BELONGS_TO, 'FormaPago', 'id_forma_pago'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'pagosDetalles' => array(self::HAS_MANY, 'PagosDetalle', 'id_pago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pago' => 'Id Pago',
			'descripcion' => 'Descripcion',
			'comprobante' => 'Comprobante',
			'fecha' => 'Fecha',
			'id_forma_pago' => 'Id Forma Pago',
			'id_cuenta' => 'Id Cuenta',
			'id_usuario' => 'Id Usuario',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pago',$this->id_pago);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('comprobante',$this->comprobante,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('id_forma_pago',$this->id_forma_pago);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}