<?php

/**
 * This is the model class for table "{{pagos_detalle}}".
 *
 * The followings are the available columns in table '{{pagos_detalle}}':
 * @property integer $id_pago_detalle
 * @property integer $id_pago
 * @property integer $id_ventaservicio
 * @property double $monto
 *
 * The followings are the available model relations:
 * @property Pagos $idPago
 * @property VentasServicios $idVentaservicio
 */
class PagosDetalle extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PagosDetalle the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pagos_detalle}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_pago, id_ventaservicio, monto', 'required'),
			array('id_pago, id_ventaservicio', 'numerical', 'integerOnly'=>true),
			array('monto', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_pago_detalle, id_pago, id_ventaservicio, monto', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idPago' => array(self::BELONGS_TO, 'Pagos', 'id_pago'),
			'idVentaservicio' => array(self::BELONGS_TO, 'VentasServicios', 'id_ventaservicio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pago_detalle' => 'Id Pago Detalle',
			'id_pago' => 'Id Pago',
			'id_ventaservicio' => 'Id Ventaservicio',
			'monto' => 'Monto',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pago_detalle',$this->id_pago_detalle);
		$criteria->compare('id_pago',$this->id_pago);
		$criteria->compare('id_ventaservicio',$this->id_ventaservicio);
		$criteria->compare('monto',$this->monto);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}