<?php

/**
 * This is the model class for table "{{pagos_proveedores}}".
 *
 * The followings are the available columns in table '{{pagos_proveedores}}':
 * @property integer $id_pago
 * @property double $monto
 * @property string $descripcion
 * @property integer $id_forma_pago
 * @property integer $id_ventaservicio
 * @property integer $id_cuenta
 * @property string $log
 *
 * The followings are the available model relations:
 * @property FormaPago $idFormaPago
 * @property VentasServicios $idVentaservicio
 * @property CuentasAgencia $idCuenta
 */
class PagosProveedores extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PagosProveedores the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pagos_proveedores}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('monto, id_forma_pago, id_ventaservicio', 'required'),
			array('id_forma_pago, id_ventaservicio, id_cuenta', 'numerical', 'integerOnly'=>true),
			array('monto', 'numerical'),
			array('descripcion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_pago, monto, descripcion, id_forma_pago, id_ventaservicio, id_cuenta, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idFormaPago' => array(self::BELONGS_TO, 'FormaPago', 'id_forma_pago'),
			'idVentaservicio' => array(self::BELONGS_TO, 'VentasServicios', 'id_ventaservicio'),
			'idCuenta' => array(self::BELONGS_TO, 'CuentasAgencia', 'id_cuenta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pago' => 'Id Pago',
			'monto' => 'Monto',
			'descripcion' => 'Descripcion',
			'id_forma_pago' => 'Id Forma Pago',
			'id_ventaservicio' => 'Id Ventaservicio',
			'id_cuenta' => 'Id Cuenta',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pago',$this->id_pago);
		$criteria->compare('monto',$this->monto);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('id_forma_pago',$this->id_forma_pago);
		$criteria->compare('id_ventaservicio',$this->id_ventaservicio);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}