<?php

/**
 * This is the model class for table "{{proveedores}}".
 *
 * The followings are the available columns in table '{{proveedores}}':
 * @property integer $id_proveedor
 * @property integer $id_agencia
 * @property string $nombre_comercial
 * @property string $correo
 * @property string $plataforma_url
 * @property string $usuario_plataforma
 * @property string $pwd_plataforma
 * @property string $cuidad
 * @property string $estado
 * @property string $detalles
 * @property double $comision
 * @property string $tipo_proveedor
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property ContratoDesglose[] $contratoDesgloses
 * @property CotizacionDetalles[] $cotizacionDetalles
 * @property Agencia $idAgencia
 * @property ProveedoresContacto[] $proveedoresContactos
 * @property ProveedoresDetallesBanco[] $proveedoresDetallesBancos
 * @property TiposerviciosProveedor[] $tiposerviciosProveedors
 * @property VentasServicios[] $ventasServicioses
 */
class Proveedores extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Proveedores the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{proveedores}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_comercial, estatus', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('comision', 'numerical'),
			array('nombre_comercial', 'length', 'max'=>35),
			array('correo', 'length', 'max'=>50),
			array('plataforma_url', 'length', 'max'=>255),
			array('usuario_plataforma', 'length', 'max'=>100),
			array('pwd_plataforma', 'length', 'max'=>150),
			array('cuidad, estado', 'length', 'max'=>25),
			array('tipo_proveedor', 'length', 'max'=>9),
			array('estatus', 'length', 'max'=>2),
			array('detalles, log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_proveedor, id_agencia, nombre_comercial, correo, plataforma_url, usuario_plataforma, pwd_plataforma, cuidad, estado, detalles, comision, tipo_proveedor, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contratoDesgloses' => array(self::HAS_MANY, 'ContratoDesglose', 'id_proveedor'),
			'cotizacionDetalles' => array(self::HAS_MANY, 'CotizacionDetalles', 'id_proveedor'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'proveedoresContactos' => array(self::HAS_MANY, 'ProveedoresContacto', 'id_proveedor'),
			'proveedoresDetallesBancos' => array(self::HAS_MANY, 'ProveedoresDetallesBanco', 'id_proveedor'),
			'tiposerviciosProveedores' => array(self::HAS_MANY, 'TiposerviciosProveedor', 'id_proveedor'),
			'ventasServicioses' => array(self::HAS_MANY, 'VentasServicios', 'id_proveedor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_proveedor' => 'Id Proveedor',
			'id_agencia' => 'Id Agencia',
			'nombre_comercial' => 'Nombre Comercial',
			'correo' => 'Correo',
			'plataforma_url' => 'Plataforma',
			'usuario_plataforma' => 'Usuario',
			'pwd_plataforma' => 'Contraseña',
			'cuidad' => 'Cuidad',
			'estado' => 'Estado',
			'detalles' => 'Detalles',
			'comision' => 'Comisión',
			'tipo_proveedor' => 'Tipo Proveedor',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('nombre_comercial',$this->nombre_comercial,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('plataforma_url',$this->plataforma_url,true);
		$criteria->compare('usuario_plataforma',$this->usuario_plataforma,true);
		$criteria->compare('pwd_plataforma',$this->pwd_plataforma,true);
		$criteria->compare('cuidad',$this->cuidad,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('detalles',$this->detalles,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('tipo_proveedor',$this->tipo_proveedor,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}