<?php

/**
 * This is the model class for table "{{proveedores_detalles_banco}}".
 *
 * The followings are the available columns in table '{{proveedores_detalles_banco}}':
 * @property integer $id
 * @property integer $id_proveedor
 * @property string $alias
 * @property string $banco
 * @property string $sucursal
 * @property string $cuenta
 * @property string $clabe
 *
 * The followings are the available model relations:
 * @property Proveedores $idProveedor
 */
class ProveedoresDetallesBanco extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProveedoresDetallesBanco the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{proveedores_detalles_banco}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_proveedor', 'numerical', 'integerOnly'=>true),
			array('alias', 'length', 'max'=>35),
			array('banco', 'length', 'max'=>20),
			array('sucursal, cuenta', 'length', 'max'=>10),
			array('clabe', 'length', 'max'=>18),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_proveedor, alias, banco, sucursal, cuenta, clabe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_proveedor' => 'Id Proveedor',
			'alias' => 'Alias',
			'banco' => 'Banco',
			'sucursal' => 'Sucursal',
			'cuenta' => 'Cuenta',
			'clabe' => 'Clabe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('alias',$this->alias,true);
		$criteria->compare('banco',$this->banco,true);
		$criteria->compare('sucursal',$this->sucursal,true);
		$criteria->compare('cuenta',$this->cuenta,true);
		$criteria->compare('clabe',$this->clabe,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}