<?php

/**
 * This is the model class for table "{{solicitudes}}".
 *
 * The followings are the available columns in table '{{solicitudes}}':
 * @property integer $id_solicitud
 * @property string $descripcion
 * @property string $medio_contacto
 * @property string $estatus
 * @property integer $id_usuario
 * @property integer $id_agencia
 * @property integer $id_cliente
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Cotizaciones[] $cotizaciones
 * @property Users $idUsuario
 * @property Agencia $idAgencia
 * @property Clientes $idCliente
 */
class Solicitudes extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Solicitudes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{solicitudes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, estatus, id_usuario, id_agencia, id_cliente', 'required'),
			array('id_usuario, id_agencia, id_cliente', 'numerical', 'integerOnly'=>true),
			array('medio_contacto', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_solicitud, descripcion, medio_contacto, estatus, id_usuario, id_agencia, id_cliente, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'cotizaciones' => array(self::HAS_MANY, 'Cotizaciones', 'id_solicitud'),
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_solicitud' => 'Id Solicitud',
			'descripcion' => 'Descripcion',
			'medio_contacto' => 'Medio Contacto',
			'estatus' => 'Estatus',
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'id_cliente' => 'Id Cliente',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_solicitud',$this->id_solicitud);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('medio_contacto',$this->medio_contacto,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}