<?php

/**
 * This is the model class for table "{{terminos}}".
 *
 * The followings are the available columns in table '{{terminos}}':
 * @property integer $id
 * @property string $terminos_general
 * @property string $terminos_grupos
 * @property integer $id_agencia
 *
 * The followings are the available model relations:
 * @property Agencia $idAgencia
 */
class Terminos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Terminos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{terminos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('terminos_general, id_agencia', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('terminos_grupos', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, terminos_general, terminos_grupos, id_agencia', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'terminos_general' => 'Terminos General',
			'terminos_grupos' => 'Terminos Grupos',
			'id_agencia' => 'Id Agencia',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('terminos_general',$this->terminos_general,true);
		$criteria->compare('terminos_grupos',$this->terminos_grupos,true);
		$criteria->compare('id_agencia',$this->id_agencia);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}