<?php

/**
 * This is the model class for table "{{usuarios_agencias}}".
 *
 * The followings are the available columns in table '{{usuarios_agencias}}':
 * @property integer $id_usuario
 * @property integer $id_agencia
 * @property string $fecha_nacimiento
 * @property string $telefono
 * @property string $direccion
 * @property string $foto
 * @property string $rol
 *
 * The followings are the available model relations:
 * @property Users $idUsuario
 * @property Agencia $idAgencia
 */
class UsuariosAgencias extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UsuariosAgencias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{usuarios_agencias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, rol', 'required'),
			array('id_usuario, id_agencia', 'numerical', 'integerOnly'=>true,),
			array('telefono', 'length', 'max'=>10),
			array('direccion', 'length', 'max'=>85),
			//array('foto', 'length', 'max'=>25),
			array('rol', 'length', 'max'=>20),
			array('fecha_nacimiento', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_usuario, id_agencia, fecha_nacimiento, telefono, direccion, foto, rol, status_laboral', 'safe', 'on'=>'search'),
			
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUsuario' => array(self::BELONGS_TO, 'Users', 'id_usuario'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_usuario' => 'Id Usuario',
			'id_agencia' => 'Id Agencia',
			'fecha_nacimiento' => 'Fecha Nacimiento',
			// 'telefono' => 'Telefono',
			// 'direccion' => 'Direccion',
			'foto' => 'Foto',
			'rol' => 'Rol',
			'status_laboral' => 'Estatus Laboral',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('fecha_nacimiento',$this->fecha_nacimiento,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('foto',$this->foto,true);
		$criteria->compare('rol',$this->rol,true);
		$criteria->compare('status_laboral',$this->status_laboral);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}