<?php

/**
 * This is the model class for table "{{ventas}}".
 *
 * The followings are the available columns in table '{{ventas}}':
 * @property integer $id_venta
 * @property integer $id_agencia
 * @property integer $id_cliente
 * @property integer $id_usuario
 * @property string $folio
 * @property string $fecha
 * @property string $pasajero_titular
 * @property string $descripcion
 * @property string $observaciones
 * @property double $cargo_servicios
 * @property string $limite_cancelacion
 * @property string $moneda
 * @property string $estatus
 * @property integer $id_cotizacion
 * @property integer $id_tipo_venta
 * @property integer $pertenece_a
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Contratos[] $contratos
 * @property PromesasPagos[] $promesasPagos
 * @property UsuariosAgencias $idUsuario
 * @property Agencia $idAgencia
 * @property Clientes $idCliente
 * @property Cotizaciones $idCotizacion
 * @property TipoVenta $idTipoVenta
 * @property Ventas $perteneceA
 * @property VentasServicios[] $ventasServicioses
 */
class Ventas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Ventas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ventas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, id_cliente, id_usuario, fecha, pasajero_titular, moneda', 'required'),
			array('id_agencia, id_cliente, id_usuario, id_cotizacion, id_tipo_venta, pertenece_a', 'numerical', 'integerOnly'=>true),
			array('cargo_servicios', 'numerical'),
			array('folio', 'length', 'max'=>35),
			array('pasajero_titular', 'length', 'max'=>50),
			array('moneda', 'length', 'max'=>6),
			array('estatus', 'length', 'max'=>10),
			array('descripcion, observaciones, limite_cancelacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_venta, id_agencia, id_cliente, id_usuario, folio, fecha, pasajero_titular, descripcion, observaciones, moneda, estatus, id_tipo_venta, pertenece_a, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'contratos' => array(self::HAS_ONE, 'Contratos', 'id_venta'),
			'promesasPagos' => array(self::HAS_MANY, 'PromesasPagos', 'id_venta'),
			'idUsuario' => array(self::BELONGS_TO, 'UsuariosAgencias', 'id_usuario'),
			'idAgencia' => array(self::BELONGS_TO, 'Agencia', 'id_agencia'),
			'idCliente' => array(self::BELONGS_TO, 'Clientes', 'id_cliente'),
			'idCotizacion' => array(self::BELONGS_TO, 'Cotizaciones', 'id_cotizacion'),
			'idTipoVenta' => array(self::BELONGS_TO, 'TipoVenta', 'id_tipo_venta'),
			'perteneceA' => array(self::BELONGS_TO, 'Ventas', 'pertenece_a'),
			'ventasServicioses' => array(self::HAS_MANY, 'VentasServicios', 'id_venta'),
			/* 'idVenta' => array(self::BELONGS_TO, 'Ventas', 'id_venta'), */
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_venta' => 'Id Venta',
			'id_agencia' => 'Id Agencia',
			'id_cliente' => 'Id Cliente',
			'id_usuario' => 'Id Usuario',
			'folio' => 'Folio',
			'fecha' => 'Fecha',
			'pasajero_titular' => 'Pasajero Titular',
			'descripcion' => 'Descripción',
			'observaciones' => 'Observaciones',
			'cargo_servicios' => 'Cargo Servicios',
			'limite_cancelacion' => 'Limite Cancelacion',
			'moneda' => 'Moneda',
			'estatus' => 'Estatus',
			'id_cotizacion' => 'Id Cotizacion',
			'id_tipo_venta' => 'Id Tipo Venta',
			'pertenece_a' => 'Pertenece A',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_venta',$this->id_venta);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_cliente',$this->id_cliente);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('folio',$this->folio,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('pasajero_titular',$this->pasajero_titular,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('cargo_servicios',$this->cargo_servicios);
		$criteria->compare('limite_cancelacion',$this->limite_cancelacion,true);
		$criteria->compare('moneda',$this->moneda,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('id_cotizacion',$this->id_cotizacion);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_tipo_venta',$this->id_tipo_venta);
		$criteria->compare('pertenece_a',$this->pertenece_a);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}