<?php

/**
 * This is the model class for table "{{ventas_servicios}}".
 *
 * The followings are the available columns in table '{{ventas_servicios}}':
 * @property integer $id_ventaservicio
 * @property integer $id_venta
 * @property integer $id_proveedor
 * @property integer $id_tipo_servicio
 * @property string $codigo
 * @property string $descripcion
 * @property string $desglose
 * @property string $inicio_servicio
 * @property string $fin_servicio
 * @property string $fecha_limite
 * @property string $limite_cliente
 * @property double $comision
 * @property double $comision_pesos
 * @property double $tarifa_publica
 * @property double $fee
 * @property double $costo
 * @property string $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Grupos[] $gruposes
 * @property PagosDetalle[] $pagosDetalles
 * @property PagosProveedores[] $pagosProveedores
 * @property TipoServicios $idTipoServicio
 * @property Proveedores $idProveedor
 * @property Ventas $idVenta
 */
class VentasServicios extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VentasServicios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ventas_servicios}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inicio_servicio, fecha_limite, comision, comision_pesos, tarifa_publica, costo, pagado_proveedor', 'required'),
			array('id_venta, id_proveedor, id_tipo_servicio, pagado_proveedor', 'numerical', 'integerOnly'=>true),
			array('comision, comision_pesos, tarifa_publica, fee, costo', 'numerical'),
			array('codigo', 'length', 'max'=>35),
			array('descripcion', 'length', 'max'=>250),
			array('estatus', 'length', 'max'=>20),
			array('desglose, fin_servicio, limite_cliente, log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_ventaservicio, id_venta, id_proveedor, id_tipo_servicio, codigo, descripcion, inicio_servicio, fin_servicio, fecha_limite, limite_cliente, comision, comision_pesos, tarifa_publica, fee, costo, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'gruposes' => array(self::HAS_MANY, 'Grupos', 'id_ventaservicio'),
			'pagosDetalles' => array(self::HAS_MANY, 'PagosDetalle', 'id_ventaservicio'),
			'pagosProveedores' => array(self::HAS_MANY, 'PagosProveedores', 'id_ventaservicio'),
			'idTipoServicio' => array(self::BELONGS_TO, 'TipoServicios', 'id_tipo_servicio'),
			'idProveedor' => array(self::BELONGS_TO, 'Proveedores', 'id_proveedor'),
			'idVenta' => array(self::BELONGS_TO, 'Ventas', 'id_venta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_ventaservicio' => 'Id Ventaservicio',
			'id_venta' => 'Id Venta',
			'id_proveedor' => 'Id Proveedor',
			'id_tipo_servicio' => 'Id Tipo Servicio',
			'codigo' => 'Codigo',
			'descripcion' => 'Descripcion',
			'desglose' => 'Desglose',
			'inicio_servicio' => 'Inicio Servicio',
			'fin_servicio' => 'Fin Servicio',
			'fecha_limite' => 'Fecha Limite',
			'limite_cliente' => 'Limite Cliente',
			'comision' => 'Comision',
			'comision_pesos' => 'Comision Pesos',
			'tarifa_publica' => 'Tarifa Publica',
			'fee' => 'Fee',
			'costo' => 'Costo',
			'estatus' => 'Estatus',
			'pagado_proveedor' => 'Pagado Proveedor',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_ventaservicio',$this->id_ventaservicio);
		$criteria->compare('id_venta',$this->id_venta);
		$criteria->compare('id_proveedor',$this->id_proveedor);
		$criteria->compare('id_tipo_servicio',$this->id_tipo_servicio);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('desglose',$this->desglose,true);
		$criteria->compare('inicio_servicio',$this->inicio_servicio,true);
		$criteria->compare('fin_servicio',$this->fin_servicio,true);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('limite_cliente',$this->limite_cliente,true);
		$criteria->compare('comision',$this->comision);
		$criteria->compare('comision_pesos',$this->comision_pesos);
		$criteria->compare('tarifa_publica',$this->tarifa_publica);
		$criteria->compare('fee',$this->fee);
		$criteria->compare('costo',$this->costo);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('pagado_proveedor',$this->pagado_proveedor);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}