<?php

/**
 * This is the model class for table "{{ventas_servicios_desglose}}".
 *
 * The followings are the available columns in table '{{ventas_servicios_desglose}}':
 * @property integer $id_ventaserviciodesglose
 * @property string $desglose
 * @property integer $id_ventaservicio
 * 
 * The followings are the available model relations:
 * @property VentasServicios $idVentaServicio
 */
class VentasServiciosDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VentasServiciosDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ventas_servicios_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('desglose, id_ventaservicio', 'required'),
			array('id_ventaservicio', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_ventaserviciodesglose, desglose, id_ventaservicio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idVentaServicio' => array(self::BELONGS_TO, 'VentasServicios', 'id_ventaServicio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_ventaserviciodesglose' => 'Id Venta Servicio Desglose',
			'desglose' => 'Desglose',
			'id_ventaservicio' => 'Id Venta servicio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_ventaserviciodesglose',$this->id_ventaserviciodesglose);
		$criteria->compare('desglose',$this->desglose,true);
		$criteria->compare('id_ventaservicio',$this->id_ventaservicio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}