<?php
class LoginController extends Controller {
	public $defaultAction = 'login';
	public $layout = '//layouts/loginquixlab';

	/**
	 * Displays the login page
	 */
	public function actionLogin() {
		if (Yii::app()->user->isGuest) {
			$model = new UserLogin;
			// collect user input data
			if (isset($_POST['UserLogin'])) {
				$model->attributes = $_POST['UserLogin'];
				// validate user input and redirect to previous page if valid
				if ($model->validate()) {
					$this->lastViset();

					$cliente = UsuariosClientes::model()->find('id_user = ' . Yii::app()->user->id);
					if (!is_null($cliente)) {
						// header("Location: /admin/user/logout");
						header("Location: /admin/user/logout");
						exit;
					}

					$usuario = UsuariosAgencias::model()->findByPk(Yii::app()->user->id);
					$agencia = Agencia::model()->findByPk($usuario->id_agencia);

					session_start();
					$_SESSION['Agencia'] = $agencia;
					$_SESSION['Usuario'] = $usuario;

					if (Yii::app()->getBaseUrl() . "/index.php" === Yii::app()->user->returnUrl)
						$this->redirect(Yii::app()->controller->module->returnUrl);
					else
						$this->redirect(Yii::app()->user->returnUrl);
				}
			}
			// display the login form
			$this->render('/user/login', array('model' => $model));
		} else
			$this->redirect(Yii::app()->controller->module->returnUrl);
	}

	private function lastViset()
	{
		$lastVisit = User::model()->notsafe()->findByPk(Yii::app()->user->id);
		$lastVisit->lastvisit = time();
		$lastVisit->save();
	}
}