<?php

class RegistrationController extends Controller
{
	public $defaultAction = 'registration';
    public $layout = '//layouts/loginquixlab';
    
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
		);
	}
	/**
	 * Registration user
	 */
	public function actionRegistration() {
		$model = new RegistrationForm;
		$profile=new Profile;
		$agencia= new Agencia;
		$usuarioAgencia= new UsuariosAgencias;
		$profile->regMode = true;
		

		// ajax validator
		if(isset($_POST['ajax']) && $_POST['ajax']==='registration-form')
		{
			echo UActiveForm::validate(array($agencia,$model,$profile));
			Yii::app()->end();
		}
		
		if (Yii::app()->user->id) {
			$this->redirect(Yii::app()->controller->module->profileUrl);
		} else {
			if(isset($_POST['RegistrationForm'])) {
				$model->attributes=$_POST['RegistrationForm'];
				$profile->attributes=((isset($_POST['Profile'])?$_POST['Profile']:array()));
				$agencia->attributes=$_POST['Agencia'];
				if($agencia->validate()&&$model->validate()&&$profile->validate())
				{
					$soucePassword = $model->password;
					$model->activkey=UserModule::encrypting(microtime().$model->password);
					$model->password=UserModule::encrypting($model->password);
					$model->verifyPassword=UserModule::encrypting($model->verifyPassword,$model->password);
					$model->superuser=0;
					$model->status=((Yii::app()->controller->module->activeAfterRegister)?User::STATUS_ACTIVE:User::STATUS_NOACTIVE);
					
					if ($model->save()) {
						$profile->user_id=$model->id;
						$profile->save();
						$agencia->save();
						$usuarioAgencia->id_usuario=$model->id;
						$usuarioAgencia->id_agencia=$agencia->id_agencia;
						$usuarioAgencia->rol= 'Propietario';
						$usuarioAgencia->save();
						if (Yii::app()->controller->module->sendActivationMail) {
							$activation_url = $this->createAbsoluteUrl('/user/activation/activation',array("activkey" => $model->activkey, "email" => $model->email));
							UserModule::sendMail($model->email,UserModule::t("Has sido registrado a {site_name}",array('{site_name}'=>Yii::app()->name)),UserModule::t("Gracias por registrarse, Por favor activa tu cuenta, haciendo clic en {activation_url}. <br>Atentamente el equipo de {site_name}",array('{activation_url}'=>'<a href="'.$activation_url.'">'.$activation_url.'</a>','{site_name}'=>Yii::app()->name)));
						}
						
						if ((Yii::app()->controller->module->loginNotActiv||(Yii::app()->controller->module->activeAfterRegister&&Yii::app()->controller->module->sendActivationMail==false))&&Yii::app()->controller->module->autoLogin) {
								$identity=new UserIdentity($model->username,$soucePassword);
								$identity->authenticate();
								Yii::app()->user->login($identity,0);
								$this->redirect(Yii::app()->controller->module->returnUrl);
						} else {
							if (!Yii::app()->controller->module->activeAfterRegister&&!Yii::app()->controller->module->sendActivationMail) {
								Yii::app()->user->setFlash('info',UserModule::t("Gracias por su registro. Contactar con el Administrador para activar tu cuenta."));
							} elseif(Yii::app()->controller->module->activeAfterRegister&&Yii::app()->controller->module->sendActivationMail==false) {
								Yii::app()->user->setFlash('success',UserModule::t("Gracias por registrarse. Por favor, {{login}}.",array('{{login}}'=>CHtml::link(UserModule::t('Login'),Yii::app()->controller->module->loginUrl))));
							} elseif(Yii::app()->controller->module->loginNotActiv) {
								Yii::app()->user->setFlash('success',UserModule::t("Gracias por registrarse. Por favor revise su email o nombre de usuario."));
							} else {
								Yii::app()->user->setFlash('info',UserModule::t("Gracias por registrarse. Por favor revise su email."));
							}
							$this->refresh();
						}
					}
				} else $profile->validate();
			}
			$this->render('/user/registration',array('model'=>$model,'profile'=>$profile,'agencia'=>$agencia));
		}
	}
}