<?php
/**
 * RegistrationForm class.
 * RegistrationForm is the data structure for keeping
 * user registration form data. It is used by the 'registration' action of 'UserController'.
 */
class RegistrationUser extends User {
	public $verifyPassword;
	public $verifyCode;
	public $nombre_comercial;
    
	public function rules() {
		$rules = array(
			array('username, password, verifyPassword, email', 'required'),
			array('username', 'length', 'max'=>20, 'min' => 4, 'message' => UserModule::t("Nombre de usuario incorrecto (entre 4 y 20 caracteres).")),
			 array('password', 'length', 'max'=>128, 'min' => 8, 'message' => UserModule::t("Contraseña incorrecta (mínimo 8 caracteres).")),
			
			//('password', 'match', 'pattern'=>'/^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/', 'message' => UserModule::t("Password must contain at least one digit, one uppercase letter and one lowercase letter.")),
			array('email', 'email'),
			array('username', 'unique', 'message' => UserModule::t("Este nombre de usuario ya existe.")),
			array('email', 'unique', 'message' => UserModule::t("La dirección de email ya existe.")),
			//array('verifyPassword', 'compare', 'compareAttribute'=>'password', 'message' => UserModule::t("Retype Password is incorrect.")),
			array('username', 'match', 'pattern' => '/^[A-Za-z0-9_]+$/u','message' => UserModule::t("Caracteres incorrectos. Use (A-z 0-9). Sin espacios")),
		);
		
		array_push($rules,array('verifyPassword', 'compare', 'compareAttribute'=>'password', 'message' => UserModule::t("La redigitación de la contraseña es incorrecta.")));
		return $rules;
	}
}