<?php
/**
 * UserChangePassword class.
 * UserChangePassword is the data structure for keeping
 * user change password form data. It is used by the 'changepassword' action of 'UserController'.
 */
class UserChangePassword extends CFormModel {
	public $oldPassword;
	public $password;
	public $verifyPassword;
	
	public function rules() {
		return Yii::app()->controller->id == 'recovery' ? array(
			array('password, verifyPassword', 'required'),
			array('password, verifyPassword', 'length', 'max'=>128, 'min' => 8,'message' => UserModule::t("Contraseña incorrecta (mínimo 8 caracteres).")),
			array('verifyPassword', 'compare', 'compareAttribute'=>'password', 'message' => UserModule::t("La redigitación de la contraseña es incorrecta.")),
		) : array(
			array('oldPassword, password, verifyPassword', 'required'),
			array('oldPassword, password, verifyPassword', 'length', 'max'=>128, 'min' => 8,'message' => UserModule::t("Contraseña incorrecta (mínimo 8 caracteres).")),
			array('verifyPassword', 'compare', 'compareAttribute'=>'password', 'message' => UserModule::t("La redigitación de la contraseña es incorrecta.")),
			array('oldPassword', 'verifyOldPassword'),
		);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'oldPassword'=>UserModule::t("Antigua Contraseña"),
			'password'=>UserModule::t("Contraseña"),
			'verifyPassword'=>UserModule::t("Redigite la contraseña"),
		);
	}
	
	/**
	 * Verify Old Password
	 */
	 public function verifyOldPassword($attribute, $params)
	 {
	     $password = User::model()->notsafe()->findByPk(Yii::app()->user->id)->password;
		 if ($password != Yii::app()->getModule('user')->encrypting($this->$attribute, $password))
			 $this->addError($attribute, UserModule::t("La antigua contraseña  es incorrecta."));
	 }
}