<?php
$this->breadcrumbs=array(
	UserModule::t('Users')=>array('admin'),
	$model->username,
);


$this->menu=array(
    array('label'=>UserModule::t('Crear Nuevo Usuario'), 'url'=>array('create')),
    array('label'=>UserModule::t('Editar Usuario'), 'url'=>array('update','id'=>$model->id)),
    array('label'=>UserModule::t('Eliminar Usuario'), 'url'=>'#','linkOptions'=>array('submit'=>array('delete','id'=>$model->id),'confirm'=>UserModule::t('¿Está seguro de que desea eliminar este elemento?'))),
    array('label'=>UserModule::t('Administrar Usuarios'), 'url'=>array('admin')),
    array('label'=>UserModule::t('Administrar Campos de Perfil'), 'url'=>array('profileField/admin/admin')),
    array('label'=>UserModule::t('Listar Usuarios'), 'url'=>array('/user/default/index')),
);
?>
<h1><?php echo UserModule::t('Ver Usuario').' "'.$model->username.'"'; ?></h1>

<?php
 
	$attributes = array(
		'id',
		'username',
	);
	
	$profileFields=ProfileField::model()->forOwner()->sort()->findAll();
	if ($profileFields) {
		foreach($profileFields as $field) {
			array_push($attributes,array(
					'label' => UserModule::t($field->title),
					'name' => $field->varname,
					'type'=>'raw',
					'value' => (($field->widgetView($model->profile))?$field->widgetView($model->profile):(($field->range)?Profile::range($field->range,$model->profile->getAttribute($field->varname)):$model->profile->getAttribute($field->varname))),
				));
		}
	}
	
	array_push($attributes,
		'password',
		'email',
		'activkey',
		'create_at',
		'lastvisit_at',
		array(
			'name' => 'superuser',
			'value' => User::itemAlias("AdminStatus",$model->superuser),
		),
		array(
			'name' => 'status',
			'value' => User::itemAlias("UserStatus",$model->status),
		)
	);
	
	$this->widget('bootstrap.widgets.TbDetailView', array(
		'data'=>$model,
		'attributes'=>$attributes,
	));
	

?>
