<?php $this->pageTitle=Yii::app()->name . ' - '.UserModule::t("Cambiar la contraseña");
$this->breadcrumbs=array(
	UserModule::t("Perfil") => array('/user/profile'),
	UserModule::t("Cambiar la contraseña"),
);
$this->menu=array(
	array('label'=>UserModule::t('Administrar Usuarios'), 'url'=>array('/user/admin/admin'), 'visible'=>UserModule::isAdmin()),
    array('label'=>UserModule::t('Listar Usuarios'), 'url'=>array('/user/default/index')),
    array('label'=>UserModule::t('Perfil'), 'url'=>array('/user/profile/profile')),
    array('label'=>UserModule::t('Editar'), 'url'=>array('edit')),
    array('label'=>UserModule::t('Cerrar sesión'), 'url'=>array('/user/logout/logout')),
);
?>

<?php $form=$this->beginWidget('ext.bootstrap.widgets.TbActiveForm', array(
    'type'=>'horizontal',
    'id'=>'changepassword-form',
    'enableAjaxValidation'=>true,
    'clientOptions'=>array(
        'validateOnSubmit'=>true,
    ),
)); ?>

<style type="text/css">
	.form-horizontal .control-label{
		width: auto;
	}

	.form-horizontal .controls{
		margin-left: 0px;
	}
	legend{
		font-size: 20px;
	}
</style>





<!-- BEGIN: Content-->
<div class="content-overlay"></div>
<div class="header-navbar-shadow"></div>
<div class="content-wrapper container-xxl p-0">

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <ul class="nav nav-pills mb-2">
                    <!-- account -->
                    <li class="nav-item">
                        <a class="nav-link" href="<?= Yii::app()->createUrl('user/profile/edit') ?>">
                            <i class="fas fa-user-circle font-medium-3 me-50"></i>
                            <span class="fw-bold lang" key="Cuenta">Cuenta</span>
                        </a>
                    </li>
                    <!-- security -->
                    <li class="nav-item">
                        <a class="nav-link active" href="<?= Yii::app()->createUrl('user/profile/changepassword') ?>">
                            <i class="fas fa-lock font-medium-3 me-50"></i>
                            <span class="fw-bold lang" key="Seguridad">Seguridad</span>
                        </a>
                    </li>
                </ul>

                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title"><?php echo UserModule::t("Cambiar contraseña"); ?></h4>
                    </div>
                    <div class="card-body pt-1">
                        <?php echo $form->errorSummary($model); ?>
                        <!-- form -->
                        <form class="validate-form">
                            <div class="row">
                                <div class="col-12 col-sm-6 mb-1">
                                    <label class="form-label lang" key="Contraseña anterior" for="account-old-password">Contraseña anterior</label>
                                        <?php echo $form->passwordField($model,'oldPassword',array('class'=>'form-control', 'id'=>'account-old-password')); ?>
                                    <!-- <div class="input-group form-password-toggle input-group-merge">
                                        <input type="password" class="form-control" id="account-old-password" name="password" placeholder="Enter current password" data-msg="Please current password" />
                                         <div class="input-group-text cursor-pointer">
                                            <i data-feather="eye"></i>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 col-sm-6 mb-1">
                                    <label class="form-label lang" key="Nueva contraseña" for="account-new-password">Nueva contraseña</label>
                                        <?php echo $form->passwordField($model,'password',array('class'=>'form-control', 'id'=>'account-new-password')); ?>
                                    <!-- <div class="input-group form-password-toggle input-group-merge">
                                        <input type="password" id="account-new-password" name="new-password" class="form-control" placeholder="Enter new password" />
                                        <div class="input-group-text cursor-pointer">
                                            <i data-feather="eye"></i>
                                        </div>
                                    </div> -->
                                </div>
                                <div class="col-12 col-sm-6 mb-1">
                                    <label class="form-label lang" key="Repetir contraseña" for="account-retype-new-password">Repetir contraseña</label>
                                        <?php echo $form->passwordField($model,'verifyPassword',array('class'=>'form-control', 'id'=>'account-retype-new-password')); ?>
                                    <!-- <div class="input-group form-password-toggle input-group-merge">
                                        <input type="password" class="form-control" id="account-retype-new-password" name="confirm-new-password" placeholder="Confirm your new password" />
                                        <div class="input-group-text cursor-pointer"><i data-feather="eye"></i></div>
                                    </div> -->
                                </div>
                                <div class="col-12">
                                    <p class="fw-bolder lang" key="Requerimiento de la contraseña">Requerimiento de la contraseña</p>
                                    <ul class="ps-1 ms-25">
                                        <li class="mb-50 lang" key="Minimo de 8 caracteres">Minimo de 8 caracteres</li>
                                        <!-- <li class="mb-50">At least one lowercase character</li>
                                        <li>At least one number, symbol, or whitespace character</li> -->
                                    </ul>
                                </div>
                                <div class="col-12 mt-1">
                                    <?php $this->widget('bootstrap.widgets.TbButton',array(
                                            'label'=>UserModule::t("Cambiar contraseña"),
                                            'buttonType'=>'submit',
                                            'type'=>'primary',
                                        )); ?>
                                    <!-- <button type="submit" class="btn btn-primary me-1 mt-1">Cambiar contraseña</button> -->
                                    <a href="<?= Yii::app()->createUrl('user/profile') ?>" class="btn btn-outline-secondary lang" key="Cancelar">Cancelar</a>
                                </div>
                            </div>
                        </form>
                        <!--/ form -->
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- END: Content-->

<?php $this->endWidget(); ?>