<?php $this->pageTitle=Yii::app()->name . ' - '.UserModule::t("Editar perfil");
$this->breadcrumbs=array(
	UserModule::t("Perfil")=>array('profile'),
	UserModule::t("Editar"),
);
$this->menu=array(
	array('label'=>UserModule::t('Administrar Usuarios'), 'url'=>array('/user/admin/admin'), 'visible'=>UserModule::isAdmin()),
    array('label'=>UserModule::t('Listar Usuarios'), 'url'=>array('/user/default/index')),
    array('label'=>UserModule::t('Perfil'), 'url'=>array('/user/profile/profile')),
    array('label'=>UserModule::t('Cambiar Contraseña'), 'url'=>array('changepassword')),
    array('label'=>UserModule::t('Cerrar sesión'), 'url'=>array('/user/logout/logout')),
);
?>

<?php $form=$this->beginWidget('ext.bootstrap.widgets.TbActiveForm', array(
    'type'=>'horizontal',
    'id'=>'profile-form',
    'enableAjaxValidation'=>true,
    'htmlOptions' => array('enctype'=>'multipart/form-data'),
)); ?>

<style type="text/css">
	.form-horizontal .control-label{
		width: auto;
	}

	.form-horizontal .controls{
		margin-left: 0px;
	}
	legend{
		font-size: 20px;
	}
</style>

<div class="login-form-bg h-100">
        <div class="container h-100">
            <div class="row justify-content-center h-100 mt-3">
                <div class="col-xl-12">
                    <div class="form-input-content">
                        <div class="card login-form mb-0">
                            <div class="card-body pt-3">
									<h1 class="text-center py-3"><?php echo UserModule::t('Editar perfil'); ?></h1>
                                <form class="mt-5 mb-5 login-input">
                                	<legend><?php echo UserModule::t('Los campos con <span class="required"> * </span> son obligatorios.'); ?></legend>
                                	<?php echo $form->errorSummary(array($model,$profile)); ?>
                                    <div class="form-group">
                                        <?php echo $form->textFieldRow($model,'username',array('class'=>'form-control')); ?>
                                    </div>
                                    <div class="form-group">
                                        <?php echo $form->textFieldRow($model,'email',array('class'=>'form-control')); ?>
                                    </div>
                                    <?php $profileFields=$profile->getFields();
							            if ($profileFields) {
							                foreach($profileFields as $field) {
							                    
							                    if ($widgetEdit = $field->widgetEdit($profile)) {
							                        echo '<div class="form-group">';
							                        echo $form->labelEx($profile,$field->varname, array('class'=>'control-label'));
							                        echo '<div class="controls">';
							                        echo $widgetEdit;
							                        echo $form->error($profile,$field->varname, array('class'=>'help-inline'));
							                        echo '</div></div>';
							                    } elseif ($field->range) {
							                        echo $form->dropDownListRow($profile,$field->varname,Profile::range($field->range));
							                    } elseif ($field->field_type=="TEXT") {
							                        echo $form->textAreaRow($profile,$field->varname,array('rows'=>6, 'cols'=>50));
							                    } else {
							                        echo $form->textFieldRow($profile,$field->varname,array('class'=>'form-control', 'size'=>60,'maxlength'=>(($field->field_size)?$field->field_size:255)));
							                    }
							                }
							            }
							        ?>
                                    <div class="">
								                <?php $this->widget('bootstrap.widgets.TbButton',array(
										            'label'=>$model->isNewRecord ? UserModule::t('Crear') : UserModule::t('Guardar'),
										            'buttonType'=>'submit',
										            'type'=>'primary',
										        )); ?>
								    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>



<?php $this->endWidget(); ?>




    <!-- BEGIN: Content-->
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">

            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <ul class="nav nav-pills mb-2">
                            <!-- account -->
                            <li class="nav-item">
                                <a class="nav-link active" href="<?= Yii::app()->createUrl('user/profile/edit') ?>">
                                	<i class="fas fa-user-circle font-medium-3 me-50"></i>
                                    <span class="fw-bold">Cuenta</span>
                                </a>
                            </li>
                            <!-- security -->
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Yii::app()->createUrl('user/profile/changepassword') ?>">
                                	<i class="fas fa-lock font-medium-3 me-50"></i>
                                    <span class="fw-bold">Seguridad</span>
                                </a>
                            </li>
                        </ul>

                        <!-- profile -->
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Profile Details</h4>
                            </div>
                            <div class="card-body py-2 my-25">
                                <!-- header section -->

                                 <div class="col-12 mb-2">
                <div class="border rounded p-2">
                  <h4 class="mb-1">Featured Image</h4>
                  <div class="d-flex flex-column flex-md-row">
                    <img
                      src="../../../app-assets/images/slider/03.jpg"
                      id="blog-feature-image"
                      class="rounded me-2 mb-1 mb-md-0"
                      width="170"
                      height="110"
                      alt="Blog Featured Image"
                    />
                    <div class="featured-info">
                      <small class="text-muted">Required image resolution 800x400, image size 10mb.</small>
                      <p class="my-50">
                        <a href="#" id="blog-image-text">C:\fakepath\banner.jpg</a>
                      </p>
                      <div class="d-inline-block">
                        <input class="form-control" type="file" id="blogCustomFile" accept="image/*" />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                                <div class="d-flex">
                                    <a href="#" class="me-25">
                                        <img src="../../../app-assets/images/portrait/small/avatar-s-11.jpg" id="account-upload-img" class="uploadedAvatar rounded me-50" alt="profile image" height="100" width="100" />
                                    </a>
                                    <!-- upload and reset button -->
                                    <div class="d-flex align-items-end mt-75 ms-1">
                                        <div>
                                            <label for="account-upload" class="btn btn-sm btn-primary mb-75 me-75">Upload</label>
                                            <input type="file" id="account-upload" hidden accept="image/*" />
                                            <button type="button" id="account-reset" class="btn btn-sm btn-outline-secondary mb-75">Reset</button>
                                            <p class="mb-0">Allowed file types: png, jpg, jpeg.</p>
                                        </div>
                                    </div>
                                    <!--/ upload and reset button -->
                                </div>
                                <!--/ header section -->

                                <!-- form -->
                                <form class="validate-form mt-2 pt-50">
                                    <div class="row">
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountFirstName">First Name</label>
                                            <input type="text" class="form-control" id="accountFirstName" name="firstName" placeholder="John" value="John" data-msg="Please enter first name" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountLastName">Last Name</label>
                                            <input type="text" class="form-control" id="accountLastName" name="lastName" placeholder="Doe" value="Doe" data-msg="Please enter last name" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountEmail">Email</label>
                                            <input type="email" class="form-control" id="accountEmail" name="email" placeholder="Email" value="johndoe@gmail.com" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountOrganization">Organization</label>
                                            <input type="text" class="form-control" id="accountOrganization" name="organization" placeholder="Organization name" value="PIXINVENT" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountPhoneNumber">Phone Number</label>
                                            <input type="text" class="form-control account-number-mask" id="accountPhoneNumber" name="phoneNumber" placeholder="Phone Number" value="457 657 1237" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountAddress">Address</label>
                                            <input type="text" class="form-control" id="accountAddress" name="address" placeholder="Your Address" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountState">State</label>
                                            <input type="text" class="form-control" id="accountState" name="state" placeholder="State" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="accountZipCode">Zip Code</label>
                                            <input type="text" class="form-control account-zip-code" id="accountZipCode" name="zipCode" placeholder="Code" maxlength="6" />
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label class="form-label" for="country">Country</label>
                                            <select id="country" class="select2 form-select">
                                                <option value="">Select Country</option>
                                                <option value="Australia">Australia</option>
                                                <option value="Bangladesh">Bangladesh</option>
                                                <option value="Belarus">Belarus</option>
                                                <option value="Brazil">Brazil</option>
                                                <option value="Canada">Canada</option>
                                                <option value="China">China</option>
                                                <option value="France">France</option>
                                                <option value="Germany">Germany</option>
                                                <option value="India">India</option>
                                                <option value="Indonesia">Indonesia</option>
                                                <option value="Israel">Israel</option>
                                                <option value="Italy">Italy</option>
                                                <option value="Japan">Japan</option>
                                                <option value="Korea">Korea, Republic of</option>
                                                <option value="Mexico">Mexico</option>
                                                <option value="Philippines">Philippines</option>
                                                <option value="Russia">Russian Federation</option>
                                                <option value="South Africa">South Africa</option>
                                                <option value="Thailand">Thailand</option>
                                                <option value="Turkey">Turkey</option>
                                                <option value="Ukraine">Ukraine</option>
                                                <option value="United Arab Emirates">United Arab Emirates</option>
                                                <option value="United Kingdom">United Kingdom</option>
                                                <option value="United States">United States</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label for="language" class="form-label">Language</label>
                                            <select id="language" class="select2 form-select">
                                                <option value="">Select Language</option>
                                                <option value="en">English</option>
                                                <option value="fr">French</option>
                                                <option value="de">German</option>
                                                <option value="pt">Portuguese</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label for="timeZones" class="form-label">Timezone</label>
                                            <select id="timeZones" class="select2 form-select">
                                                <option value="">Select Time Zone</option>
                                                <option value="-12">(GMT-12:00) International Date Line West</option>
                                                <option value="-11">(GMT-11:00) Midway Island, Samoa</option>
                                                <option value="-10">(GMT-10:00) Hawaii</option>
                                                <option value="-9">(GMT-09:00) Alaska</option>
                                                <option value="-8">(GMT-08:00) Pacific Time (US & Canada)</option>
                                                <option value="-8">(GMT-08:00) Tijuana, Baja California</option>
                                                <option value="-7">(GMT-07:00) Arizona</option>
                                                <option value="-7">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>
                                                <option value="-7">(GMT-07:00) Mountain Time (US & Canada)</option>
                                                <option value="-6">(GMT-06:00) Central America</option>
                                                <option value="-6">(GMT-06:00) Central Time (US & Canada)</option>
                                                <option value="-6">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>
                                                <option value="-6">(GMT-06:00) Saskatchewan</option>
                                                <option value="-5">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>
                                                <option value="-5">(GMT-05:00) Eastern Time (US & Canada)</option>
                                                <option value="-5">(GMT-05:00) Indiana (East)</option>
                                                <option value="-4">(GMT-04:00) Atlantic Time (Canada)</option>
                                                <option value="-4">(GMT-04:00) Caracas, La Paz</option>
                                                <option value="-4">(GMT-04:00) Manaus</option>
                                                <option value="-4">(GMT-04:00) Santiago</option>
                                                <option value="-3.5">(GMT-03:30) Newfoundland</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-sm-6 mb-1">
                                            <label for="currency" class="form-label">Currency</label>
                                            <select id="currency" class="select2 form-select">
                                                <option value="">Select Currency</option>
                                                <option value="usd">USD</option>
                                                <option value="euro">Euro</option>
                                                <option value="pound">Pound</option>
                                                <option value="bitcoin">Bitcoin</option>
                                            </select>
                                        </div>
                                        <div class="col-12">
                                            <button type="submit" class="btn btn-primary mt-1 me-1">Guardar cambios</button>
                                            <a href="<?= Yii::app()->createUrl('user/profile') ?>" class="btn btn-outline-secondary mt-1">Cancelar</a>
                                        </div>
                                    </div>
                                </form>
                                <!--/ form -->
                            </div>
                        </div>

                        <!-- deactivate account  -->
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">Delete Account</h4>
                            </div>
                            <div class="card-body py-2 my-25">
                                <div class="alert alert-warning">
                                    <h4 class="alert-heading">Are you sure you want to delete your account?</h4>
                                    <div class="alert-body fw-normal">
                                        Once you delete your account, there is no going back. Please be certain.
                                    </div>
                                </div>

                                <form id="formAccountDeactivation" class="validate-form" onsubmit="return false">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="accountActivation" id="accountActivation" data-msg="Please confirm you want to delete account" />
                                        <label class="form-check-label font-small-3" for="accountActivation">
                                            I confirm my account deactivation
                                        </label>
                                    </div>
                                    <div>
                                        <button type="submit" class="btn btn-danger deactivate-account mt-1">Deactivate Account</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!--/ profile -->
                    </div>
                </div>

            </div>
        </div>
    <!-- END: Content-->


    <?php 
Yii::app()->clientScript->registerScript('headers', '
  var baseUrl = "'.Yii::app()->baseUrl.'"; 
  ', CClientScript::POS_HEAD);

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/template/vuexy/js/scripts/pages/page-account-settings-account.min.js', CClientScript::POS_END);

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/perfilVUE.js?v='.time(), CClientScript::POS_END);
?>