<?php $this->pageTitle = Yii::app()->name . ' - ' . UserModule::t("Perfil");
$this->breadcrumbs = array(
    UserModule::t("Perfil"),
);
$this->menu = array(
    array('label' => UserModule::t('Administrar Usuarios'), 'url' => array('/user/admin/admin'), 'visible' => UserModule::isAdmin()),
    array('label' => UserModule::t('Listar Usuarios'), 'url' => array('/user/user/index')),
    array('label' => UserModule::t('Editar'), 'url' => array('edit')),
    array('label' => UserModule::t('Cambiar Contraseña'), 'url' => array('changepassword')),
    array('label' => UserModule::t('Cerrar sesión'), 'url' => array('/user/logout/logout')),
); ?>

<style type="text/css">
    .content-body {
        height: 100%;
    }

    /*.info{
        background-color: paleturquoise;
        padding: 5px;
        margin: 10px 0px;
        color: #333;
        font-size: 15px;
    }*/
</style>



<div id="appusuario" class="row">
    <!-- User Sidebar -->
    <div class="col-lg-5 col-md-5 order-1 order-md-0">
        <!-- User Card -->
        <div class="card">
            <?php if (Yii::app()->user->hasFlash('success')) : ?>
                <div class="alert-body fw-normal">
                    <?php echo Yii::app()->user->getFlash('success'); ?>
                </div>
            <?php endif; ?>
            <div class="card-body">
                <div class="user-avatar-section">
                    <div class="d-flex align-items-center flex-column">
                        <img class="img-fluid rounded mt-3 mb-2" v-if="detalle_usuario[0].foto" :src="'<?= Yii::app()->baseUrl ?>/images/usuarios/'+detalle_usuario[0].foto" height="110" width="110" alt="User avatar" />
                        <img class="img-fluid rounded mt-3 mb-2" v-else src="<?= Yii::app()->baseUrl ?>/images/profile-default.svg" height="110" width="110" alt="User avatar" />
                        <div class="user-info text-center">
                            <h4>{{detalle_usuario[0].idUsuario.profiles.firstname}} {{detalle_usuario[0].idUsuario.profiles.lastname}}</h4>
                            <span class="badge bg-light-secondary">{{detalle_usuario[0].rol}}</span>
                        </div>
                    </div>
                </div>

                <h4 class="fw-bolder border-bottom pb-50 mb-1 mt-3" v-html="Detalles">Detalles</h4>
                <div class="info-container">
                    <ul class="list-unstyled">
                        <li class="mb-75">
                            <span class="fw-bolder me-25" v-html="Usuario">Usuario:</span>
                            <span>{{detalle_usuario[0].idUsuario.username}}</span>
                        </li>
                        <li class="mb-75">
                            <span class="fw-bolder me-25" v-html="Telefono">Teléfono:</span>
                            <span class="telefonoMask" maxlength="10">{{detalle_usuario[0].telefono}}</span>
                        </li>
                        <li class="mb-75">
                            <span class="fw-bolder me-25" v-html="Correo">Correo:</span>
                            <span>{{detalle_usuario[0].idUsuario.email}}</span>
                        </li>
                        <li class="mb-75">
                            <span class="fw-bolder me-25" v-html="Fechanacimiento">Fecha de nacimiento:</span>
                            <span>{{detalle_usuario[0].fecha_nacimiento}}</span>
                        </li>
                        <li class="mb-75">
                            <span class="fw-bolder me-25" v-html="Rol">Role:</span>
                            <span>{{detalle_usuario[0].rol}}</span>
                        </li>
                        <div v-if="detalle_usuario[0].status_laboral == 1">
                            <li class="mb-75">
                                <span class="fw-bolder me-25">Status:</span>
                                <span class="badge bg-light-success" v-html="Activo">Activo</span>
                            </li>
                        </div>
                        <div v-else>
                            <li class="mb-75">
                                <span class="fw-bolder me-25">Status:</span>
                                <span class="badge bg-light-success" v-html="Desactivado">Desactivado</span>
                            </li>
                        </div>
                    </ul>
                    <div class="d-flex justify-content-center pt-2">
                        <a href="<?= Yii::app()->createUrl('user/profile/edit') ?>" class="btn btn-primary me-1" v-html="Editar">Editar</a>
                        <a href="javascript:;" class="btn btn-outline-danger suspend-user" v-html="Desactivar">Desactivar</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-7 col-md-7 order-0 order-md-1">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-75">Social accounts</h4>
                <p>Display content from social accounts on your site</p>
                <!-- Social Accounts -->
                <div class="d-flex mt-2">
                    <div class="flex-shrink-0">
                        <img src="https://s3-symbol-logo.tradingview.com/facebook--600.png" alt="facebook" class="me-1" height="38" width="38" />
                    </div>
                    <div class="d-flex justify-content-between flex-grow-1">
                        <div class="me-1">
                            <p class="fw-bolder mb-0">Facebook</p>
                            <span>Not Connected</span>
                        </div>
                        <div class="mt-50 mt-sm-0">
                            <button type="button" class="btn btn-icon btn-outline-secondary">
                                <i class="fas fa-link font-medium-3"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-start mt-2">
                    <div class="flex-shrink-0">
                        <img src="data:image/png;base64,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" alt="twitter" class="me-1" height="38" width="38" />
                    </div>
                    <div class="d-flex justify-content-between flex-grow-1">
                        <div class="me-1">
                            <p class="fw-bolder mb-0">Twitter</p>
                            <a href="https://twitter.com/pixinvent" target="_blank">@pixinvent</a>
                        </div>
                        <div class="mt-50 mt-sm-0">
                            <button type="button" class="btn btn-icon btn-outline-secondary">
                                <i class="fas fa-link font-medium-3"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="d-flex mt-2">
                    <div class="flex-shrink-0">
                        <img src="https://www.stampaprint.net/es/blog/wp-content/uploads/2016/05/dribbble-red-para-creativos.png" alt="dribbble" class="me-1" height="38" width="38" />
                    </div>
                    <div class="d-flex justify-content-between flex-grow-1">
                        <div class="me-1">
                            <p class="fw-bolder mb-0">Dribbble</p>
                            <span>Not Connected</span>
                        </div>
                        <div class="mt-50 mt-sm-0">
                            <button type="button" class="btn btn-icon btn-outline-secondary">
                                <i class="fas fa-link font-medium-3"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="d-flex mt-2">
                    <div class="flex-shrink-0">
                        <img src="https://www.experimenta.es/wp-content/uploads/2017/12/behance-logo-1.jpg" alt="behance" class="me-1" height="38" width="38" />
                    </div>
                    <div class="d-flex justify-content-between flex-grow-1">
                        <div class="me-1">
                            <p class="fw-bolder mb-0">Behance</p>
                            <span>Not Connected</span>
                        </div>
                        <div class="mt-50 mt-sm-0">
                            <button type="button" class="btn btn-icon btn-outline-secondary">
                                <i class="fas fa-link font-medium-3"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <!-- /Social Accounts -->
            </div>
        </div>

    </div>
</div>

<?php
Yii::app()->clientScript->registerScript('headers', '
  var baseUrl = "' . Yii::app()->baseUrl . '"; 
  ', CClientScript::POS_HEAD);


Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.10/jquery.mask.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScript('mascara', "
$('.telefonoMask').mask('(000) 000-0000');
    ", CClientScript::POS_READY);


Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/perfilVUE.js?v=' . time(), CClientScript::POS_END);
?>