<style>
    .dataTables_length {
		margin-left: 1rem;
	}

	.dataTables_info {
		margin-left: 1rem;
	}

	.dataTables_filter {
		margin-right: 1rem;
	}

	.dataTables_paginate {
		margin-right: 1rem !important;
	}
</style>

<section id="account-app">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">Cuentas de mi agencia</h4>
                    <div class="float-end">
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#cu-accounts">
                            <i data-feather="plus"></i>Cuenta
                        </button>
                    </div>
                </div>
                <div class="card-datatable">
                    <table id="account-table" class="table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Descripción</th>
                                <th>Cuenta</th>
                                <th>Estatus</th>
                                <th></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-start" id="cu-accounts" tabindex="-1" aria-labelledby="labelAccounts" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="labelAccounts" v-if="account_model.id_cuenta > 0">Editar cuenta</h4>
                    <h4 class="modal-title" id="labelAccounts" v-else>Agregar cuenta</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-1">
                        <label class="form-label">Cuenta</label>
                        <input type="text" class="form-control" v-model="account_model.cuenta">
                    </div>
                    <div class="mb-1">
                        <label class="form-label">Descripción</label>
                        <textarea type="text" class="form-control" v-model="account_model.descripcion"></textarea>
                    </div>
                    <div class="mb-1" v-if="account_model.id_cuenta > 0">
                        <label class="form-label">Estatus</label>
                        <select class="form-control" v-model="account_model.estatus">
                            <option value="0">Desactivada</option>
                            <option value="1">Activa</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" @click="account_model.id_cuenta > 0 ? updateAccount() : saveAccount()">Aceptar</button>
                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancelar</button>
                </div>
            </div>
        </div>
    </div>

</section>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
    ', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/agencia-cuentas.js?v='. time(), CClientScript::POS_END);
?>