<style type="text/css" media="screen">
	canvas {
		width: 50em;
		height: 30em;
		border-radius: 4px;
		box-shadow: 0 0 5px rgba(0, 0, 0, 0.02) inset; 
		border-bottom: 1px solid #000;
	}

	@media only screen and (max-width: 768px) {
  		/* For mobile phones: */
  		canvas {
			height: 15em;
  		}
	}
</style>

<div id="signature-pad" class="card">
    <div class="card-header">Firma electrónica</div>
    <div class="card-body">
        <div class="text-center">
            <canvas id="can_sign" class="border"></canvas>
        </div>
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col">
                <button type="button" class="btn btn-outline-primary clear" data-action="clear">Limpiar</button>
                <button type="button" class="btn btn-outline-primary" data-action="undo">Deshacer</button>
            </div>
            <div class="col text-end">
                <button style="display: none;" type="button" class="btn btn-primary" data-action="save-bd">Firmar</button>
                <button <?= $style; ?> type="button" class="btn btn-primary" data-action="save-signature">Guardar</button>
            </div>
        </div>
    </div>
</div>

<?php
	Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var iu = "'. Yii::app()->user->id .'";
	', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerScriptFile("https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js", CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl ."/vue/contrato-firma.js?v=". time(), CClientScript::POS_END);
?>