<style type="text/css">
    .main-body {
        padding: 15px;
    }

    .card {
        box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
    }

    .card {
        position: relative;
        display: flex;
        flex-direction: column;
        min-width: 0;
        word-wrap: break-word;
        background-color: #fff;
        background-clip: border-box;
        border: 0 solid rgba(0, 0, 0, .125);
        border-radius: .25rem;
    }

    .card-body {
        flex: 1 1 auto;
        min-height: 1px;
        padding: 1rem;
    }

    .gutters-sm {
        margin-right: -8px;
        margin-left: -8px;
    }

    .gutters-sm>.col,
    .gutters-sm>[class*=col-] {
        padding-right: 8px;
        padding-left: 8px;
    }

    .mb-3,
    .my-3 {
        margin-bottom: 1rem !important;
    }

    .bg-gray-300 {
        background-color: #e2e8f0;
    }

    .h-100 {
        height: 100% !important;
    }

    .shadow-none {
        box-shadow: none !important;
    }
</style>

<div class="col-12 d-flex justify-content-end mb-2">
    <a class="btn btn-info lang" key="Editar" href="<?= Yii::app()->createUrl('agencia/update', array('id' => $_SESSION['Agencia']->id_agencia)) ?>">Editar</a>
</div>

<div id="appagencia">


    <div class="row gutters-sm">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column align-items-center text-center">
                        <img :src="baseUrl+'/images/agencia/'+detalle_agencia.logotipo" alt="Admin" width="150">
                        <div class="mt-2">
                            <h4>{{detalle_agencia.nombre_comercial}}</h4>
                        </div>

                        <div v-if="detalle_agencia.sitio_web" class="mt-2 d-flex flex-column flex-md-row justify-content-center justify-content-md-between align-items-center">
                            <div class="mx-1">
                                <h6 class="mb-0">Sitio Web: <span class="text-secondary"><a class="text-secondary" :href="'//'+detalle_agencia.sitio_web" title="">{{detalle_agencia.sitio_web}}</a></span></h6>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card mb-3">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-4" v-html="Nombre">

                        </div>
                        <div class="col-sm-8 text-secondary">
                            {{detalle_agencia.nombre_comercial}}
                        </div>
                    </div>
                    <hr>
                    <div v-if="detalle_agencia.correo" class="row">
                        <div class="col-sm-4" v-html="Correo">
                        </div>
                        <div class="col-sm-8 text-secondary">
                            <a class="text-secondary" :href="'mailto:'+detalle_agencia.correo" title="">{{detalle_agencia.correo}}</a>
                        </div>
                    </div>
                    <hr>
                    <div v-if="detalle_agencia.telefono" class="row">
                        <div class="col-sm-4" v-html="Telefono">
                        </div>
                        <div class="col-sm-8 text-secondary">
                            <a class="text-secondary telefonoLabel" :href="'tel:'+detalle_agencia.telefono" title="">{{detalle_agencia.telefono.replace(/[^\d]/g, '').replace(/^([0-9]{3})([0-9]{3})([0-9]{4})$/, '($1) $2-$3')}}</a>
                        </div>
                    </div>
                    <hr>
                    <!-- <h1>whatsapp {{detalle_agencia.whatsapp}}</h1> -->
                    <div class="row">
                        <div class="col-sm-4">
                            <h6 class="mb-0 lang">Whatsapp</h6>
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.whatsapp">
                            <a class="text-secondary telefonoLabel" :href="'tel:'+detalle_agencia.whatsapp" title="">{{detalle_agencia.whatsapp.replace(/[^\d]/g, '').replace(/^([0-9]{3})([0-9]{3})([0-9]{4})$/, '($1) $2-$3')}}</a>
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin Whatsapp
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4" v-html="Direccion">
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.direccion">
                            {{detalle_agencia.direccion}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin dirección
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4" v-html="codpostal">
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.codigo_postal">
                            {{detalle_agencia.codigo_postal}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin código postal
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4" v-html="Ciudad">
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.ciudad">
                            {{detalle_agencia.ciudad}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin Ciudad
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4" v-html="Estado">
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.estado">
                            {{detalle_agencia.estado}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin Estado
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4">
                            <h6 class="mb-0">RFC</h6>
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.rfc">
                            {{detalle_agencia.rfc}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin RFC
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-sm-4">
                            <h6 class="mb-0">No. Registro SECTUR</h6>
                        </div>
                        <div class="col-sm-8 text-secondary" v-if="detalle_agencia.rnt">
                            {{detalle_agencia.rnt}}
                        </div>
                        <div class="col-sm-8 text-secondary" v-else>
                            Sin No. Registro SECTUR
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
//$_GET['id']
Yii::app()->clientScript->registerScript('headers', '
    var id_agencia = "' . $_SESSION['Agencia']->id_agencia . '";
    var baseUrl = "' . Yii::app()->baseUrl . '";
    ', CClientScript::POS_HEAD);

Yii::app()->clientScript->registerScriptFile("//cdn.jsdelivr.net/npm/sweetalert2@10", CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/agenciaVUE.js?v=' . time(), CClientScript::POS_END);
?>