<?php
// foreach ($usuarios as $usuario) {
//     echo $usuario->idUsuario->profiles->firstname;
// }
?>
<style type="text/css">
    div.dt-button-collection {
        background-color: currentColor;
    }

    .foto_perfil {
        width: 200px;
        border-radius: 50%;
    }

    .btn-masinfo {
        position: absolute;
        top: 5%;
        right: 5%;
        z-index: 5;
        background-color: transparent;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .btn-masinfo .icono-masinfo {
        color: #00CFE8;
        border-radius: 50%;
        font-size: 25px;
    }

    .m-top {
        margin-top: 80px;
    }

    .m-left {
        margin-left: 5px;
    }

    .foto-modal {
        width: 200px; 
        height: 200px; 
        margin: auto; 
        box-shadow: -9px 12px 15px -8px rgba(0,0,0,0.49);
        -webkit-box-shadow: -9px 12px 15px -8px rgba(0,0,0,0.49);
        -moz-box-shadow: -9px 12px 15px -8px rgba(0,0,0,0.49); 
        border:5px white solid; 
        border-radius: 5px;
    }
    .card-profile .card-body .profile-image-wrapper .profile-image img {
        object-fit: cover;
    }
</style>
<h1 class="text-center lang" key="Lista de Usuarios" >Lista de Usuarios</h1>
<a class="btn mb-2 btn-success lang" key="Nuevo Usuario" href="<?= Yii::app()->createUrl('usuariosAgencias/create'); ?>">Nuevo Usuario</a>
<div id="appusuarios">
    <div class="row">
        <div v-for="(usuario,index) in detalle_usuario" class="col-lg-4 col-md-6 col-12 m-top">
            <div class="card card-profile h-100 pb-2" style="position: relative;">
                <a class="btn-masinfo" data-bs-toggle="modal" :data-bs-target="'#exampleModal'+index"><i class="fas fa-info-circle icono-masinfo"></i></a>
                <div class="card-body">
                    <div class="profile-image-wrapper">
                        <div class="profile-image">
                            <div class="avatar">
                                <img :src="(usuario.foto == null) ? 'https://erp.2businesstravel.com/admin/images/erp/usuario-default.png' : (baseUrl + '/images/usuarios/' + usuario.foto)" alt="Profile Picture" />
                            </div>
                        </div>
                    </div>
                    <h3>{{usuario.idUsuario.profiles.firstname}}</h3>
                    <span class="badge badge-light-primary profile-badge">{{usuario.rol}}</span>
                        <div v-if="usuario.status_laboral != 1" class="d-flex align-items-center justify-content-center">
                            <p class="mb-0" v-html="Desactivado"></p>
                        </div>
                        <div v-else class="d-flex align-items-center justify-content-center">
                            <p class="mb-0" v-html="Activado"></p>
                        </div>
                    <hr class="mb-2" />                  
                    <div v-if="usuario.idUsuario.email" class="transaction-item mb-2" style="overflow-wrap: anywhere">
                        <div class="d-flex flex-row align-items-end">
                            <div class="avatar bg-light-primary rounded mr-3">
                                <div class="avatar-content">
                                    <i class="fas fa-envelope avatar-icon font-medium-3"></i>
                                </div>
                            </div>
                            <div class="transaction-info d-flex align-items-center m-left">
                                <h6 class="transaction-title">{{usuario.idUsuario.email}}</h6>
                            </div>
                        </div>
                    </div> 
                    
                    <div v-if="usuario.telefono" class="transaction-item">
                        <div class="d-flex flex-row align-items-end">
                            <div class="avatar bg-light-success rounded">
                                <div class="avatar-content">
                                    <i class="fas fa-phone avatar-icon font-medium-3"></i>
                                </div>
                            </div>
                            <div class="transaction-info d-flex align-items-center m-left">
                                <h6 class="transaction-title telefonoPrincipal" maxlength="10">{{usuario.telefono}}</h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 d-flex" style="padding-left: 2.3rem;">
                    <a class="btn btn-gradient-primary lang me-1" v-html="Editar" :href="'/admin/usuariosAgencias/update/id/' + usuario.id_usuario">Editar</a>
                    <button class="btn btn-outline-danger waves-effect" v-html="Eliminar" @click="eliminarUsuario(usuario.id_usuario)">Eliminar</button>
                </div>
                
            </div>
            <!-- Modal -->
            <div class="modal fade" :id="'exampleModal'+index" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><span v-html="infodetallada"></span> <span>{{usuario.idUsuario.profiles.firstname}}</span></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <ul class="list-group">
                                <li class="list-group-item d-flex align-items-center">
                                    <img class="foto-modal"  :src="(usuario.foto == null)?'https://erp.2businesstravel.com/admin/images/erp/usuario-default.png':'https://erp.2businesstravel.com/admin/images/usuarios/' + usuario.foto" alt="Profile Picture" />
                                </li>
                                <li v-if="usuario.idUsuario.profiles.firstname" class="list-group-item d-flex align-items-center">
                                    <i class="fas fa-user-tie me-1 font-medium-2"></i>
                                    <span v-html="Nombre">Nombre</span>:&nbsp;<span> {{usuario.idUsuario.profiles.firstname}} {{usuario.idUsuario.profiles.lastname}}.</span>
                                </li>
                                <li v-if="usuario.idUsuario.username" class="list-group-item d-flex align-items-center">
                                    <i class="far fa-user me-1 font-medium-2"></i>
                                    <span v-html="Usuario">Usuario</span>:&nbsp;<span> {{usuario.idUsuario.username}}.</span>
                                </li>
                                <li v-if="usuario.idUsuario.email" class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-envelope me-1 font-medium-2"></i>
                                    <span v-html="Correo">Correo</span>:&nbsp;<span> {{usuario.idUsuario.email}}.</span>
                                </li>
                                <li v-if="usuario.telefono" class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-phone me-1 font-medium-2"></i>
                                    <span v-html="Telefono">Télefono</span>:&nbsp;<span> {{usuario.telefono}}.</span>
                                </li>
                                <li v-if="usuario.direccion" class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-map-marker-alt me-1 font-medium-2"></i>
                                    <span v-html="Direccion">Dirección</span>:&nbsp;<span> {{usuario.direccion}}.</span>
                                </li>
                                <li v-if="usuario.fecha_nacimiento" class="list-group-item d-flex align-items-center">
                                	<i class="far fa-calendar-alt me-1 font-medium-2"></i>
                                    <span v-html="nacimiento">Fecha de nacimiento</span>:&nbsp;<span> {{formatDate(usuario.fecha_nacimiento, "DD/MM/YYYY")}}.</span>
                                </li>
                                <li v-if="usuario.idUsuario.lastvisit_at" class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-user-clock me-1 font-medium-2"></i>
                                    <span v-html="visita">Última visita</span>:&nbsp;<span> {{formatDate(usuario.idUsuario.lastvisit_at, "DD/MM/YYYY hh:mm:ss")}}.</span>
                                </li>
                                <li v-if="usuario.rol" class="list-group-item d-flex align-items-center">
                                	<i class="far fa-address-card me-1 font-medium-2"></i>
                                    <span v-html="Rol">Rol</span>:&nbsp;<span> {{usuario.rol}}.</span>
                                </li>
                                <li v-if="usuario.status_laboral != 1" class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-toggle-off me-1 font-medium-2"></i>
                                    <p class="mb-0">Status: <span class="badge rounded-pill bg-danger">Desactivado</span></p>
                                </li>
                                <li v-else class="list-group-item d-flex align-items-center">
                                	<i class="fas fa-toggle-on me-1 font-medium-2"></i>
                                    <p class="mb-0">Status: <span class="badge rounded-pill bg-success">Activo</span></p>
                                </li>
                            </ul>
                        </div>
                        <div class="modal-footer" v-html="Aceptar"></div>
                    </div>
                </div>
            </div>
            <!-- Fin Modal -->
        </div>
        <!--/ Profile Card -->
    </div>
</div>
<!-- Button trigger modal -->
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p style="font-weight: bold;">
                <h5 class="mt-3 mb-1">{{usuario.idUsuario.profiles.firstname}} {{usuario.idUsuario.profiles.lastname}}</h5>
                </p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.id_usuario}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.id_agencia}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.fecha_nacimiento}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.telefono}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.direccion}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.foto}}</a></p>
                <p><a title=""><i class="fas fa-people-carry"></i>{{usuario.rol}}</a></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
<?php
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/usuarios_agenciaVUE.js?v=' . time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.10/jquery.mask.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScript('masktel', "$('.telefonoPrincipal').mask('(000) 000-0000');", CClientScript::POS_READY);
?>
