<style type="text/css">
	.text-right {
		text-align: right;
	}

	.cont-datatable {
		padding: 1.5rem;
	}

	.dataTables_filter {
		display: flex;
		justify-content: flex-end;
		align-items: center;
	}

	.dataTables_filter label {
		display: flex;
		align-items: center;
	}
</style>
<section id="grupos">
	<div class="row">
		<div class="col-12">
			<div class="card">
				<div class="card-header border-bottom">
					<h4 class="card-title lang" key="Mis Grupos">Mis <?= $group_type; ?></h4>
					<!-- <div class="float-end">
						<a class="btn btn-primary" href="<?= Yii::app()->createUrl('grupos/create') ?>">
							<i data-feather="plus"></i> 
							<span class="lang" key="Nuevo Grupo">Nueva Boda</span>
						</a>
					</div> -->
				</div>
				<div class="cont-datatable">
					<table class="datatable table display nowrap" style="width:100%">
						<thead>
							<tr>
								<th># Folio</th>
								<th>Titulo del Evento</th>
								<th>Pasajero Titular</th>
								<th>Habs.</th>
								<th>Noches</th>
								<th>Hotel</th>
								<th>Tipo de Habitacion</th>
								<th class="text-center"></th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="update-modal" tabindex="-1" aria-labelledby="modalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            	<div class="modal-header">
                    <h5 class="modal-title" id="modalTitle" v-text="'Editar ' + group_type.slice(0, -1)"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-1">
						<label class="form-label">Título</label>
						<input type="text" class="form-control" v-model="group_model.titulo_evento">
					</div>
					<div class="mb-1">
						<label class="form-label">Hotel</label>
						<input type="text" class="form-control" v-model="group_model.hotel">
					</div>
					<div class="mb-1">
						<label class="form-label">Tipo Habitación</label>
						<input type="text" class="form-control" v-model="group_model.tipo_habitacion">
					</div>
					<div class="mb-1">
						<label class="form-label">Habitaciones</label>
						<input type="number" class="form-control" v-model="group_model.num_habitaciones">
					</div>
					<div class="mb-1">
						<label class="form-label">Condiciones</label>
						<textarea cols="30" rows="3" class="form-control" v-model="group_model.condiciones"></textarea>
					</div>
					<div class="mb-1">
						<label class="form-label">Estatus</label>
						<select class="form-control" v-model="group_model.estatus">
							<option value="Activo">Activo</option>
							<option value="Desactivado">Desactivado</option>
						</select>
					</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" @click="updateGroup()">Guardar</button>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
	Yii::app()->clientScript->registerScript('vars', '
		var baseUrl = "'. Yii::app()->baseUrl .'";
		var group_type = "'. $group_type .'";
	', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/fixedcolumns/4.0.0/js/dataTables.fixedColumns.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/groups-index.js?v='. time(), CClientScript::POS_END);
?>