<?php
    $sale_model = Ventas::model()->findByPk($sale_code);
    $services_array = VentasServicios::model()->findAll("id_venta = $sale_code");
    $customer_model = Clientes::model()->findByPk($sale_model->id_cliente);

    $date = date_create($sale_model->log);
    $date_created = date_format($date, "d/m/Y H:i:s");
?>

<section>
    <table>
        <tr>
            <td align="right">Venta: <?= $sale_model->folio; ?></td>
        </tr>
        <tr>
            <td align="right">Fecha: <?= date_format(date_create($sale_model->log), "d/m/Y"); ?></td>
        </tr>
        <tr>
            <td align="right">Hora: <?= date_format(date_create($sale_model->log), "H:i:s"); ?></td>
        </tr>
        <tr>
            <td>Información Cliente:</td>
        </tr>
        <tr>
            <td><?= $customer_model->nombre; ?></td>
        </tr>
        <tr>
            <td><?= $customer_model->telefono; ?></td>
        </tr>
        <tr>
            <td><?= $customer_model->correo; ?></td>
        </tr>
    </table>
    
    <hr>

    <table style="border-collapse:separate; border-spacing:0 15px;">
        <tr>
            <td colspan="2">Descripción</td>
            <td>Servicio</td>
            <td>Lim. Pago</td>
            <td align="right">Total</td>
        </tr>
        <?php $total_sale = 0; ?>
        <?php foreach ($services_array as $key => $service): ?>
            <?php
                $subtotal = floatval($service->tarifa_publica) + floatval($service->fee);
                if($key == 0) $subtotal += $sale_model->cargo_servicios;
                $total_sale += $subtotal;
                $limit_date = (is_null($service->limite_cliente) || $service->limite_cliente == "0000-00-00") ? $service->fecha_limite : $service->limite_cliente;
            ?>
            <tr>
                <td colspan="2"><?= $service->descripcion; ?></td>
                <td><?= $service->idTipoServicio->tipo_servicio; ?></td>
                <td><?= date_format(date_create($limit_date), "d/m/Y"); ?></td>
                <td align="right">$<?= number_format($subtotal, 2); ?></td>
            </tr>
        <?php endforeach; ?>
        <tr>
            <td align="right" colspan="4">Total</td>
            <td align="right">$<?= number_format($total_sale, 2); ?></td>
        </tr>
        <?php 
            /* $balance = $total - (floatval($model_pago->monto) + $total_payments);
            $formatterES = new NumberFormatter("es", NumberFormatter::SPELLOUT);
            $letter_balance = $formatterES->format(floatval($model_pago->monto)); */
        ?>
    </table>
</section>