<style>
	.invoice-add .invoice-total-wrapper,
	.invoice-edit .invoice-total-wrapper,
	.invoice-preview .invoice-total-wrapper {
		max-width: 100%;
	}
	.border-box {
		border: 1px solid #EBE9F1;
		border-radius: 0.357rem;
		padding: 1rem;
	}

	.services-mosaic {
		width: 100%;
		height: 100%;
		position: relative;
	}
</style>

<div id="app-caja" class="ecommerce-application">
	<div class="bs-stepper checkout-tab-steps">
		<!-- Wizard starts -->
		<div class="bs-stepper-header">
			<div class="step" data-target="#step-sales" role="tab" id="step-sales-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="shopping-cart" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Ventas</span>
						<span class="bs-stepper-subtitle">Ventas realizadas en sistema</span>
					</span>
				</button>
			</div>
			<div class="line">
				<i data-feather="chevron-right" class="font-medium-2"></i>
			</div>
			<div class="step" data-target="#step-payment" role="tab" id="step-payment-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="credit-card" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Pago</span>
						<span class="bs-stepper-subtitle">Seleccione el método de pago</span>
					</span>
				</button>
			</div>
			<div class="line">
				<i data-feather="chevron-right" class="font-medium-2"></i>
			</div>
			<div class="step" data-target="#step-info" role="tab" id="step-info-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="home" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Información</span>
						<span class="bs-stepper-subtitle">Detalle de la venta</span>
					</span>
				</button>
			</div>
		</div>
		<!-- Wizard ends -->

		<div class="bs-stepper-content">
			<!-- sale selector tab -->
			<div id="step-sales" class="content" role="tabpanel" aria-labelledby="step-sales-trigger">
				<div id="place-order" class="list-view product-checkout">
					<!-- Checkout Place Order Left starts -->
					<div class="checkout-items">
						<div class="card">
							<div class="row p-1">
								<div class="col mb-1">
									<label class="form-label" for="code-filter">Folio</label>
									<input type="text" class="form-control" id="code-filter" v-model="code_filter" />
								</div>
								<div class="col mb-1">
									<label class="form-label" for="name-filter">Nombre</label>
									<input type="text" class="form-control" id="name-filter" v-model="name_filter" />
								</div>
								<div class="col mb-1">
									<label class="form-label" for="service-filter">Servicio</label>
									<select class="form-control" id="service-filter" v-model="service_filter">
										<option value="">Todos</option>
										<option :value="service.id_servicio" v-text="service.tipo_servicio" v-for="service in services_array"></option>
									</select>
								</div>
								<div class="col mb-1">
									<label class="form-label" for="paid-filter">Pagado</label>
									<select class="form-control" id="paid-filter" v-model="status_filter">
										<option :value="1">Si</option>
										<option :value="0">No</option>
									</select>
								</div>
							</div>
						</div>
						<div class="card ecommerce-card" v-for="(sale, index) in filteredSales">
							<div class="item-img">
								<a class="services-mosaic" href="javascript:;" v-html="getServicesImages(sale, index)"></a>
							</div>
							<div class="card-body">
								<div class="item-name">
									<h6 class="mb-0"><span class="text-body" v-text="sale.pasajero_titular"></span></h6>
									<span class="item-company">Folio <span class="company-name" v-text="sale.folio"></span></span>
								</div>
								<p v-text="sale.descripcion"></p>
								<span class="delivery-date text-muted mb-2" v-text="'Hecho ' + formatDate(sale.log)"></span>
							</div>
							<div class="item-options text-center">
								<div class="item-wrapper">
									<div class="item-cost">
										<h4 class="item-price" v-text="getSaleBalance(sale) + sale.moneda"></h4>
									</div>
								</div>
								<button type="button" class="btn btn-primary btn-next btn-cart move-cart" @click="setSaleModels(sale.id_venta)">
									<i data-feather="dollar-sign" class="align-middle me-25"></i>
									<span class="text-truncate">Agregar pago</span>
								</button>
							</div>
						</div>
					</div>
					<!-- Checkout Place Order Left ends -->

					<!-- Checkout Place Order Right starts -->
					<div class="checkout-options">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Detalle saldo total</h4>
							</div>
							<div class="card-body">
								<div class="price-details">
									<ul class="list-unstyled">
										<li class="price-detail">
											<div class="detail-title">Total</div>
											<div class="detail-amt" v-text="total_amount + ' MXN'"></div>
										</li>
										<li class="price-detail">
											<div class="detail-title">Pagos</div>
											<div class="detail-amt discount-amt text-success" v-text="total_payments + ' MXN'"></div>
										</li>
									</ul>
									<hr />
									<ul class="list-unstyled">
										<li class="price-detail">
											<div class="detail-title detail-total">Saldo</div>
											<div class="detail-amt fw-bolder" v-text="total_balance + ' MXN'"></div>
										</li>
									</ul>
								</div>
							</div>
						</div>
						<!-- Checkout Place Order Right ends -->
					</div>
				</div>
				<!-- Checkout Place order Ends -->
			</div>
			<!-- sale selector tab -->
			<!-- Checkout Payment Starts -->
			<div id="step-payment" class="content" role="tabpanel" aria-labelledby="step-payment-trigger">
				<div id="checkout-payment" class="list-view product-checkout" v-if="sale_model.id_venta">
					<div class="payment-type">
						<div class="card">
							<div class="card-header flex-column align-items-start">
								<h4 class="card-title" v-if="payment_model.id_pago >= 0">Editar pago</h4>
								<h4 class="card-title" v-else>Registrar nuevo pago</h4>
								<p class="card-text text-muted mt-25">Ingrese los datos del pago realizado
								</p>
							</div>
							<div class="card-body">
								<div class="row mb-1">
									<div class="col-3">
										<label class="form-label">Fecha de pago</label>
										<input class="form-control" type="date" v-model="payment_model.fecha">
									</div>
									<div class="col-3">
										<div>
											<label class="form-label">Forma de pago</label>
											<select class="form-control" v-model="payment_model.id_forma_pago">
												<option :value="way.id_tipo" v-text="way.descripcion" v-for="(way, index) in ways_to_pay"></option>
											</select>
										</div>
										<div class="mt-1" v-show="!wayToPayAccount(payment_model.id_forma_pago)">
											<label for="account-select">Cuenta pago</label>
											<select id="account-select" class="form-control" v-model="payment_model.id_cuenta">
												<option value="">--Seleccione--</option>
												<option v-for="account in accounts_array" :value="account.id_cuenta" v-text="account.descripcion"></option>
											</select>
										</div>
									</div>
									<div class="col">
										<label class="form-label">Observaciones</label>
										<textarea class="form-control" cols="30" rows="1" v-model="payment_model.descripcion"></textarea>
									</div>
								</div>
								<div class="border-box mb-1" v-for="(service, index) in sale_model.ventasServicioses">
									<div class="row">
										<div class="col-3">
											<h6>Servicio</h6>
											<p v-text="service.idTipoServicio.tipo_servicio"></p>
										</div>
										<div class="col-3">
											<h6>Proveedor</h6>
											<p v-text="service.idProveedor.nombre_comercial"></p>
										</div>
										<div class="col">
											<h6>Descripción</h6>
											<p v-text="service.descripcion"></p>
										</div>
									</div>

									<div class="row">
										<div class="col">
											<label class="form-label">Monto</label>
											<input class="form-control" type="number" step="any" v-model="payment_model.payment_details[index].monto">
										</div>
										<div class="col">
											<label class="form-label">Saldo</label>
											<h5 v-text="getServiceBalance(service, index)"></h5>
											<!-- <input type="text" class="form-control-plaintext" readonly> -->
										</div>
									</div>
								</div>
								<div class="mb-1">
									<label class="form-label">Comprobante</label>
									<input id="dropify" class="form-control" type="file" accept="image/*" @change="setFileToModel">
								</div>
								<button type="button" class="btn btn-primary" @click="confirmSave()">Guardar</button>
							</div>
						</div>
					</div>
					<div class="amount-payable checkout-options">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Saldo Venta</h4>
							</div>
							<div class="card-body">
								<ul class="list-unstyled price-details">
									<li class="price-detail">
										<div class="details-title">Total</div>
										<div class="detail-amt">
											<strong v-text="sale_amount + ' MXN'"></strong>
										</div>
									</li>
									<li class="price-detail">
										<div class="details-title">Pagos</div>
										<div class="detail-amt discount-amt text-success" v-text="sale_payments + ' MXN'"></div>
									</li>
								</ul>
								<hr />
								<ul class="list-unstyled price-details">
									<li class="price-detail">
										<div class="details-title">Saldo a pagar</div>
										<div class="detail-amt fw-bolder" v-text="sale_balance + ' MXN'"></div>
									</li>
								</ul>
								<button type="button" class="btn btn-primary w-100 btn-next delivery-address" @click="nextStep()">
									Ver detalle
								</button>
							</div>
						</div>
					</div>
				</div>
				<div class="card mt-2" v-else>
					<div class="card-body">
						<h3>Seleccione una venta para realizar un pago</h3>
					</div>
				</div>
			</div>
			<!-- Checkout Payment Ends -->
			<!-- Checkout Customer Address Starts -->
			<div id="step-info" class="content" role="tabpanel" aria-labelledby="step-info-trigger">
				<div id="checkout-address" class="list-view product-checkout" v-if="sale_model.id_venta">
					<!-- Checkout Customer Address Left starts -->
					<div class="card">
						<div class=invoice-preview>
							<div class="invoice-preview-card">
								<div class="card-body invoice-padding pb-0">
									<!-- Header starts -->
									<div class="d-flex justify-content-between flex-md-row flex-column invoice-spacing mt-0">
										<div>
											<?php $this->renderPartial("/site/_infoAgenciaInvoice"); ?>
										</div>
										<div class="mt-md-0 mt-2">
											<h4 class="invoice-title">
												Folio
												<span class="invoice-number" v-text="'# ' + sale_model.folio"></span>
											</h4>
											<div class="invoice-date-wrapper">
												<p class="invoice-date-title">Realizada:</p>
												<p class="invoice-date" v-text="formatDate(sale_model.fecha)"></p>
											</div>
											<div class="invoice-date-wrapper">
												<p class="invoice-date-title">Guardado:</p>
												<p class="invoice-date" v-text="formatDate(sale_model.log)"></p>
											</div>
											<div class="invoice-date-wrapper">
												<p class="invoice-date-title">Cargos por servicios:</p>
												<p class="invoice-date" v-text="'$ ' + (sale_model.cargo_servicios ? sale_model.cargo_servicios : '0.00')"></p>
											</div>
										</div>
									</div>
									<!-- Header ends -->
								</div>

								<hr class="invoice-spacing" />

								<!-- Address and Contact starts -->
								<div class="card-body invoice-padding pt-0">
									<div class="row invoice-spacing">
										<div class="col-xl-8 p-0">
											<h6 class="mb-2">Información cliente:</h6>
											<h6 class="mb-25" v-text="sale_model.idCliente.nombre"></h6>
											<p class="card-text mb-25" v-text="sale_model.idCliente.telefono"></p>
											<p class="card-text mb-0" v-text="sale_model.idCliente.correo"></p>
										</div>
										<div class="col-xl-4 p-0 mt-xl-0 mt-2">
											<!-- <h6 class="mb-2">Información venta:</h6>
											<table>
												<tbody>
													<tr>
														<td class="pe-1">Monto total:</td>
														<td><span class="fw-bold" v-text="sale_balance + ' MXN'"></span></td>
													</tr>
													<tr>
														<td class="pe-1">Bank name:</td>
														<td>American Bank</td>
													</tr>
													<tr>
														<td class="pe-1">Country:</td>
														<td>United States</td>
													</tr>
													<tr>
														<td class="pe-1">IBAN:</td>
														<td>ETD95476213874685</td>
													</tr>
													<tr>
														<td class="pe-1">SWIFT code:</td>
														<td>BR91905</td>
													</tr>
												</tbody>
											</table> -->
										</div>
									</div>
								</div>
								<!-- Address and Contact ends -->

								<!-- Invoice Description starts -->
								<div class="table-responsive">
									<table class="table">
										<thead>
											<tr>
												<th class="py-1">Descripción</th>
												<th class="py-1">Servicio</th>
												<th class="py-1">Inicio</th>
												<th class="py-1">Fin</th>
												<th class="py-1">Total</th>
											</tr>
										</thead>
										<tbody>
											<tr v-for="(service_sale, i) in sale_model.ventasServicioses">
												<td class="py-1">
													<p class="card-text fw-bold mb-25" v-text="service_sale.idProveedor.nombre_comercial"></p>
													<p class="card-text text-nowrap" v-text="service_sale.descripcion"></p>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="service_sale.idTipoServicio.tipo_servicio"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="formatDate(service_sale.inicio_servicio)"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="formatDate(service_sale.fin_servicio)"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="getTotalSale(service_sale, i)"></span>
												</td>
											</tr>
										</tbody>
									</table>
								</div>

								<div class="card-body invoice-padding pb-0">
									<div class="row invoice-sales-total-wrapper">
										<div class="col-md-6 order-md-1 order-2 mt-md-0 mt-3">
											<!-- <p class="card-text mb-0">
												<span class="fw-bold">Vendedor:</span> <span class="ms-75">Alfie Solomons</span>
											</p> -->
										</div>
										<div class="col-md-6 d-flex justify-content-end order-md-2 order-1">
											<div class="invoice-total-wrapper">
												<div class="invoice-total-item">
													<p class="invoice-total-title">Total:</p>
													<p class="invoice-total-amount" v-text="sale_amount + ' MXN'"></p>
												</div>
												<div class="invoice-total-item">
													<p class="invoice-total-title">Pagado:</p>
													<p class="invoice-total-amount" v-text="sale_payments + ' MXN'"></p>
												</div>
												<hr class="my-50" />
												<div class="invoice-total-item">
													<p class="invoice-total-title">Saldo:</p>
													<p class="invoice-total-amount" v-text="sale_balance + ' MXN'"></p>
												</div>
											</div>
										</div>
									</div>
								</div>
								<!-- Invoice Description ends -->
							</div>
						</div>
					</div>
					<!-- Checkout Customer Address Left ends -->

					<!-- Checkout Customer Address Right starts -->
					<div class="customer-card">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Pagos realizados</h4>
							</div>
							<!-- <ul class="list-group list-group-flush" v-for="service in sale_model.ventasServicioses">
								<li class="list-group-item" v-for="payment in service.pagosDetalles">
									<div class="row">
										<div class="col" v-text="formatDate(payment.log)"></div>
										<div class="col" v-text="formatPrice(payment.monto)"></div>
										<div class="col-2"><a :href="baseUrl + '/caja/viewInvoice/' + payment.id_pago" target="_blank"><i data-feather="eye"></i></a></div>
									</div>
								</li>
							</ul> -->
							<ul class="list-group list-group-flush">
								<li class="list-group-item" v-for="payment in sale_payments_array">
									<div class="row">
										<div class="col" v-text="getPaymentDate(payment)"></div>
										<div class="col" v-text="calculateSalePayments(payment.pagosDetalles)"></div>
										<div class="col-3 text-end">
											<a :href="baseUrl + '/caja/viewInvoice/' + payment.id_pago" target="_blank"><i data-feather="eye"></i></a>
											<a class="ms-25" href="javascript:void(0)" @click="editPayment(payment)"><i data-feather="edit"></i></a>
											<a class="ms-25" :href="baseUrl + '/images/comprobantes/pagos/' + payment.comprobante" target="_blank" v-if="payment.comprobante != null"><i data-feather="image"></i></a>
											<a class="ms-25" href="javascript:void(0)" @click="showDeleteAlert(payment)"><i data-feather="trash"></i></a>
										</div>
									</div>
								</li>
							</ul>
							<div class="card-body actions" v-if="!check_sale_payments">
								<p class="card-text">No hay pagos registrados.</p>
							</div>
						</div>
					</div>
					<!-- Checkout Customer Address Right ends -->
				</div>
				<div class="card mt-2" v-else>
					<div class="card-body">
						<h3>Seleccione una venta para ver la información</h3>
					</div>
				</div>
			</div>
			<!-- Checkout Customer Address Ends -->
		</div>
	</div>

	<div class="modal fade text-start" id="invoice-modal" tabindex="-1" aria-labelledby="invoice-label" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="invoice-label">Enviar recibo de pago</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div class="alert alert-primary" role="alert" v-if="loading_payment && payment_model.id_pago == 0">
						<div class="alert-body d-flex align-items-center">
							<i class="me-50 spinner" data-feather="loader"></i><span> Guardando pago</span>
						</div>
					</div>
					<div class="alert alert-success" role="alert" v-else-if="!loading_payment && payment_model.id_pago >= 0">
						<div class="alert-body">Pago guardado con éxito</div>
					</div>
					<div class="alert alert-danger" role="alert" v-else>
						<div class="alert-body">Error al guardar el pago, recargue la página e intente de nuevo</div>
					</div>
					<div class="mb-1">
						<label for="email-input" class="form-label">Correo electrónico</label>
						<div class="input-group">
							<input type="email" class="form-control" id="email-input" aria-describedby="btn-send" v-model="email_model">
							<button class="btn btn-outline-primary" id="btn-send" type="button" @click="sendInvoice()">Enviar</button>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
					<!-- <a :href="baseUrl + '/caja/viewInvoice/' + payment_model.id_pago" id="btn-print" class="btn btn-primary" target="_blank">Imprimir</a> -->
					<a :href="baseUrl + '/caja/viewInvoice/' + id_payment" id="btn-print" class="btn btn-primary" target="_blank">Imprimir</a>
				</div>
			</div>
		</div>
	</div>
</div>

<?php
	Yii::app()->clientScript->registerScript('id0', '
			var baseUrl = "' . Yii::app()->baseUrl . '";
		', CClientScript::POS_END);

	$baseUrl = "https://erp.2businesstravel.com/admin/template/vuexy";
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/core/menu/menu-types/vertical-menu.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/pages/app-invoice.min.css');

	Yii::app()->clientScript->registerCssFile($baseUrl .'/vendors/css/forms/wizard/bs-stepper.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/pages/app-ecommerce.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/plugins/forms/form-wizard.min.css');

	Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css');
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile($baseUrl .'/vendors/js/forms/wizard/bs-stepper.min.js', CClientScript::POS_END);
	//Yii::app()->clientScript->registerScriptFile($baseUrl .'/js/scripts/forms/form-wizard.min.js', CClientScript::POS_END);
	//Yii::app()->clientScript->registerScriptFile($baseUrl .'/js/scripts/pages/app-ecommerce-checkout.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/freewall@1.0.8/freewall.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/caja-index.js?v='. time(), CClientScript::POS_END);
?>