<?php
    $payment_model = Pagos::model()->findByPk($payment_code);
    $payment_details = PagosDetalle::model()->findAll("id_pago = $payment_code");
    $service_array = VentasServicios::model()->findAll("id_venta = ". $payment_details[0]->idVentaservicio->id_venta);
    $sale_model = Ventas::model()->findByPk($service_array[0]->id_venta);

    $usuario_creo_pago = Profiles::model()->findByPk($payment_model->id_usuario);

    $cur_payment = 0;
    foreach ($payment_details as $key => $value) {
        $cur_payment += floatval($value->monto);
    }
    $details_codes = "";
    foreach ($service_array as $key => $service) {
        $details_codes .= $service->id_ventaservicio . ",";
    }
    $details_codes = rtrim($details_codes, ",");

    $previous_payments = PagosDetalle::model()->findAll("id_pago != $payment_model->id_pago AND id_ventaservicio IN ($details_codes)");
    $total_payments = 0;
    $balance = 0;
    foreach ($previous_payments as $key => $value) {
        if($value->idPago->fecha == $payment_model->fecha) {
            if($value->idPago->log < $payment_model->log) $total_payments += floatval($value->monto);
        } else {
            if($value->idPago->fecha < $payment_model->fecha) $total_payments += floatval($value->monto);
        }
    }

    $customer_model = Clientes::model()->findByPk($sale_model->id_cliente);
    $payment_date_aux = date_format(date_create($payment_model->log), "Y-m-d");
    $payment_date = $payment_date_aux == $payment_model->fecha ? $payment_model->log : $payment_model->fecha;
    $payment_format_date = $payment_date_aux == $payment_model->fecha ? "d/m/Y H:i:s" : "d/m/Y";
?>

<section>
    <table>
        <tr>
            <td align="right"><?= date_format(date_create($payment_date), "d/m/Y"); ?></td>
        </tr>
        <tr>
            <td align="right">Venta #<?= $sale_model->folio; ?></td>
        </tr>
        <tr>
            <td align="right">Recibo #<?= $payment_model->id_pago; ?></td>
        </tr>
        <tr>
            <td align="right">Agente: <?= $usuario_creo_pago->firstname . " " . $usuario_creo_pago->lastname ?></td>
        </tr>
        
        <tr>
            <td>Información Cliente:</td>
        </tr>
        <tr>
            <td><?= $customer_model->nombre; ?></td>
        </tr>
        <tr>
            <td><?= $customer_model->telefono; ?></td>
        </tr>
        <tr>
            <td><?= $customer_model->correo; ?></td>
        </tr>
    </table>

    <hr>

    <table style="border-collapse:separate; border-spacing:0 15px;">
        <tr>
            <td colspan="2">Descripción</td>
            <td>Servicio</td>
            <td>Lim. Pago</td>
            <td>Total</td>
        </tr>
        <?php $total = 0; ?>
        <?php foreach ($service_array as $key => $service) : ?>
            <?php
            $subtotal = floatval($service->tarifa_publica) + floatval($service->fee);
            if($key == 0) $subtotal += floatval($sale_model->cargo_servicios);
            $total += $subtotal;
            $limit_date = is_null($service->limite_cliente) ? $service->fecha_limite : $service->limite_cliente;
            ?>
            <tr>
                <td colspan="2"><?= $service->descripcion; ?></td>
                <td><?= $service->idTipoServicio->tipo_servicio; ?></td>
                <td><?= date_format(date_create($limit_date), "d/m/Y"); ?></td>
                <td align="right">$<?= number_format($subtotal, 2); ?></td>
            </tr>
        <?php endforeach; ?>
        <?php
        $balance = $total - ($cur_payment + $total_payments);
        $formatterES = new NumberFormatter("es", NumberFormatter::SPELLOUT);
        $letter_balance = $formatterES->format(floatval($cur_payment));
        ?>
    </table>

    <hr>
    <table style="border-collapse:separate; border-spacing:0 10px;">
        <tr>
            <td colspan="5" align="right">Total Compra</td>
            <td align="right">$<?= number_format($total, 2); ?></td>
        </tr>
        <tr>
            <td colspan="5" align="right">Pagos anteriores</td>
            <td align="right">$<?= number_format($total_payments, 2); ?></td>
        </tr>
        <tr>
            <td colspan="5" align="right">
                SE RECIBE LA CANTIDAD DE $<?= number_format($cur_payment, 2); ?> (<?= $letter_balance; ?> pesos 00/100), POR CONCEPTO DE LA VENTA <?= $sale_model->folio; ?> MEDIANTE <?= $payment_model->idFormaPago->descripcion; ?> A <?= date_format(date_create($payment_date), $payment_format_date); ?>
            </td>
            <td align="right"><strong>$<?= number_format($cur_payment, 2); ?></strong></td>
        </tr>
        <tr>
            <td colspan="5" align="right">Saldo</td>
            <td align="right" style="font-weight: bold;">$<?= number_format($balance, 2); ?></td>
        </tr>
    </table>
    <?php if ($payment_model->descripcion != null) : ?>
        <p>Observaciones: <?= $payment_model->descripcion ?></p>
    <?php endif ?>

    <p>&nbsp;</p>
    <br>
    <p>&nbsp;</p>
    <br>
    <p>&nbsp;</p>

    <table>
        <tr>
            <th width="30%"></th>
            <th width="40%" style="border-bottom: 2px solid black;"></th>
            <th width="30%"></th>
        </tr>
    </table>
    <p style="text-align: center; font-size: 40px;"><?= $customer_model->nombre; ?></p>

</section>