<style type="text/css">
	div.dt-button-collection{
		background-color: currentColor;
	}

	.dataTables_length {
        margin-left: 1rem;
    }

    .dataTables_info {
        margin-left: 1rem;
    }

    .dataTables_filter {
        margin-right: 1rem;
    }

    .dataTables_paginate {
        margin-right: 1rem!important;
    }
</style>

<section id="clients-app">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">Clientes</h4>
                    <div class="float-end">
                        <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#cu-customers" @click="clearCustomerModel()"><i data-feather="plus"></i> Cliente</button>
                    </div>
                </div>
                <div class="card-datatable">
                    <table class="table" id="clients-table"></table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-start" id="billing-info" tabindex="-1" aria-labelledby="billing-label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <form action="#" class="modal-content" autocomplete="off" @submit.prevent="addBillingInfo()">
                <div class="modal-header">
                    <h4 class="modal-title" id="billing-label">Información de facturación</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-6">
                            <label class="form-label">RFC *</label>
                            <input type="text" class="form-control" v-model="billing_model.rfc" required>
                        </div>
                        <div class="col-6">
                            <label class="form-label">Razón Social *</label>
                            <input type="text" class="form-control" v-model="billing_model.razon_social" required>
                        </div>

                        <div class="col-2">
                            <label class="form-label">Calle</label>
                            <input type="text" class="form-control" v-model="billing_model.calle">
                        </div>
                        <div class="col-2">
                            <label class="form-label">No. Exterior</label>
                            <input type="text" class="form-control" v-model="billing_model.no_exterior">
                        </div>
                        <div class="col-2">
                            <label class="form-label">No. Interior</label>
                            <input type="text" class="form-control" v-model="billing_model.no_interior">
                        </div>
                        <div class="col-2">
                            <label class="form-label">CP *</label>
                            <input type="text" class="form-control" v-model="billing_model.cp" required>
                        </div>
                        <div class="col-4">
                            <label class="form-label">Colonia</label>
                            <input type="text" class="form-control" v-model="billing_model.colonia">
                        </div>

                        <div class="col-3">
                            <label class="form-label">Municipio</label>
                            <input type="text" class="form-control" v-model="billing_model.municipio">
                        </div>
                        <div class="col-3">
                            <label class="form-label">Ciudad</label>
                            <input type="text" class="form-control" v-model="billing_model.ciudad">
                        </div>
                        <div class="col-3">
                            <label class="form-label">Estado</label>
                            <input type="text" class="form-control" v-model="billing_model.estado">
                        </div>
                        <div class="col-3">
                            <label class="form-label">País</label>
                            <input type="text" class="form-control" v-model="billing_model.pais">
                        </div>

                        <div class="col-3">
                            <label class="form-label">Correo</label>
                            <input type="email" class="form-control" v-model="billing_model.correo">
                        </div>
                        <div class="col-3">
                            <label class="form-label">Uso de CFDI</label>
                            <input type="text" class="form-control" v-model="billing_model.cfdi">
                        </div>
                        <div class="col-3">
                            <label class="form-label">Método de pago</label>
                            <input type="text" class="form-control" v-model="billing_model.metodo_pago">
                        </div>
                        <div class="col-3">
                            <label class="form-label">Forma de pago</label>
                            <input type="text" class="form-control" v-model="billing_model.forma_pago">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade text-start" id="client-user" tabindex="-1" aria-labelledby="client-user-label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <form action="#" class="modal-content" autocomplete="off" @submit.prevent="createClientUser()">
                <div class="modal-header">
                    <h4 class="modal-title" id="client-user-label">Complete la información del usuario</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="text" style="display:none;">
                    <input type="password" style="display:none;">
                    <div class="row">
                        <div class="col-6">
                            <label class="form-label">Nombre(s)</label>
                            <input type="text" autocomplete="off" class="form-control" v-model="user_model.firstname">
                        </div>
                        <div class="col-6">
                            <label class="form-label">Apellidos</label>
                            <input type="text" autocomplete="off" class="form-control" v-model="user_model.lastname">
                        </div>
                        <div class="col-6">
                            <label class="form-label">Usuario</label>
                            <input type="text" autocomplete="off" class="form-control" v-model="user_model.user">
                        </div>
                        <div class="col-6">
                            <label class="form-label">Contraseña</label>
                            <input type="password" autocomplete="off" class="form-control" v-model="user_model.pwd">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
</section>

<?= $this->renderPartial("_form"); ?>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var view = "index";
    ', CClientScript::POS_HEAD);
	Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css');
	Yii::app()->clientScript->registerCssFile('https://cdn.datatables.net/1.11.3/css/dataTables.bootstrap5.min.css');
	Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/clientes-index.js?v='.time(), CClientScript::POS_END);
?>