<style>
    .invoice-add .invoice-preview-card .invoice-product-details, .invoice-edit .invoice-preview-card .invoice-product-details {
        padding: 0rem 3.45rem 0rem;
    }
    .list-group-item {
        padding: 0.75rem 0rem;
    }
    .float-btn {
        position: fixed; margin-right: 2rem; width: 18%;
    }
    [v-cloak] {
        display: none;
    }
</style>

<section id="app-contracts" class="invoice-add-wrapper" v-cloak>
    <form action="#" @submit.prevent="saveSale">
        <div class="row invoice-add">
            <!-- Invoice Add Left starts -->
            <div class="col-xl-9 col-md-8 col-12">
                <div class="card invoice-preview-card">
                    <!-- Header starts -->
                    <div class="card-body invoice-padding pb-0">
                        <div class="d-flex justify-content-between flex-md-row flex-column invoice-spacing mt-0">
                            <div>
                                <?php $this->renderPartial("/site/_infoAgenciaInvoice"); ?>
                            </div>
                            <div class="invoice-number-date mt-md-0 mt-2">
                                <div class="d-flex align-items-center mb-1" v-if="action == 'update'">
                                    <span class="title">Fecha *</span>
                                    <input type="text" class="form-control invoice-edit-input date-picker" disabled />
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="title">Moneda *</span>
                                    <select type="text" class="form-control invoice-edit-input" v-model="price_model.moneda">
                                        <option value="MXN">MXN</option>
                                        <option value="USD">USD</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Header ends -->

                    <hr class="invoice-spacing" />

                    <!-- Address and Contact starts -->
                    <div class="card-body invoice-padding pt-0">
                        <div class="row row-bill-to invoice-spacing">
                            <div class="col-xl-5 mb-lg-1 col-bill-to ps-0">
                                <h6 class="invoice-to-title">Vendido a *</h6>
                                <div class="invoice-customer">
                                    <select class="invoiceto form-select" required>
                                        <option></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-xl-7 p-0 ps-xl-2 mt-xl-0 mt-2">
                                <div class="customer-details mt-1">
                                    <p class="mb-25">
                                        <strong>Nombre:</strong> <span v-if="customer_selected.id" v-text="customer_selected.text"></span>
                                    </p>
                                    <p class="mb-0">
                                        <strong>Teléfono:</strong> <span v-if="customer_selected.id" v-text="customer_selected.phone"></span>
                                    </p>
                                    <p class="mb-0">
                                    <strong>Correo:</strong> <span v-if="customer_selected.id" v-text="customer_selected.mail"></span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Address and Contact ends -->

                    <!-- Product Details starts -->
                    <div class="card-body invoice-padding invoice-product-details">
                        <div class="source-item">
                            <div class="row mb-1 text-end">
                                <div class="col-12 px-0">
                                    <button type="button" class="btn btn-primary btn-sm btn-add-new" @click="addPrice()">
                                        <i data-feather="plus" class="me-25"></i>
                                        <span class="align-middle">Agregar servicio</span>
                                    </button>
                                </div>
                            </div>
                            <div :class="[index == (price_array.length- 1) ? '' : 'mb-3', 'row']" v-for="(price, index) in price_array">
                                <div class="col-12 d-flex product-details-border position-relative pe-0">
                                    <div class="w-100 pe-lg-0 pe-1 py-2">
                                        <div class="row">
                                            <div class="col-lg-6 col-12 mb-lg-0 mb-2 mt-lg-0 mt-2">
                                                <label class="form-label">Proveedor *</label>
                                                <select :id="'slct-provider-' + index" class="form-select item-details" :data-index="index" required>
                                                    <option></option>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 my-lg-0 my-2">
                                                <label class="form-label">Tipo servicio *</label>
                                                <select class="form-select item-details" v-model="price.id_tipo_servicio" @change="setPriceDetail(index)" required>
                                                    <option value="" selected hidden>Seleccione</option>
                                                    <option v-for="service_type in service_types_array" v-text="service_type.tipo_servicio" :value="service_type.id_servicio"></option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="mt-2" v-if="price.id_tipo_servicio == 1">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label class="form-label">Hotel *</label>
                                                    <input type="text" class="form-control" v-model="price.desglose.hotel" required>
                                                </div>
                                                <div class="col-4">
                                                    <label class="form-label">Destino *</label>
                                                    <input type="text" class="form-control" v-model="price.desglose.destino" required>
                                                </div>
                                                <div class="col-4">
                                                    <label class="form-label">Fecha servicio *</label>
                                                    <input type="text" :id="'dp-stay-' + index" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="text-end mt-2">
                                                <button type="button" class="btn btn-primary btn-sm" @click="addRoom(index)"><i data-feather="plus-circle"></i> Habitación</button>
                                            </div>
                                            <section :class="index_hab == 0 ? '' : 'mt-2'" v-for="(hab, index_hab) in price.desglose.habitaciones">
                                                <div class="row g-1">
                                                    <div class="col-4">
                                                        <label class="form-label">Ocupación</label>
                                                        <input type="text" class="form-control dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" v-model="hab.ocupacion" readonly>
                                                        <div class="dropdown-menu p-2">
                                                            <div class="row">
                                                                <div class="col">
                                                                    <label class="form-label">Adultos</label>
                                                                    <select class="form-control" v-model="hab.adultos" @change="changeOccupancy(index, index_hab)">
                                                                        <option :value="adult" v-text="adult" :selected="adult == 2" v-for="adult in array_adults"></option>
                                                                    </select>
                                                                </div>
                                                                <div class="col">
                                                                    <label class="form-label">Menores</label>
                                                                    <select class="form-control" v-model="hab.menores" @change="changeOccupancy(index, index_hab)">
                                                                        <option :value="child" v-text="child" v-for="child in array_children"></option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <label v-if="hab.menores > 0">Edades menores</label>
                                                            <div class="row" v-if="hab.menores > 0">
                                                                <div class="col-6" v-for="child in hab.edades">
                                                                    <select class="form-control" v-model="child.edad">
                                                                        <option :value="age" v-text="age" v-for="age in age_options"></option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col">
                                                        <label class="form-label">Tamaño</label>
                                                        <input type="text" class="form-control">
                                                    </div> -->
                                                    <div class="col">
                                                        <label class="form-label">Tipo cama</label>
                                                        <select class="form-control" v-model="hab.tipo_cama">
                                                            <option value="">-- Seleccione --</option>
                                                            <option value="matrimoniales">2 matrimoniales</option>
                                                            <option value="king">King</option>
                                                            <option value="queen">Queen</option>
                                                        </select>
                                                    </div>
                                                    <div class="col">
                                                        <label class="form-label">Tipo habitación</label>
                                                        <input type="text" class="form-control" v-model="hab.tipo_habitacion">
                                                    </div>
                                                    <div class="col">
                                                        <label class="form-label">Plan</label>
                                                        <select class="form-control" v-model="hab.plan">
                                                            <option value="">-- Seleccione --</option>
                                                            <option value="ai">Todo Incluido</option>
                                                            <option value="db">Desayuno Buffet</option>
                                                            <option value="dc">Desayuno Continental</option>
                                                            <option value="sh">Solo Hospedaje</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-1">
                                                        <button type="button" class="btn btn-danger btn-sm" style="margin-top: 1.8rem;" @click="deleteRoom(index, index_hab)"><i data-feather="trash"></i></button>
                                                    </div>
                                                </div>
                                                <div class="row g-1">
                                                    <div class="col-5"></div>
                                                    <div class="col">
                                                        <label class="form-label">Total público</label>
                                                        <input class="form-control" type="number" v-model="hab.total_publico" step="any">
                                                    </div>
                                                    <div class="col">
                                                        <label class="form-label">Total neto</label>
                                                        <input class="form-control" type="number" v-model="hab.total_neto" step="any">
                                                    </div>
                                                    <div class="col-1"></div>
                                                </div>
                                            </section>
                                        </div>
                                        <div class="row mt-2" v-else-if="price.id_tipo_servicio == 2 || price.id_tipo_servicio == 6">
                                            <div class="col-6">
                                                <label class="form-label">Fecha servicio *</label>
                                                <input type="text" :id="'dp-stay-' + index" class="form-control" required>
                                            </div>
                                            <div class="col-3">
                                                <label class="form-label">Hora salida *</label>
                                                <input type="text" :id="'tp-arrive-' + index" class="form-control" required>
                                            </div>
                                            <div class="col-3">
                                                <label class="form-label">Hora llegada *</label>
                                                <input type="text" :id="'tp-end-' + index" class="form-control" required>
                                            </div>
                                            <div class="col-3">
                                                <div class="mt-1">
                                                    <label class="form-label">Origen</label>
                                                    <input class="form-control" type="text" v-model="price.desglose.origen" required>
                                                </div>
                                            </div>
                                            <div class="col-3">
                                                <div class="mt-1">
                                                    <label class="form-label">Destino</label>
                                                    <input class="form-control" type="text" v-model="price.desglose.destino" required>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label class="form-label mt-1">Equipaje</label>
                                                <div class="mt-1" style="display: inline-flex">
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="checkbox" :id="'chk-mano' + index" value="mano-10k" v-model="price.desglose.equipaje">
                                                        <label class="form-check-label" :for="'chk-mano' + index">Mano 10kg</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="checkbox" :id="'chk-doc' + index" value="doc-25k" v-model="price.desglose.equipaje">
                                                        <label class="form-check-label" :for="'chk-doc' + index">Documentado 25kg</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="checkbox" :id="'chk-otro' + index" value="otro" v-model="price.desglose.equipaje">
                                                        <label class="form-check-label" :for="'chk-otro' + index">Otro</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-2" v-else-if="price.id_tipo_servicio == ''">
                                            
                                        </div>
                                        <div class="row mt-2" v-else>
                                            <div class="col">
                                                <label class="form-label">Fecha servicio *</label>
                                                <input type="text" :id="'dp-stay-' + index" class="form-control" required>
                                            </div>
                                            <!-- <div class="col-3">
                                                <label class="form-label">Hora salida *</label>
                                                <input type="text" :id="'dp-limit-' + index" class="form-control" required>
                                            </div>
                                            <div class="col-3">
                                                <label class="form-label">Hora llegada *</label>
                                                <input type="text" :id="'dp-customer-limit-' + index" class="form-control" required>
                                            </div> -->
                                        </div>
                                        
                                        <div class="row mt-2" v-if="action == 'create'">
                                            <!-- <div class="col">
                                                <label class="form-label">Comisión *</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" step="any" v-model="price.comision" v-if="price.tipo_comision == '%'" required>
                                                    <input type="number" class="form-control" step="any" v-model="price.comision_pesos" v-else required>
                                                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-text="price.tipo_comision"></button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">%</a>
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">MXN</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Tarifa Pública *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="price.tarifa_publica" step="any" required>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="price.fee" step="any">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Costo *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="price.costo" step="any" required>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="row mt-2" v-if="price.id_tipo_servicio != ''">
                                            <div class="col">
                                                <label class="form-label">Tarifa Pública *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" v-model="price.total_publico" step="any" required>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Comisión *</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control" step="any" v-model="price.comision" v-if="price.desglose.comision == '%'" required>
                                                    <input type="number" class="form-control" step="any" v-model="price.comision_pesos" v-else required>
                                                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-text="price.desglose.comision"></button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">%</a>
                                                        <a class="dropdown-item" href="javascript:;" @click="changeComissionType(index)">MXN</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Fee</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" step="any" v-model="price.fee">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label class="form-label">Costo *</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" step="any" v-model="price.total_neto" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-12">
                                                <label class="form-label">Observaciones</label>
                                                <textarea class="form-control" rows="1" v-model="price.observaciones"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                
                                    <div class="ms-1 d-flex flex-column align-items-center justify-content-between border-start invoice-product-actions py-50 px-25">
                                        <a @click="removePrice(index)"><i data-feather="x" class="font-medium-3"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Product Details ends -->

                    <!-- Invoice Total starts -->
                    <div class="card-body invoice-padding">
                        <div class="row invoice-sales-total-wrapper">
                            <div class="col-md-6 order-md-1 order-2">
                            </div>
                            <div class="col-md-6 d-flex justify-content-end order-md-2 order-1">
                                <div class="invoice-total-wrapper">
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Subtotal:</p>
                                        <p class="invoice-total-amount" v-text="calculateSubtotal()"></p>
                                    </div>
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Fee:</p>
                                        <p class="invoice-total-amount" v-text="calculateFee()"></p>
                                    </div>
                                    <hr class="my-50" />
                                    <div class="invoice-total-item">
                                        <p class="invoice-total-title">Total:</p>
                                        <p class="invoice-total-amount" v-text="calculateTotal()"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Invoice Total ends -->
                </div>
            </div>
            <!-- Invoice Add Left ends -->

            <!-- Invoice Add Right starts -->
            <div class="col-xl-3 col-md-4 col-12">
                <section class="float-btn">
                    <div class="card">
                        <div class="card-body">
                            <!-- <a href="./app-invoice-preview.html" class="btn btn-outline-primary w-100 mb-75">Pagar</a> -->
                            <button type="submit" class="btn btn-primary w-100">Guardar</button>
                            <button type="button" class="btn btn-outline-primary mt-2 w-100" v-if="action == 'update'" @click="convertPriceToContract()" :disabled="contract_loading"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true" v-if="contract_loading"></span> Convertir en contrato</button>
                        </div>
                    </div>
                </section>
            </div>
            <!-- Invoice Add Right ends -->
        </div>
    </form>

    <!-- Add New Provider Sidebar -->
    <div class="modal modal-slide-in fade" id="add-new-provider-sidebar" aria-hidden="true">
        <div class="modal-dialog sidebar-lg">
            <div class="modal-content p-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                <div class="modal-header mb-1">
                    <h5 class="modal-title">
                        <span class="align-middle">Nuevo proveedor</span>
                    </h5>
                </div>
                <div class="modal-body flex-grow-1">
                    <div class="alert alert-primary" role="alert">
                        <div class="alert-body">Recuerda guardar los datos bancarios y de contacto posterior a la venta.</div>
                    </div>
                    <form>
                        <div class="mb-1">
                            <label for="provider-name" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="provider-name" v-model="provider_model.nombre_comercial" />
                        </div>
                        <div class="mb-1">
                            <label for="provider-email" class="form-label">Correo electrónico</label>
                            <input type="email" class="form-control" id="provider-email" v-model="provider_model.correo" />
                        </div>
                        <div class="mb-1">
                            <label for="provider-address" class="form-label">Dirección</label>
                            <textarea class="form-control" id="provider-address" cols="2" rows="2" v-model="provider_model.direccion"></textarea>
                        </div>
                        <div class="mb-1">
                            <label for="provider-city" class="form-label">Ciudad</label>
                            <input type="text" class="form-control" id="provider-city" v-model="provider_model.cuidad" />
                        </div>
                        <div class="mb-1">
                            <label for="provider-state" class="form-label">Estado</label>
                            <input type="text" class="form-control" id="provider-state" v-model="provider_model.estado" />
                        </div>
                        <div class="mb-1">
                            <label for="provider-cp" class="form-label">Código Postal</label>
                            <input type="number" class="form-control" id="provider-cp" v-model="provider_model.codigo_postal" />
                        </div>
                        <div class="mb-1">
                            <label for="provider-comission" class="form-label">Comisión</label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="provider-comission" step="any" v-model="provider_model.comision" />
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                        <div class="mb-1">
                            <label for="provider-details" class="form-label">Detalles</label>
                            <textarea class="form-control" id="provider-details" cols="2" rows="2" v-model="provider_model.detalles"></textarea>
                        </div>
                        
                        <div class="mb-1 d-flex flex-wrap mt-2">
                            <button type="button" class="btn btn-primary me-1" data-bs-dismiss="modal" @click="createProvider()">Guardar</button>
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- /Add New Provider Sidebar -->
</section>

<!-- Add New Customer Sidebar -->
<?php $this->renderPartial("/clientes/_form"); ?>
<!-- /Add New Customer Sidebar -->

<?php
    $request_code = ($action == "create" && $with) ? $_GET["id"] : 0;
    $price_code = $action == "update" ? $_GET["id"] : 0;
    Yii::app()->clientScript->registerScript('id0', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var action = "'. $action .'";
        var with_request = "'. $with .'";
        var info_agencia = '. CJSON::encode($_SESSION['Agencia']) .';
        var view = "ventas";
        var request_code = '. $request_code .';
        var price_code = '. $price_code .';
    ', CClientScript::POS_HEAD);

	$baseUrl = "https://erp.2businesstravel.com/admin/template/vuexy";
    Yii::app()->clientScript->registerCssFile($baseUrl .'/vendors/css/pickers/flatpickr/flatpickr.min.css');
    Yii::app()->clientScript->registerCssFile($baseUrl .'/css/plugins/forms/pickers/form-flat-pickr.min.css');
    Yii::app()->clientScript->registerCssFile($baseUrl .'/css/pages/app-invoice.min.css');

    Yii::app()->clientScript->registerScriptFile($baseUrl.'/vendors/js/forms/repeater/jquery.repeater.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile($baseUrl .'/vendors/js/pickers/flatpickr/flatpickr.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://npmcdn.com/flatpickr@4.6.9/dist/l10n/es.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/contrato-cu.js?v='. time(), CClientScript::POS_END);
?>