<div class="card">
    <div class="card-header price-header">
        <span v-text="formatDate(price.fecha_inicial) + ' al ' + formatDate(price.fecha_final) + (price.id_solicitud == null ? ' (Sin solicitud)' : '')"></span>
        <div class="dropdown chart-dropdown">
            <i data-feather="more-vertical" class="font-medium-3 cursor-pointer" data-bs-toggle="dropdown"></i>
            <div class="dropdown-menu dropdown-menu-end">
                <a class="dropdown-item" :href="baseUrl + '/cotizaciones/update/' + price.id_cotizacion"><i data-feather="edit"></i> Editar</a>
                <a class="dropdown-item" :href="baseUrl + '/formatos/cotizacion/' + price.id_cotizacion" target="_blank"><i data-feather="printer"></i> Imprimir</a>
            </div>
        </div>
    </div>
    <ul class="list-group list-group-flush">
        <li class="list-group-item" v-for="(detail, index) in price.cotizacionDetalles">
            <div class="row">
                <div class="col" v-text="detail.idTipoServicio.tipo_servicio"></div>
                <div class="col-8 text-end">
                    <a data-bs-toggle="collapse" :href="'#collapse-info-' + detail.id_cotizacion_detalle" role="button" aria-expanded="false" :aria-controls="'collapse-info-' + detail.id_cotizacion_detalle"><span data-feather="eye"></span></a>
                </div>
            </div>
            
            <div :id="'collapse-info-' + detail.id_cotizacion_detalle" class="collapse mt-1">
                <div v-if="detail.id_tipo_servicio == 1">
                    <table class="table table-sm table-bordered" v-for="(hab, index_hab) in detail.desglose.habitaciones">
                        <thead>
                            <tr>
                                <th class="text-center" colspan="2" v-text="'Habitación ' + (index_hab + 1)"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Adultos</td>
                                <td v-text="hab.adultos"></td>
                            </tr>
                            <tr>
                                <td>Menores</td>
                                <td v-text="hab.menores"></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-end" v-text="formatPrice(hab.total_publico)"></td>
                            </tr>
                        </tfoot>
                    </table>
                    <table class="table table-sm table-bordered">
                        <tr>
                            <td>Total</td>
                            <td class="text-end" v-text="getTotalBooking(detail.desglose.habitaciones)"></td>
                        </tr>
                    </table>
                </div>
                <div v-else>
                    <table class="table table-sm table-bordered">
                        <tbody>
                            <tr>
                                <td>Adultos</td>
                                <td v-text="detail.desglose.adultos"></td>
                            </tr>
                            <tr>
                                <td>Menores</td>
                                <td v-text="detail.desglose.menores"></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-end" v-text="formatPrice(detail.total_publico)"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </li>
    </ul>
    <div class="card-body" style="border-top: 1px solid rgba(34, 41, 47, .125)" v-if="price.observaciones != null && price.observaciones != ''">
        <p class="card-text" v-text="price.observaciones"></p>
    </div>
    <div class="card-footer total-footer">
        <div class="row">
            <div class="col text-end">Total</div>
            <div class="col text-end" v-text="getTotalPrice(price)"></div>
        </div>
    </div>
</div>