<?php
	$cotizacion = Cotizaciones::model()->find("id_cliente=" .$model->id_cotizacion);
	$solicitud = Solicitudes::model()->findByPk($cotizacion->id_solicitud);
	$cliente = Clientes::model()->findByPk($cotizacion->id_cliente);
	$profilecreo = Profiles::model()->findByPk($model->id_user_creo);
	$profilefirmo = Profiles::model()->findByPk($model->id_user_firmo);
	$CotizacionDetalles = CotizacionDetalles::model()->findAll("id_cotizacion = " . $model->id_cotizacion);
	// echo CJSON::encode($model);
?>

<style>
	.tabla-cliente {
		border: 2px solid lightgray;
	}

	th {
		background-color: #88ccba;
		color: #fff;
		border: 1px #f7f7f7 solid;
		text-align: center;
		font-weight: bold;
	}

	td {
		text-align: center;
		padding: 15px;
	}

	tr {
		text-align: center;
		padding: 15px;
	}
</style>

<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<th colspan="3">Información del cliente</th>
	</tr>
	<tr>
		<th style="width: 20%;" class="fondo-encabezado">Nombre</th>
		<th style="width: 60%; text-align: center;" class="fondo-encabezado">Correo</th>
		<th style="width: 20%;" class="fondo-encabezado">Teléfono</th>
	</tr>

	<tr>
		<td style="width: 20%;"><?= $cliente->nombre; ?></td>
		<td style="width: 60%; text-align: center;"><?= $cliente->correo; ?></td>
		<td style="width: 20%;">
			<?php
			preg_match('/^(\d{3})(\d{3})(\d{4})$/', $cliente->telefono, $matches);
			echo $formatted_phone = "(". $matches[1] . ")". $matches[2] ."-". $matches[3];
			?>
		</td>
	</tr>
</table>
</br></br>
<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<th colspan="3">Detalles generales del servicio</th>
	</tr>
	<tr>
		<th style="width: 70%;" class="fondo-encabezado">Descripción</th>
		<th style="width: 15%;" class="fondo-encabezado">Fecha inicial</th>
		<th style="width: 15%;" class="fondo-encabezado">Fecha final</th>
	</tr>

	<tr>
		<td style="width: 70%;"><?= $solicitud->descripcion ?></td>
		<td style="width: 15%;">
			<?= date("d/m/Y", strtotime($cotizacion->fecha_inicial)); ?>
		</td>
		<td style="width: 15%;">
			<?= date("d/m/Y", strtotime($cotizacion->fecha_final)); ?>
		</td>
	</tr>
</table>
</br>
<?php foreach ($CotizacionDetalles as $cotizacion) : ?>
	<?php $decode_desglose = json_decode($cotizacion->desglose); ?>

	<!-- Traslado -->
	<?php if ($cotizacion->id_tipo_servicio == "2") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="4">Desglose del Traslado</th>
			</tr>
			<tr>
				<th>Origen</th>
				<th>Destino</th>
				<th>Fecha inicial</th>
				<th>Fecha final</th>
			</tr>

			<tr>
				<td><?= $decode_desglose->origen; ?></td>
				<td><?= $decode_desglose->destino; ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)); ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_fin)); ?></td>
			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th>Salida</th>
				<th>Llegada</th>
				<th>Equipaje</th>
				<th>Total Publico</th>
				<th>Total Neto</th>
			</tr>

			<tr>
				<td><?= $decode_desglose->hora_salida ?></td>
				<td><?= $decode_desglose->hora_llegada ?></td>
				<td>
					<ul>
						<?php foreach ($decode_desglose->equipaje as $key => $equipaje) : ?>
							<li><?= $equipaje; ?></li>
						<?php endforeach; ?>
					</ul>
				</td>
				<td align="rigth"><?= "$". number_format($cotizacion->total_publico, 2); ?></td>
				<td align="rigth"><?= "$". number_format($cotizacion->total_neto, 2); ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin traslado -->

	<!-- VUELOS -->
	<?php if ($cotizacion->id_tipo_servicio == "6") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="4">Desglose del Vuelo</th>
			</tr>
			<tr>
				<th>Origen</th>
				<th>Destino</th>
				<th>Fecha inicial</th>
				<th>Fecha final</th>
			</tr>

			<tr>
				<td><?= $decode_desglose->origen; ?></td>
				<td><?= $decode_desglose->destino; ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)); ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_fin)); ?></td>
			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th>Salida</th>
				<th>Llegada</th>
				<th>Equipaje</th>
				<th>Total Publico</th>
				<th>Total Neto</th>
			</tr>

			<tr>
				<td><?= $decode_desglose->hora_salida; ?></td>
				<td><?= $decode_desglose->hora_llegada; ?></td>
				<td>
					<ul>
						<?php foreach ($decode_desglose->equipaje as $key => $equipaje) : ?>
							<li><?= $equipaje; ?></li>
						<?php endforeach; ?>
					</ul>
				</td>
				<td align="rigth"><?= "$". number_format($cotizacion->total_publico, 2); ?></td>
				<td align="rigth"><?= "$". number_format($cotizacion->total_neto, 2); ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin vuelo -->
	
	<p></p>
	<!-- Hospedaje -->
	<?php if ($cotizacion->id_tipo_servicio == "1") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="3">Desglose del hospedaje</th>
			</tr>
			<tr>
				<th>Hotel</th>
				<th>Destino</th>
				<th>Estancia</th>
			</tr>
			<tr>
				<td><?= $decode_desglose->hotel ?></td>
				<td><?= $decode_desglose->destino ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)) .' - '. date("d/m/Y", strtotime($decode_desglose->fecha_fin)); ?></td>

			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<thead>
				<tr>
					<th>Adultos</th>
					<th>Menores</th>
					<th>Plan</th>
					<th>Tipo de habitación</th>
					<th>Base Hab.</th>
					<th>Cama</th>
					<th>Subtotal</th>
				</tr>
			</thead>
			<tbody>
				<?php
				$total = 0;
				?>
				<?php foreach ($decode_desglose->habitaciones as $key => $habitacion) : ?>
					<?php
					$total += floatval($habitacion->total_publico);
					?>
					<tr>
						<td><?= $habitacion->adultos; ?> </td>
						<td><?= $habitacion->menores; ?> </td>
						<td><?= $habitacion->plan; ?> </td>
						<td><?= $habitacion->tipo_habitacion; ?> </td>
						<td><?= $habitacion->base_habitacion; ?> </td>
						<td><?= $habitacion->tipo_cama; ?> </td>
						<td align="rigth"><?= "$". number_format($habitacion->total_publico, 2); ?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
			<tfoot>
				<tr>
					<td align="rigth" colspan="6">Total</td>
					<td align="rigth"><?= " $". number_format($total, 2); ?></td>
				</tr>
			</tfoot>
		</table>
	<?php endif; ?>
	<!-- Fin hospedaje -->
<?php endforeach; ?>

<h3>Contrato realizado por <?= $profilecreo->firstname ." ". $profilecreo->lastname; ?> y firmado por <?= $profilefirmo->firstname ." ". $profilefirmo->lastname; ?> el día <?= date("d/m/Y", strtotime($model->fecha)); ?> a las <?= $model->hora; ?></h3>

<h4 align="center">NOTA: EL CLIENTE ACEPTA LAS CONDICIONES Y POLÍTICAS DE CANCELACIÓN Y ACLARACIONES DE ESTA AGENCIA Y/O DEL OPERADOR.
CUALQUIER CAMBIO O CANCELACIÓN GENERARÁ UN CARGO MÍNIMO POR PASAJERO</h4>