<?php
	$sale = Ventas::model()->findByPk($model->id_venta);
	$services_array = VentasServicios::model()->findAll("id_venta = ". $sale->id_venta);
	$payments_promises = PromesasPagos::model()->findAll("id_venta = ". $model->id_venta);
	$customer = Clientes::model()->findByPk($sale->id_cliente);
	$profilecreo = Profiles::model()->findByPk($model->id_user_creo);
	if(!is_null($model->id_user_firmo)) {
		$profilefirmo = Profiles::model()->findByPk($model->id_user_firmo);
	}
?>

<style>
	.tabla-cliente {
		border: 2px solid lightgray;
	}

	th {
		background-color: #88ccba;
		color: #fff;
		border: 1px #f7f7f7 solid;
		text-align: center;
		font-weight: bold;
	}

	td {
		text-align: center;
		padding: 15px;
	}

	tr {
		text-align: center;
		padding: 15px;
	}
</style>

<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<th colspan="3">Información del cliente</th>
	</tr>
	<tr>
		<th style="width: 20%;" class="fondo-encabezado">Nombre</th>
		<th style="width: 60%; text-align: center;" class="fondo-encabezado">Correo</th>
		<th style="width: 20%;" class="fondo-encabezado">Teléfono</th>
	</tr>

	<tr>
		<td style="width: 20%;"><?= $customer->nombre; ?></td>
		<td style="width: 60%; text-align: center;"><?= $customer->correo; ?></td>
		<td style="width: 20%;">
			<?php
			preg_match('/^(\d{3})(\d{3})(\d{4})$/', $customer->telefono, $matches);
			echo $formatted_phone = "(". $matches[1] . ")". $matches[2] ."-". $matches[3];
			?>
		</td>
	</tr>
</table>
<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<th>Detalles generales del servicio</th>
	</tr>
	<tr>
		<th class="fondo-encabezado">Descripción</th>
		<!-- <th style="width: 15%;" class="fondo-encabezado">Fecha inicial</th>
		<th style="width: 15%;" class="fondo-encabezado">Fecha final</th> -->
	</tr>

	<tr>
		<td><?= $sale->descripcion ?></td>
		<!-- <td style="width: 15%;">
			<?php //echo date("d/m/Y", strtotime($cotizacion->fecha_inicial)); ?>
		</td>
		<td style="width: 15%;">
			<?php //echo date("d/m/Y", strtotime($cotizacion->fecha_final)); ?>
		</td> -->
	</tr>
</table>
<p></p>
<?php foreach ($services_array as $service) : ?>
	<?php $desglose = json_decode($service->desglose); ?>

	<!-- Traslado -->
	<?php if ($service->id_tipo_servicio == "2") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="4">Desglose del Traslado</th>
			</tr>
			<tr>
				<th>Origen</th>
				<th>Destino</th>
				<th>Fecha inicial</th>
				<th>Fecha final</th>
			</tr>

			<tr>
				<td><?= $desglose->origen; ?></td>
				<td><?= $desglose->destino; ?></td>
				<td><?= date("d/m/Y", strtotime($desglose->fecha_inicio)); ?></td>
				<td><?= date("d/m/Y", strtotime($desglose->fecha_fin)); ?></td>
			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th>Salida</th>
				<th>Llegada</th>
				<th>Equipaje</th>
				<th>Total Publico</th>
				<th>Total Neto</th>
			</tr>

			<tr>
				<td><?= $desglose->hora_salida ?></td>
				<td><?= $desglose->hora_llegada ?></td>
				<td>
					<ul>
						<?php foreach ($desglose->equipaje as $key => $equipaje) : ?>
							<li><?= $equipaje; ?></li>
						<?php endforeach; ?>
					</ul>
				</td>
				<td align="rigth"><?= "$". number_format($service->tarifa_publica, 2); ?></td>
				<td align="rigth"><?= "$". number_format($service->costo, 2); ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin traslado -->

	<!-- VUELOS -->
	<?php if ($service->id_tipo_servicio == "6") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="4">Desglose del Vuelo</th>
			</tr>
			<tr>
				<th>Origen</th>
				<th>Destino</th>
				<th>Fecha inicial</th>
				<th>Fecha final</th>
			</tr>

			<tr>
				<td><?= $desglose->origen; ?></td>
				<td><?= $desglose->destino; ?></td>
				<td><?= date("d/m/Y", strtotime($desglose->fecha_inicio)); ?></td>
				<td><?= date("d/m/Y", strtotime($desglose->fecha_fin)); ?></td>
			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th>Salida</th>
				<th>Llegada</th>
				<th>Equipaje</th>
				<th>Total Publico</th>
				<th>Total Neto</th>
			</tr>

			<tr>
				<td><?= $desglose->hora_salida; ?></td>
				<td><?= $desglose->hora_llegada; ?></td>
				<td>
					<ul>
						<?php foreach ($desglose->equipaje as $key => $equipaje) : ?>
							<li><?= $equipaje; ?></li>
						<?php endforeach; ?>
					</ul>
				</td>
				<td align="rigth"><?= "$". number_format($service->tarifa_publica, 2); ?></td>
				<td align="rigth"><?= "$". number_format($service->costo, 2); ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin vuelo -->
	
	<p></p>
	<!-- Hospedaje -->
	<?php if ($service->id_tipo_servicio == "1") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="3">Desglose del hospedaje</th>
			</tr>
			<tr>
				<th>Hotel</th>
				<th>Destino</th>
				<th>Estancia</th>
			</tr>
			<tr>
				<td><?= $desglose->hotel ?></td>
				<td><?= $desglose->destino ?></td>
				<td><?= date("d/m/Y", strtotime($service->inicio_servicio)) .' - '. date("d/m/Y", strtotime($service->fin_servicio)); ?></td>

			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<thead>
				<tr>
					<th>Adultos</th>
					<th>Menores</th>
					<th>Plan</th>
					<th>Tipo de habitación</th>
					<th>Base Hab.</th>
					<th>Cama</th>
					<th>Subtotal</th>
				</tr>
			</thead>
			<tbody>
				<?php
				$total = 0;
				?>
				<?php foreach ($desglose->habitaciones as $key => $habitacion) : ?>
					<?php $total += floatval($habitacion->total_publico); ?>
					<tr>
						<td><?= $habitacion->adultos; ?> </td>
						<td><?= $habitacion->menores; ?> </td>
						<td><?= $habitacion->plan; ?> </td>
						<td><?= $habitacion->tipo_habitacion; ?> </td>
						<td><?= $habitacion->base_habitacion; ?> </td>
						<td><?= $habitacion->tipo_cama; ?> </td>
						<td align="rigth"><?= "$". number_format($habitacion->total_publico, 2); ?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
			<tfoot>
				<tr>
					<td align="rigth" colspan="6">Total</td>
					<td align="rigth"><?= " $". number_format($total, 2); ?></td>
				</tr>
			</tfoot>
		</table>
	<?php endif; ?>
	<!-- Fin hospedaje -->
<?php endforeach; ?>

<?php if(count($payments_promises) > 0) : ?>
	<p></p>
	<table border="1" bordercolor="#f7f7f7">
		<thead>
			<tr>
				<th align="center" colspan="3">Plan de pago</th>
			</tr>
			<tr>
				<th>#</th>
				<th>Fecha</th>
				<th>Monto</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($payments_promises as $key => $payment) : ?>
				<tr>
					<td><?= ($key + 1); ?></td>
					<td><?= date("d/m/Y", strtotime($payment->fecha)); ?></td>
					<td>$ <?= number_format($payment->monto, 2); ?></td>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
	<p></p>
<?php endif; ?>

<?php if(!is_null($model->id_user_firmo)) : ?>
	<h3>Contrato realizado por <?= $profilecreo->firstname ." ". $profilecreo->lastname; ?> y firmado por <?= $profilefirmo->firstname ." ". $profilefirmo->lastname; ?> el día <?= date("d/m/Y", strtotime($model->fecha)); ?> a las <?= $model->hora; ?></h3>
<?php endif; ?>

<h4 align="center">NOTA: EL CLIENTE ACEPTA LAS CONDICIONES Y POLÍTICAS DE CANCELACIÓN Y ACLARACIONES DE ESTA AGENCIA Y/O DEL OPERADOR.
CUALQUIER CAMBIO O CANCELACIÓN GENERARÁ UN CARGO MÍNIMO POR PASAJERO</h4>

<table>
	<tr>
		<td style="border: none;  border-bottom: 1px solid #000000; width: 49%; padding-top: 20px; " height="100" align="left">
			<?php if($model->estatus == "S") : ?>
				<img src="<?= Yii::app()->baseUrl; ?>/images/firmas/<?= $model->id_user_creo; ?>-signature.jpg">
			<?php endif; ?>
		</td>
		<td style="border: none; width: 2%;"></td>
		<td style="border: none;  border-bottom: 1px solid #000000; width: 49%; padding-top: 20px; " height="100" align="left">
			<?php if($model->estatus == "S") : ?>
				<img src="<?= Yii::app()->baseUrl; ?>/images/firmas/<?= $model->id_user_firmo; ?>-signature.jpg">
			<?php endif; ?>
		</td>
	</tr>
	<tr>
		<td style="border: none; width: 49%;">
			<?= $profilecreo->firstname ." ". $profilecreo->lastname; ?><br>
			<?= $sale->idAgencia->nombre_comercial; ?>
		</td>
		<td style="border: none; width: 2%;"></td>
		<td style="border: none; width: 49%;"><?= $customer->nombre; ?></td>
	</tr>
</table>