<style media="all">
    .bold {
        font-family: gothicb;
    }

    .text-center {
        text-align: center;
    }

    .condensed-text {
        font-size: 24px;
    }
</style>

<?php
$sale = Ventas::model()->findByPk($model->id_venta);
$services_array = VentasServicios::model()->findAll("id_venta = " . $sale->id_venta);
$payments_promises = PromesasPagos::model()->findAll("id_venta = " . $model->id_venta);
$index_hotel = -1;
$luggage_type = array(
    "mano-10k" => "Mano 10kg",
    "doc-25k" => "Documentado 25kg",
    "otro" => "Otro"
);
$bed_type = array(
    "matrimoniales" => "Matrimonial",
    "king" => "King Size",
    "queen" => "Queen Size"
);
$plan_type = array(
    "ai" => "Todo Incluido",
    "db" => "Desayuno Buffet",
    "dc" => "Desayuno Continental",
    "sh" => "Solo Hospedaje"
);

$limit_date = "";
$service_type = "general";
foreach ($services_array as $key => $service) {
    if (in_array(intval($service->id_tipo_servicio), array(3, 4))) $service_type = "grupo";
    if ($service->id_tipo_servicio != 6) {
        if ($limit_date == "") {
            if ($service->limite_cliente == "" || is_null($service->limite_cliente) || $service->limite_cliente == "0000-00-00") {
                $limit_date = $service->fecha_limite;
            } else {
                $limit_date = $service->limite_cliente;
            }
        } else {
            if ($service->limite_cliente == "" || is_null($service->limite_cliente) || $service->limite_cliente == "0000-00-00") {
                if ($service->fecha_limite < $limit_date) $limit_date = $service->fecha_limite;
            } else {
                if ($service->limite_cliente < $limit_date) $limit_date = $service->limite_cliente;
            }
        }
    }
}
if ($limit_date == "") {
    if ($services_array[0]->limite_cliente) $limit_date = $services_array[0]->limite_cliente;
    else $limit_date = $services_array[0]->fecha_limite;
}
$cancel_date = is_null($sale->limite_cancelacion) ? date('Y-m-d', strtotime('-1 day', strtotime($limit_date))) : $sale->limite_cancelacion;
?>

<section id="general-info">
    <table>
        <tr>
            <td>
                <span class="bold">Fecha de elaboración:</span> <?= date_format(date_create($formato_model->fecha), "d/m/Y"); ?>
            </td>
            <td>
                <span class="bold">Folio:</span> <?= $sale->folio; ?>
            </td>
        </tr>
        <tr>
            <td>
                <span class="bold">Fecha límite de pago:</span> <?= date_format(date_create($limit_date), "d/m/Y"); ?>
            </td>
            <td></td>
        </tr>
        <tr>
            <td>
                <span class="bold">Fecha oportuna de cambios:</span> <?= date_format(date_create($cancel_date), "d/m/Y"); ?>
            </td>
            <td></td>
        </tr>
    </table>
</section>
<section id="services-info">
    <h3 class="bold text-center">Descripción de servicios</h3>
    <?php $payment_total = 0; ?>
    <?php foreach ($services_array as $key => $service) : ?>
        <?php if ($key > 0) : ?><br><?php endif; ?>
        <?php
        $desglose = json_decode($service->desglose, true);
        $rowspan = 1;
        if ($desglose["redondo"]) $rowspan++;
        $rowspan += count($desglose["escalas_origen"]) + count($desglose["escalas_destino"]);
        ?>
        <?php if ($service->id_tipo_servicio == 1) : ?>
            <?php $index_hotel = $key; ?>
            <h4 class="bold">Hotel</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Destino</th>
                        <th>Fecha de servicio</th>
                        <?php if ($service->descripcion != "" && !is_null($service->descripcion)) : ?>
                            <th>Observaciones</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["hotel"]; ?></td>
                        <td><?= $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($service->inicio_servicio), "d/m/Y") . " - " . date_format(date_create($service->fin_servicio), "d/m/Y"); ?></td>
                        <?php if ($service->descripcion != "" && !is_null($service->descripcion)) : ?>
                            <td><?= $service->descripcion; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>

            <br>
            <h4 class="bold">Habitaciones</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>No. Hab.</th>
                        <th>Ocupación</th>
                        <th>Tipo de cama</th>
                        <th>Tipo de habitación</th>
                        <th>Plan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($desglose["habitaciones"] as $k => $hab) : ?>
                        <tr>
                            <td><?= $k + 1; ?></td>
                            <td><?= $hab["ocupacion"]; ?></td>
                            <td><?= $bed_type[$hab["tipo_cama"]]; ?></td>
                            <td><?= $hab["tipo_habitacion"]; ?></td>
                            <td><?= $plan_type[$hab["plan"]]; ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <tr></tr>
                </tbody>
            </table>
        <?php elseif ($service->id_tipo_servicio == 2) : ?>
            <h4 class="bold">Traslado</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Tipo</th>
                        <th>Destino</th>
                        <th>Fechas de servicio</th>
                        <?php if ($service->descripcion != "" && !is_null($service->descripcion)) : ?>
                            <th>Observaciones</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["redondo"] == "1" ? "Redondo" : "Sencillo"; ?></td>
                        <td><?= $desglose["origen"] . " - " . $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($service->inicio_servicio), "d/m/Y") . " - " . date_format(date_create($service->fin_servicio), "d/m/Y"); ?></td>
                        <?php if ($service->descripcion != "" && !is_null($service->descripcion)) : ?>
                            <td><?= $service["descripcion"]; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>

            <br>
            <h4 class="bold">Horarios de traslado</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <td>Recogida en aeropuerto</td>
                        <?php if ($desglose["redondo"] == "1") : ?>
                            <td>Recogida en hotel</td>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["llegada_destino"]; ?></td>
                        <?php if ($desglose["redondo"] == "1") : ?>
                            <td><?= $desglose["recogida_hotel"]; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>
        <?php elseif ($service->id_tipo_servicio == 6) : ?>
            <h4 class="bold">Itinerario de vuelo</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Ruta</th>
                        <th>Fecha</th>
                        <th>Salida</th>
                        <th>Llegada</th>
                        <th>Escala</th>
                        <?= ($desglose["equipaje"]) ? '<th>Equipaje</th>' : '' ?>
                        <th>Aerolínea</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="background-color: #D8D6DE;">
                        <td><?= $desglose["origen"] . " - " . $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($service->inicio_servicio), "d/m/Y"); ?></td>
                        <td><?= $desglose["salida_origen"]; ?></td>
                        <td><?= $desglose["llegada_destino"]; ?></td>
                        <td><?= $desglose["escala"] ? "Con escala" : "Directo"; ?></td>
                        <td rowspan="<?= $rowspan; ?>" style="font-size:21px;">
                            <?php if ($desglose["equipaje"]) : ?>
                                <?php foreach ($desglose["equipaje"] as $k => $luggage) : ?>
                                    <?= $luggage_type[$luggage]; ?>
                                    <?php if ($k > 0) : ?><br><?php endif; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </td>
                        <td rowspan="<?= $rowspan ?>"><?= $desglose["aerolinea"]; ?></td>
                    </tr>

                    <?php if (count($desglose["escalas_origen"]) > 0) : ?>
                        <?php foreach ($desglose["escalas_origen"] as $k => $escala) : ?>
                            <tr>
                                <td><?= $escala["origen"] . " - " . $escala["destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_origen"]), "d/m/Y"); ?></td>
                                <td><?= $escala["salida_origen"]; ?></td>
                                <td><?= $escala["llegada_destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_destino"]), "d/m/Y"); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <?php if ($desglose["redondo"]) : ?>
                        <tr style="background-color: #D8D6DE;">
                            <td><?= $desglose["destino"] . " - " . $desglose["origen"]; ?></td>
                            <td><?= date_format(date_create($service->fin_servicio), "d/m/Y"); ?></td>
                            <td><?= $desglose["salida_destino"]; ?></td>
                            <td><?= $desglose["llegada_origen"]; ?></td>
                            <td><?= $desglose["escala"] ? "Con escala" : "Directo"; ?></td>
                        </tr>
                    <?php endif; ?>

                    <?php if (count($desglose["escalas_destino"]) > 0) : ?>
                        <?php foreach ($desglose["escalas_destino"] as $k => $escala) : ?>
                            <tr>
                                <td><?= $escala["origen"] . " - " . $escala["destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_origen"]), "d/m/Y"); ?></td>
                                <td><?= $escala["salida_origen"]; ?></td>
                                <td><?= $escala["llegada_destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_destino"]), "d/m/Y"); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <tr>
                        <?php if ($service->descripcion != "" && !is_null($service->descripcion)) : ?>
                            <td colspan="7">
                                <span class="bold">Observaciones</span>
                                <?= $service["descripcion"]; ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>
        <?php else : ?>
            <h4 class="bold"><?= $service->idTipoServicio->tipo_servicio; ?></h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Fechas de servicio</th>
                        <th>Descripción</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= date_format(date_create($service->inicio_servicio), "d/m/Y") . " - " . date_format(date_create($service->fin_servicio), "d/m/Y"); ?></td>
                        <td><?= $service->descripcion; ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endif; ?>
        <?php $payment_total += $service->tarifa_publica + $service->fee; ?>
    <?php endforeach; ?>

    <br>
    <hr>
    <div>
        <h3 class="bold text-center">Datos de pasajeros</h3>
        <table border="0.5" cellpadding="5">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Tipo Pasajero</th>
                    <th>Edad</th>
                    <th>Habitación</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($index_hotel >= 0) : ?>
                    <?php foreach ($services_array as $ind_pas => $pas) : ?>
                        <?php $desglose = json_decode($services_array[$ind_pas]->desglose, true); ?>
                        <?php if ($desglose["habitaciones"]) : ?>
                            <?php foreach ($desglose["habitaciones"] as $key => $hab) : ?>
                                <?php foreach ($hab["pasajeros"]["adultos"] as $i => $adult) : ?>
                                    <tr>
                                        <td><?= $adult["nombre"] . " " . $adult["apellidos"]; ?></td>
                                        <td>Adulto</td>
                                        <td>+18</td>
                                        <td><?= $key + 1; ?></td>
                                    </tr>
                                <?php endforeach; ?>

                                <?php if (isset($hab["pasajeros"]["menores"])) : ?>
                                    <?php foreach ($hab["pasajeros"]["menores"] as $i => $child) : ?>
                                        <tr>
                                            <td><?= $child["nombre"] . " " . $child["apellidos"]; ?></td>
                                            <td>Menor</td>
                                            <td><?= $child["edad"]; ?></td>
                                            <td><?= $key + 1; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php else : ?>
                    <?php $desglose = json_decode($services_array[0]["desglose"], true); ?>
                    <?php if ($desglose["pasajeros"]["adultos"]) : ?>
                        <?php foreach ($desglose["pasajeros"]["adultos"] as $i => $adult) : ?>
                            <tr>
                                <td><?= $adult["nombre"] . " " . $adult["apellidos"]; ?></td>
                                <td>Adulto</td>
                                <td>+18</td>
                                <td><?= $key + 1; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <?php if (isset($desglose["pasajeros"]["menores"])) : ?>
                        <?php foreach ($desglose["pasajeros"]["menores"] as $i => $child) : ?>
                            <tr>
                                <td><?= $child["nombre"] . " " . $child["apellidos"]; ?></td>
                                <td>Menor</td>
                                <td><?= $child["edad"] ?></td>
                                <td><?= $key + 1; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</section>
<hr>
<section id="payment-section">
    <h3 class="bold text-center">Desglose de pagos</h3>
    <table border="0.5" cellpadding="5">
        <thead>
            <tr>
                <td>Fecha</td>
                <td>Monto</td>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($payments_promises as $key => $payment) : ?>
                <tr>
                    <td><?= date_format(date_create($payment->fecha), "d/m/Y") ?></td>
                    <td>$ <?= number_format($payment->monto, 2); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th>Total</th>
                <?php $payment_total += $sale->cargo_servicios; ?>
                <th>$ <?= number_format($payment_total, 2); ?></th>
            </tr>
        </tfoot>
    </table>
</section>
<hr>
<section id="legal-section">
    <div class="text-center">NOTA: EL CLIENTE ACEPTA LAS CONDICIONES Y POLÍTICAS DE CANCELACIÓN Y ACLARACIONES DE ESTA AGENCIA Y/O DEL OPERADOR. CUALQUIER CAMBIO O CANCELACIÓN GENERARÁ UN CARGO MÍNIMO POR PASAJERO</div>

    <table style="page-break-inside: avoid" cellpadding="5">
        <tr>
            <td style="border: none;  border-bottom: 1px solid #000000; width: 49%; padding-top: 20px;" height="125">
                <?php if ($model->estatus == "S") : ?>
                    <img src="<?= Yii::app()->baseUrl; ?>/images/firmas/<?= $model->id_user_creo; ?>-signature.jpg">
                <?php endif; ?>
            </td>
            <td style="border: none; width: 2%;"></td>
            <td style="border: none;  border-bottom: 1px solid #000000; width: 49%; padding-top: 20px;" height="125">
                <?php if ($model->estatus == "S") : ?>
                    <img src="<?= Yii::app()->baseUrl; ?>/images/firmas/<?= $model->id_user_firmo; ?>-signature.jpg">
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td class="text-center" style="border: none; width: 49%;">
                <span class="bold">Firma agente</span>
                <br>
                <?php $user_info = Profiles::model()->findByPk($sale->id_usuario); ?>
                <?= $user_info->firstname . " " . $user_info->lastname; ?>
            </td>
            <td style="border: none; width: 2%;"></td>
            <td class="text-center" style="border: none; width: 49%;">
                <span class="bold">Firma cliente</span>
                <br>
                <?= $sale->idCliente->nombre; ?>
            </td>
        </tr>
    </table>
    <br>
    <div>
        <?php
        $terminos = Terminos::model()->find("id_agencia = " . $sale->id_agencia);
        if (isset($terminos->id)) {
            if ($service_type == "general") {
                echo '<h3 class="bold text-center">Términos y condiciones</h3>';
                echo nl2br($terminos->terminos_general);
            } else {
                if (!is_null($terminos->terminos_grupos)) {
                    echo '<h3 class="bold text-center">Términos y condiciones</h3>';
                    echo nl2br($terminos->terminos_grupos);
                }
            }
        }
        ?>
    </div>
</section>