<style media="all">
    .bold {font-family: gothicb; }
    .text-center { text-align: center; }
    .condensed-text { font-size: 24px; }
</style>

<?php
	$request = Solicitudes::model()->findByPk($model->id_solicitud);
	$customer = Clientes::model()->findByPk($model->id_cliente);
	$user = Users::model()->findByPk($model->id_usuario);
	$profile = Profiles::model()->findByPk($model->id_usuario);
	$price_model = Cotizaciones::model()->findByPk($model->id_cotizacion);
	$prices_array = CotizacionDetalles::model()->findAll("id_cotizacion = ". $model->id_cotizacion);
	$price_total = 0;

	$luggage_type = array(
        "mano-10k" => "De mano 10 kilos",
        "doc-25k" => "Documentado 25 kilos",
        "otro" => "Otro"
    );
    $bed_type = array(
        "matrimoniales" => "Matrimonial",
        "king" => "King Size",
        "queen" => "Queen Size"
    );
    $plan_type = array(
        "ai" => "Todo Incluido",
        "db" => "Desayuno Buffet",
        "dc" => "Desayuno Continental",
        "sh" => "Solo Hospedaje"
    );
    preg_match('/^(\d{3})(\d{3})(\d{4})$/', $customer->telefono, $matches);
?>

<section id="general-info">
    <table border="0" cellpadding="5">
        <tr>
            <td><span class="bold">Cliente:</span> <?= $customer->nombre; ?></td>
            <td><span class="bold">Fecha de elaboración:</span> <?= date_format(date_create($formato_model->log), "d/m/Y"); ?></td>
        </tr>
        <tr>
            <td><span class="bold">Correo:</span> <?= $customer->correo; ?></td>
            <td></td>
        </tr>
        <tr>
            <td><span class="bold">Teléfono:</span> <?= $formatted_phone = "(". $matches[1] .")". $matches[2] ."-". $matches[3] ?></td>
            <td></td>
        </tr>
    </table>
</section>
<section id="prices-info">
    <h3 class="bold text-center">Descripción de servicios</h3>
    <?php $total_payment = 0; ?>
    <?php foreach ($prices_array as $key => $price): ?>
        <?php if($key > 0): ?><br><?php endif; ?>
        <?php
            $desglose = json_decode($price->desglose, true);
            $rowspan = 1;
            if($desglose["redondo"]) $rowspan++;
            $rowspan += count($desglose["escalas_origen"]) + count($desglose["escalas_destino"]);
        ?>
        <?php if($price->id_tipo_servicio == 1): ?>
            <?php $index_hotel = $key; ?>
            <h4 class="bold">Hotel</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Destino</th>
                        <th>Fecha de servicio</th>
                        <?php if($price->observaciones != "" && !is_null($price->observaciones)): ?>
                            <th>Observaciones</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["hotel"]; ?></td>
                        <td><?= $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($desglose["fecha_inicio"]), "d/m/Y") ." - ". date_format(date_create($desglose["fecha_fin"]), "d/m/Y"); ?></td>
                        <?php if($price->observaciones != "" && !is_null($price->observaciones)): ?>
                            <td><?= $price->observaciones; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>

            <br>
            <h4 class="bold">Habitaciones</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>No. Hab.</th>
                        <th>Ocupación</th>
                        <th>Tipo de cama</th>
                        <th>Tipo de habitación</th>
                        <th>Plan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($desglose["habitaciones"] as $k => $hab): ?>
                        <tr>
                            <td><?= $k + 1; ?></td>
                            <td><?= $hab["ocupacion"]; ?></td>
                            <td><?= $bed_type[$hab["tipo_cama"]]; ?></td>
                            <td><?= $hab["tipo_habitacion"]; ?></td>
                            <td><?= $plan_type[$hab["plan"]]; ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <tr></tr>
                </tbody>
            </table>
        <?php elseif($price->id_tipo_servicio == 2): ?>
            <h4 class="bold">Traslado</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Tipo</th>
                        <th>Destino</th>
                        <th>Fechas de servicio</th>
                        <?php if($price->observaciones != "" && !is_null($price->observaciones)): ?>
                            <th>Observaciones</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["redondo"] == "1" ? "Redondo" : "Sencillo"; ?></td>
                        <td><?= $desglose["origen"] ." - ". $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($desglose["fecha_inicio"]), "d/m/Y") ." - ". date_format(date_create($desglose["fecha_fin"]), "d/m/Y"); ?></td>
                        <?php if($price->observaciones != "" && !is_null($price->observaciones)): ?>
                            <td><?= $price->observaciones; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>

            <br>
            <h4 class="bold">Horarios de traslado</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <td>Recogida en aeropuerto</td>
                        <?php if($desglose["redondo"] == "1"): ?>
                            <td>Recogida en hotel</td>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["llegada_destino"]; ?></td>
                        <?php if($desglose["redondo"] == "1"): ?>
                            <td><?= $desglose["recogida_hotel"]; ?></td>
                        <?php endif; ?>
                    </tr>
                </tbody>
            </table>
        <?php elseif($price->id_tipo_servicio == 6): ?>
            <h4 class="bold">Itinerario de vuelo</h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Ruta</th>
                        <th>Fecha</th>
                        <th>Salida</th>
                        <th>Llegada</th>
                        <th>Escala</th>
                        <th>Equipaje</th>
                        <th>Aerolínea</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $desglose["origen"] ." - ". $desglose["destino"]; ?></td>
                        <td><?= date_format(date_create($desglose["fecha_inicio"]), "d/m/Y"); ?></td>
                        <td><?= $desglose["salida_origen"]; ?></td>
                        <td><?= $desglose["llegada_destino"]; ?></td>
                        <td><?= $desglose["escala"] ? "Con escala" : "Directo"; ?></td>
                        <td rowspan="<?= $rowspan; ?>">
                            <?php foreach ($desglose["equipaje"] as $k => $luggage): ?>
                                <?= $luggage_type[$luggage]; ?>
                                <?php if($k > 0): ?><br><?php endif; ?>
                            <?php endforeach; ?>
                        </td>
                        <td rowspan="<?= $rowspan ?>"><?= $desglose["aerolinea"]; ?></td>
                    </tr>

                    <?php if(count($desglose["escalas_origen"]) > 0): ?>
                        <?php foreach ($desglose["escalas_origen"] as $k => $escala): ?>
                            <tr>
                                <td><?= $escala["origen"] ." - ". $escala["destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_origen"]), "d/m/Y"); ?></td>
                                <td><?= $escala["salida_origen"]; ?></td>
                                <td><?= $escala["llegada_destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_destino"]), "d/m/Y"); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <?php if($desglose["redondo"]): ?>
                        <tr>
                            <td><?= $desglose["destino"] ." - ". $desglose["origen"]; ?></td>
                            <td><?= date_format(date_create($desglose["fecha_fin"]), "d/m/Y"); ?></td>
                            <td><?= $desglose["salida_destino"]; ?></td>
                            <td><?= $desglose["llegada_origen"]; ?></td>
                            <td><?= $desglose["escala"] ? "Con escala" : "Directo"; ?></td>
                        </tr>
                    <?php endif; ?>

                    <?php if(count($desglose["escalas_destino"]) > 0): ?>
                        <?php foreach ($desglose["escalas_destino"] as $k => $escala): ?>
                            <tr>
                                <td><?= $escala["origen"] ." - ". $escala["destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_origen"]), "d/m/Y"); ?></td>
                                <td><?= $escala["salida_origen"]; ?></td>
                                <td><?= $escala["llegada_destino"]; ?></td>
                                <td><?= date_format(date_create($escala["fecha_destino"]), "d/m/Y"); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    
                    <?php if($price->observaciones != "" && !is_null($price->observaciones)): ?>
                        <tr>
                            <td colspan="7">
                                <span class="bold">Observaciones</span>
                                <?= $price->observaciones; ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php else: ?>
            <h4 class="bold"><?= $price->idTipoServicio->tipo_servicio; ?></h4>
            <table border="0.5" class="condensed-text" cellpadding="5">
                <thead>
                    <tr>
                        <th>Fechas de servicio</th>
                        <th>Descripción</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= date_format(date_create($desglose["fecha_inicio"]), "d/m/Y") ." - ". date_format(date_create($desglose["fecha_fin"]), "d/m/Y"); ?></td>
                        <td><?= $price->observaciones; ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endif; ?>
        <?php $total_payment += $price->total_publico + $price->fee; ?>
    <?php endforeach; ?>

</section>

<table class="bold" cellpadding="5">
	<tr>
		<td>Total de los servicios</td>
        <?php $total_payment += $price_model->cargo_servicios; ?>
		<td>$ <?= number_format(floor($total_payment * 100) / 100, 2); ?></td>
	</tr>
</table>
<br>
<h4 align="center">Esto es solo una cotización, los precios están sujetos a disponibilidad, el precio puede variar al momento de reservar</h4>