<?php
	$solicitud = Solicitudes::model()->findByPk($model->id_solicitud);
	$cliente = Clientes::model()->findByPk($model->id_cliente);
	$usuario = Users::model()->findByPk($model->id_usuario);
	$profile = Profiles::model()->findByPk($model->id_usuario);
	$CotizacionDetalles = CotizacionDetalles::model()->findAll("id_cotizacion = ". $model->id_cotizacion);
	$price_total = 0;

	$luggage_type = array(
        "mano-10k" => "De mano 10 kilos",
        "doc-25k" => "Documentado 25 kilos",
        "otro" => "Otro"
    );
    $bed_type = array(
        "matrimoniales" => "Matrimonial",
        "king" => "King Size",
        "queen" => "Queen Size"
    );
    $plan_type = array(
        "ai" => "Todo Incluido",
        "db" => "Desayuno Buffet",
        "dc" => "Desayuno Continental",
        "sh" => "Solo Hospedaje"
    );
?>

<style>
	.tabla-cliente {
		border: 2px solid lightgray;
	}

	th {
		background-color: #88ccba;
		color: #fff;
		border: 1px #f7f7f7 solid;
		text-align: center;
		font-weight: bold;
	}

	td {
		border: 1px #f7f7f7 solid;
		text-align: center;
		padding: 15px;
	}

	tr {
		border: 1px #f7f7f7 solid;
		text-align: center;
		padding: 15px;
	}
</style>

<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<th colspan="3">Información del cliente</th>
	</tr>
	<tr>
		<th style="width: 20%;" class="fondo-encabezado">Nombre</th>
		<th style="width: 60%; text-align: center;" class="fondo-encabezado">Correo</th>
		<th style="width: 20%;" class="fondo-encabezado">Teléfono</th>
	</tr>

	<tr>
		<td style="width: 20%;"><?= $cliente->nombre ?></td>
		<td style="width: 60%; text-align: center;"><?= $cliente->correo ?></td>
		<td style="width: 20%;">
			<?php
				preg_match('/^(\d{3})(\d{3})(\d{4})$/', $cliente->telefono, $matches);
				echo $formatted_phone = "(". $matches[1] .")". $matches[2] ."-". $matches[3];
			?>
		</td>
	</tr>

</table>


<?php if(!is_null($model->id_solicitud)): ?>
	<p></p>
	
	<table border="1" bordercolor="#f7f7f7" cellpadding="2">
		<tr>
			<th colspan="3">Detalles generales de la solicitud</th>
		</tr>
		<tr>
			<th style="width: 70%;" class="fondo-encabezado">Descripción</th>
			<th style="width: 15%;" class="fondo-encabezado">Fecha inicial</th>
			<th style="width: 15%;" class="fondo-encabezado">Fecha final</th>
		</tr>
	
		<tr>
			<td style="width: 70%;"><?= $solicitud->descripcion ?></td>
			<td style="width: 15%;">
				<?= date_format(date_create($model->fecha_inicial), "d/m/Y"); ?>
			</td>
			<td style="width: 15%;">
				<?= date_format(date_create($model->fecha_final), "d/m/Y"); ?>
			</td>
		</tr>
	</table>
<?php endif; ?>
<p></p>

<?php foreach ($CotizacionDetalles as $i => $cotizacion) : ?>
	<?php if($i > 0): ?>
		<p></p>
	<?php endif; ?>
	<?php $decode_desglose = json_decode($cotizacion->desglose); ?>

	<!-- Traslados y vuelos-->
	<?php if ($cotizacion->id_tipo_servicio == "2" || $cotizacion->id_tipo_servicio == "6") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="<?= $cotizacion->id_tipo_servicio == 2 ? 5 : 6; ?>">Desglose del <?= ($cotizacion->id_tipo_servicio == "2") ? "Traslado" : "Vuelo"; ?></th>
			</tr>
			<?php if($cotizacion->observaciones != ""): ?>
				<tr>
					<td colspan="<?= $cotizacion->id_tipo_servicio == 2 ? 5 : 6; ?>"><?= $$cotizacion->observaciones; ?></td>
				</tr>
			<?php endif; ?>
			<tr>
				<th>Origen</th>
				<th>Destino</th>
				<th>Tipo</th>
				<?php if($cotizacion->id_tipo_servicio == 6): ?>
					<th>Escalas</th>
				<?php endif; ?>
				<th>Fecha inicial</th>
				<th>Fecha final</th>
			</tr>

			<tr>
				<td><?= $decode_desglose->origen; ?></td>
				<td><?= $decode_desglose->destino; ?></td>
				<td><?= $decode_desglose->redondo ? "Redondo" : "Sencillo"; ?></td>
				<?php if($cotizacion->id_tipo_servicio == 6): ?>
					<td><?= $decode_desglose->escala ? "Con escalas" : "Directo"; ?></td>
				<?php endif; ?>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)) ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_fin)) ?></td>
			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<?php if($cotizacion->id_tipo_servicio == 2): ?>
					<th>Pickup aeropuerto</th>
				<?php endif; ?>
				<?php if($cotizacion->id_tipo_servicio == 6): ?>
					<th>Horario origen</th>
				<?php endif; ?>
				<th><?= $cotizacion->id_tipo_servicio == 6 ? "Horario destino" : "Pickup hotel" ?></th>
				<th>Equipaje</th>
				<th>Total</th>
			</tr>

			<tr>
				<?php if($cotizacion->id_tipo_servicio == 2): ?>
					<td><?= $decode_desglose->recogida_hotel; ?></td>
				<?php endif; ?>
				<?php if($cotizacion->id_tipo_servicio == 6): ?>
					<?php if($decode_desglose->redondo == 1): ?>
						<td><?= $decode_desglose->salida_origen ." - ". $decode_desglose->llegada_destino; ?></td>
						<td><?= $decode_desglose->salida_destino ." - ". $decode_desglose->llegada_origen; ?></td>
					<?php else: ?>
						<td><?= $decode_desglose->salida_origen ?></td>
						<td><?= $decode_desglose->llegada_destino ?></td>
					<?php endif; ?>
				<?php else: ?>
					<td><?= $decode_desglose->llegada_destino ?></td>
				<?php endif; ?>
				<td>
					<ul>
						<?php foreach ($decode_desglose->equipaje as $key => $equipaje) : ?>
							<li><?= $luggage_type[$equipaje]; ?></li>
						<?php endforeach; ?>
					</ul>
				</td>
				<td align="rigth" style="font-weight: bold;"><?= "$" . number_format(($cotizacion->total_publico + $cotizacion->fee), 2) ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin traslados y vuelos-->

	<!-- Hospedaje -->
	<?php if ($cotizacion->id_tipo_servicio == "1") : ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="3">Desglose del hospedaje</th>
			</tr>
			<?php if($cotizacion->observaciones != ""): ?>
				<tr>
					<td colspan="4"><?= $$cotizacion->observaciones; ?></td>
				</tr>
			<?php endif; ?>
			<tr>
				<th>Hotel</th>
				<th>Destino</th>
				<th>Estancia</th>
			</tr>
			<tr>
				<td><?= $decode_desglose->hotel ?></td>
				<td><?= $decode_desglose->destino ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)) . ' - ' . date("d/m/Y", strtotime($decode_desglose->fecha_fin)); ?></td>

			</tr>
		</table>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<thead>
				<tr>
					<th>Adultos</th>
					<th>Menores</th>
					<th>Plan</th>
					<th>Tipo de habitación</th>
					<th>Cama</th>
					<th>Subtotal</th>
				</tr>
			</thead>
			<tbody>
				<?php $total = 0; ?>
				<?php foreach ($decode_desglose->habitaciones as $key => $habitacion) : ?>
					<?php $total += floatval($habitacion->total_publico); ?>
					<tr>
						<td><?= $habitacion->adultos; ?> </td>
						<td><?= $habitacion->menores; ?> </td>
						<td><?= $plan_type[$habitacion->plan]; ?> </td>
						<td><?= $habitacion->tipo_habitacion; ?> </td>
						<td><?= $bed_type[$habitacion->tipo_cama]; ?> </td>
						<td align="rigth"><?= "$" . number_format($habitacion->total_publico, 2) ?> </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
			<tfoot>
				<tr>
					<td align="rigth" colspan="7">Total = <span style="font-weight: bold;"><?= " $" . number_format(($total + $cotizacion->fee), 2); ?></span></td>
				</tr>
			</tfoot>
		</table>

	<?php endif; ?>
	<!-- Fin hospedaje -->

	<!-- Otros servicios -->
	<?php if(in_array($cotizacion->id_tipo_servicio, array(3,4,5,7,8,9,10))): ?>
		<table border="1" bordercolor="#f7f7f7" cellpadding="2">
			<tr>
				<th colspan="3">Desglose <?= $cotizacion->idTipoServicio->tipo_servicio; ?></th>
			</tr>
			<?php if($cotizacion->observaciones != ""): ?>
				<tr>
					<td colspan="3"><?= $$cotizacion->observaciones; ?></td>
				</tr>
			<?php endif; ?>
			<tr>
				<th>Inicio</th>
				<th>Fin</th>
				<th>Total</th>
			</tr>
			<tr>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_inicio)); ?></td>
				<td><?= date("d/m/Y", strtotime($decode_desglose->fecha_fin)) ?></td>
				<td>$ <?= number_format(($cotizacion->total_publico + $cotizacion->fee), 2); ?></td>
			</tr>
		</table>
	<?php endif; ?>
	<!-- Fin otros servicios -->

	<?php
		$aux = $cotizacion->total_publico + $cotizacion->fee;
		$price_total += $aux;
	?>
<?php endforeach; ?>
<p></p>

<table border="1" bordercolor="#f7f7f7" cellpadding="2">
	<tr>
		<td><b>Total de los servicios</b></td>
		<td><b>$ <?= number_format(floor($price_total*100)/100, 2); ?></b></td>
	</tr>
</table>
<p></p>
<h4 align="center">Esto es solo una cotización, los precios están sujetos a disponibilidad, el precio puede variar al momento de reservar</h4>