<?php
$venta = Ventas::model()->findByPk("$model->id_venta");
$cliente = Clientes::model()->findByPk($venta->id_cliente);
$ventaServicios = VentasServicios::model()->findAll("id_venta = " . $venta->id_venta);
// echo CJSON::encode($model);
?>

<table>
	<tr>
		<td>
			<?= "Información del cliente" ?><br>
			Nombre: <?= $cliente->nombre ?>
			<br>
			<?php
			preg_match('/^(\d{3})(\d{3})(\d{4})$/', $cliente->telefono, $matches);
			echo "Teléfono:" . $formatted_phone = "(" . $matches[1] . ")" . $matches[2] . "-" . $matches[3];
			?>
			<br>
			Correo: <?= $cliente->correo ?>
		</td>
		<td align="right">Venta #<?= $venta->folio; ?></td>
	</tr>
</table>

<hr>

<table style="border-collapse:separate; border-spacing:0 15px;">
	<tr>
		<td colspan="2">Descripción</td>
		<td>Servicio</td>
		<td>Lim. Pago</td>
		<td align="right">Costo</td>
	</tr>

	<?php foreach ($ventaServicios as $key => $ventaservicio) : ?>
		<?php
		$subtotal = floatval($ventaservicio->tarifa_publica) + floatval($ventaservicio->fee);
		if($key == 0) $subtotal += $venta->cargo_servicios;
		$total += $subtotal;
		$limit_date = is_null($ventaservicio->limite_cliente) ? $service->fecha_limite : $service->limite_cliente;
		?>

		<tr>
			<td colspan="2"><?= $ventaservicio->descripcion; ?></td>
			<td><?= $ventaservicio->idTipoServicio->tipo_servicio; ?></td>
			<td><?= date_format(date_create($limit_date), "d/m/Y"); ?></td>
			<td align="right">$<?= number_format($subtotal, 2); ?></td>
		</tr>
	<?php endforeach; ?>

</table>

<hr>

<table style="border-collapse:separate; border-spacing:0 10px;">
	<tr>
		<td colspan="5" align="right">Total:</td>
		<td align="right" style="font-weight: bold;">$<?= number_format($total, 2); ?></td>
	</tr>
</table>