<style>
    .dataTables_length {
        margin-left: 1rem;
    }

    .dataTables_info {
        margin-left: 1rem;
    }

    .dataTables_filter {
        margin-right: 1rem;
    }

    .dataTables_paginate {
        margin-right: 1rem !important;
    }

    @media (min-width:576px) {
        #voucher-modal .modal-dialog {
            max-width: fit-content;
            margin: 1.75rem auto
        }
    }
</style>

<section id="expenses-app">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">Gastos registrados</h4>
                    <div class="float-end">
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#cu-expenses">
                            <i data-feather="plus"></i>Gasto
                        </button>
                    </div>
                </div>
                <div class="card-datatable">
                    <table id="expenses-table" class="table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Descripción</th>
                                <th>Fecha gasto</th>
                                <th>Importe</th>
                                <th>Referencia</th>
                                <th>Forma pago</th>
                                <th>Origen</th>
                                <th>Beneficiario</th>
                                <th>Observaciones</th>
                                <th>Por</th>
                                <th></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-start" id="cu-expenses" tabindex="-1" aria-labelledby="labelExpenses" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="labelExpenses" v-if="expense_model.id_gasto > 0">Editar gasto</h4>
                    <h4 class="modal-title" id="labelExpenses" v-else>Agregar gasto</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12 col-md-6">
                            <div class="mb-1">
                                <label class="form-label">Descripción *</label>
                                <textarea class="form-control" cols="30" rows="1" v-model="expense_model.descripcion"></textarea>
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Fecha gasto *</label>
                                <input id="dp-expense" class="form-control" type="text">
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Importe *</label>
                                <input class="form-control" type="number" v-model="expense_model.importe">
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Forma pago *</label>
                                <select class="form-control" v-model="expense_model.id_forma_pago" @change="checkPaymentType()">
                                    <option v-for="way in ways_to_pay" :value="way.id_tipo" v-text="way.descripcion"></option>
                                </select>
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Cuenta *</label>
                                <select id="slct-account" class="form-control" v-model="expense_model.id_cuenta">
                                    <option value="1" v-if="expense_model.id_forma_pago == 1">Caja Chica</option>
                                    <option v-for="account in accounts_array" :value="account.id_cuenta" v-text="account.descripcion"></option>
                                </select>
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Referencia</label>
                                <input class="form-control" type="text" v-model="expense_model.referencia">
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="mb-1">
                                <label class="form-label">Beneficiario</label>
                                <select id="slct-provider-0" class="form-control">
                                    <option></option>
                                </select>
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Observaciones</label>
                                <textarea class="form-control" cols="30" rows="4" v-model="expense_model.observaciones"></textarea>
                            </div>
                            <div class="mb-1">
                                <label class="form-label">Comprobante</label>
                                <input id="dropify" class="form-control" type="file" accept="image/*" :data-default-file="baseUrl + '/images/comprobantes/' + expense_model.comprobante" @change="setFileToModel">
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancelar</button>
                    <button type="button" class="btn btn-primary" @click="expense_model.id_gasto > 0 ? updateExpense() : saveExpense()">Aceptar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Add New Provider Sidebar -->
    <?php $this->renderPartial("//proveedores/_modalCreate"); ?>
    <!-- /Add New Provider Sidebar -->

    <div class="modal fade text-start" id="voucher-modal" tabindex="-1" aria-labelledby="voucherLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <!-- <div class="modal-header">
                    <h4 class="modal-title" id="voucherLabel">Default Modal</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div> -->
                <div class="modal-body">
                    <img :src="baseUrl + '/images/comprobantes/' + expense_model.comprobante" alt="comprobante-gasto">
                </div>
                <!-- <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Accept</button>
                </div> -->
            </div>
        </div>
    </div>
</section>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var view = "gastos";
    ', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');

    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/pickers/flatpickr.min.css');
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/pickers/flatpickr/flatpickr.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://npmcdn.com/flatpickr@4.6.9/dist/l10n/es.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css');
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://cdn.datatables.net/fixedcolumns/4.0.0/js/dataTables.fixedColumns.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/proveedor-create.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/gastos-index.js?v='. time(), CClientScript::POS_END);
?>