<div class="nav-vertical">
    <ul class="nav nav-tabs nav-left flex-column" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="event-tab" data-bs-toggle="tab" href="#event" aria-selected="true"><i data-feather="info"></i> Información</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="multimedia-tab" data-bs-toggle="tab" href="#multimedia" aria-selected="false"><i data-feather="image"></i> Multimedia</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="gallery-tab" data-bs-toggle="tab" href="#gallery" aria-selected="false"><i data-feather="camera"></i> Galería</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="comments-tab" data-bs-toggle="tab" href="#comments" aria-selected="false"><i data-feather="message-square"></i> Comentarios</a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="event" aria-labelledby="event-tab" role="tabpanel" style="overflow: hidden;">
            <div class="row mb-1">
                <div class="col">
                    <label class="form-label">Correo de contacto</label>
                    <input type="email" class="form-control" v-model="event_model.correo_contacto">
                </div>
                <div class="col">
                    <label class="form-label">Correo auxiliar</label>
                    <input type="email" class="form-control" v-model="event_model.correo_aux">
                </div>
            </div>
            <div class="row mb-1">
                <div class="col">
                    <label class="form-label">Slug</label>
                    <input type="text" class="form-control" v-model="event_model.slug">
                </div>
                <div class="col">
                    <label class="form-label">Template</label>
                    <select class="form-control" v-model="event_model.template">
                        <option value="" hidden selected>-- Seleccione --</option>
                        <option value="1">Template 1</option>
                    </select>
                </div>
            </div>

            <button class="btn btn-primary" type="button" @click="saveEventInfo()">Guardar</button>
            <a class="btn btn-outline-primary" :href="'//'+group_info.idAgencia.sitio_web + ((group_info.tipo == 'Grupo') ? '/eventos/' : '/miboda/') + event_model.slug" target="_blank">Ver página web</a>
        </div>
        <div class="tab-pane" id="multimedia" aria-labelledby="multimedia-tab" role="tabpanel" style="overflow: hidden;">
            <div class="row">
                <div class="col">
                    <input v-if="portrait_multimedia != ''" :data-default-file="baseUrl + '/images/eventos/evento_' + group_info.evento.id + '/multimedia/' + portrait_multimedia" type="file" accept="image/*" id="portrait-drpfy" data-height="260" @change="setFileToModel('portada')">
                    <input v-else type="file" accept="image/*" id="portrait-drpfy" data-height="260" @change="setFileToModel('portada')">
                </div>
                <div class="col">
                    <h3 class="text-center">Portada</h3>
                    <img class="img-fluid" src="<?= Yii::app()->baseUrl; ?>/images/eventos/img-position-1.webp">
                </div>
                <div class="col">
                    <input v-if="lateral_multimedia != ''" :data-default-file="baseUrl + '/images/eventos/evento_' + group_info.evento.id + '/multimedia/' + lateral_multimedia" type="file" accept="image/*" id="lateral-drpfy" data-height="260" @change="setFileToModel('lateral')">
                    <input v-else type="file" accept="image/*" id="lateral-drpfy" data-height="260" @change="setFileToModel('lateral')">
                </div>
                <div class="col">
                    <h3 class="text-center">Lateral Izquierdo</h3>
                    <img class="img-fluid" src="<?= Yii::app()->baseUrl; ?>/images/eventos/img-position-2.webp">
                </div>

                <div class="w-100"></div>

                <div class="col d-grid gap-2">
                    <button class="btn btn-outline-primary" @click="saveMultimediaImage('portada')">Guardar</button>
                </div>
                <div class="col d-grid gap-2">
                    <button class="btn btn-outline-primary" @click="saveMultimediaImage('lateral')">Guardar</button>
                </div>
            </div>
        </div>
        <div class="tab-pane" id="gallery" aria-labelledby="gallery-tab" role="tabpanel" style="overflow: hidden;">
            <div id="gallery-grid" class="row row-cols-4 g-4">
                <div :id="'col-gallery-' + i" class="col" v-for="(img, i) in gallery_array">
                    <div class="card">
                        <img :src="baseUrl + '/images/eventos/evento_' + group_info.evento.id + '/galeria/' + img.path" class="img-fluid rounded">
                        <div class="position-absolute top-0 end-0">
                            <button class="btn btn-xs btn-danger mt-25 me-25" @click="deleteImg(i)"><i data-feather="trash"></i></button>
                        </div>
                    </div>
                </div>
            </div>

            <div :class="[gallery_array.length > 0 ? 'mt-1' : 'mt-4', 'row']">
                <div class="col-12">
                    <button id="clear-dropzone" class="btn btn-outline-primary mb-1">
                        <i data-feather="trash" class="me-25"></i>
                        <span class="align-middle">Limpiar imagenes</span>
                    </button>
                    <div class="dropzone dropzone-area" id="dpzGallery">
                        <div class="dz-message">Agrega nuevas imagenes a la galería.</div>
                    </div>
                    <button type="button" class="btn btn-success mt-1" @click="proccessImages()">Guardar cambios</button>
                </div>
            </div>
        </div>
        <div class="tab-pane" id="comments" aria-labelledby="comments-tab" role="tabpanel" style="overflow: hidden;">
            <table id="comments-table" class="table table-striped"></table>
        </div>
    </div>
</div>

<?php
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/masonry-layout@4.2.2/dist/masonry.pkgd.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css');
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js', CClientScript::POS_END);
?>