<div class="file-manager-application">
    <div class="content-area-wrapper">
        <div class="file-manager-main-content">
            <div class="file-manager-content-body">
                <!-- Files Container Starts -->
                <div class="view-container">
                    <div class="card file-manager-item file" v-for="file in group_info.gruposArchivoses" @click="openFile(file.path)">
                        <div class="card-img-top file-logo-wrapper">
                            <div class="dropdown float-end" style="min-height: 20.3px; min-width: 1rem;"></div>
                            <div class="d-flex align-items-center justify-content-center w-100">
                                <img :src="getIconFile(file.path)" alt="file-icon" height="35" />
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="content-wrapper">
                                <p class="card-text file-name mb-0" v-text="file.path"></p>
                                <!-- <p class="card-text file-size mb-0">12.6mb</p> -->
                                <p class="card-text file-date" v-text="formatDateTime(file.log)"></p>
                            </div>
                            <small class="file-accessed text-muted" v-text="formatDateTime(file.log)">></small>
                        </div>
                    </div>
                    <div class="flex-grow-1 align-items-center no-result mb-3" v-if="group_info.gruposArchivoses.length == 0">
                        <i data-feather="alert-circle" class="me-50"></i>
                        <span class="fs-4">Sin documentos registrados</span>
                    </div>
                </div>
                <!-- /Files Container Ends -->
            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-12">
        <button id="clear-dropzone" class="btn btn-outline-primary mb-1">
            <i data-feather="trash" class="me-25"></i>
            <span class="align-middle">Limpiar archivos</span>
        </button>
        <div class="dropzone dropzone-area" id="dpzFiles">
            <div class="dz-message">Guardar archivos nuevos de{{ group_type == "boda" ? " la " + group_type : "l " + group_type }}.</div>
        </div>
        <button type="button" class="btn btn-success mt-1" @click="proccessFiles()">Guardar cambios</button>
    </div>
</div>