<style>
    .btn-xs {
        padding: 0.25rem 0.4rem;
        line-height: .5;
        border-radius: 0.2rem;
    }
    [v-cloak] {
        display: none;
    }
    .ck.ck-editor__main>.ck-editor__editable {
        height: 30rem;
    }
    .file-manager-main-content {
        min-width: 100%!important;
    }
    .file-manager-application .content-area-wrapper .file-manager-main-content .file-manager-content-body .view-container .file-manager-item .file-logo-wrapper {
        background-color: #e7e7e7!important;
    }
    html .navbar-floating.footer-static .app-content .content-area-wrapper, html .navbar-floating.footer-static .app-content .kanban-wrapper {
        height: auto!important;
    }
    .dropify-wrapper .dropify-message span.file-icon {
        font-size: 2rem!important;
    }
</style>

<section id="app-group" v-cloak>
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h2 class="content-header-title float-start mb-0">Detalles de<?= $group_type == "boda" ? " la ". $group_type : "l ". $group_type; ?></h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb ps-1">
                            <li class="breadcrumb-item"><a href="/admin">Inicio</a></li>
                            <li class="breadcrumb-item"><a href="<?= Yii::app()->createUrl($group_type .'s') ?>">Lista de <?= $group_type; ?>s</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Detalles de<?= $group_type == "boda" ? " la ". $group_type : "l ". $group_type; ?></li>
                        </ol>
                    </div>
                    <hr>

                    <div id="tabs-info" class="mt-1" v-if="loaded">
                        <ul class="nav nav-pills nav-justified">
                            <li class="nav-item">
                                <a class="nav-link active" id="info-tab" data-bs-toggle="pill" href="#info" aria-expanded="true">
                                    <i data-feather="info" class="font-medium-3 me-1"></i>
                                    <span>General</span>
                                </a>
                            </li>
                            <li class="nav-item" @click="loadGuestsTable()">
                                <a class="nav-link" id="guests-tab" data-bs-toggle="pill" href="#guests" aria-expanded="false">
                                    <i data-feather="users" class="font-medium-3 me-1"></i>
                                    <span>Habitaciones</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="invitations-tab" data-bs-toggle="pill" href="#invitations" aria-expanded="false">
                                    <i data-feather="mail" class="font-medium-3 me-1"></i>
                                    <span>Invitación</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="web-tab" data-bs-toggle="pill" href="#web" aria-expanded="false">
                                    <i data-feather="layout" class="font-medium-3 me-1"></i>
                                    <span>Página Web</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="files-tab" data-bs-toggle="pill" href="#files" aria-expanded="false">
                                    <i data-feather="file" class="font-medium-3 me-1"></i>
                                    <span>Archivos</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="payments-tab" data-bs-toggle="pill" href="#payments" aria-expanded="false">
                                    <i data-feather="dollar-sign" class="font-medium-3 me-1"></i>
                                    <span>Pagos</span>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane active" id="info" aria-labelledby="info-tab" aria-expanded="true">
                                <?php $this->renderPartial("/grupos/_info"); ?>
                            </div>
                            <div class="tab-pane" id="guests" role="tabpanel" aria-labelledby="guests-tab" aria-expanded="false">
                                <?php $this->renderPartial("/grupos/_guests"); ?>
                            </div>
                            <div class="tab-pane" id="web" role="tabpanel" aria-labelledby="web-tab" @click="initEventLibraries()" aria-expanded="false">
                                <?php $this->renderPartial("/grupos/_event"); ?>
                            </div>
                            <div class="tab-pane" id="invitations" role="tabpanel" aria-labelledby="invitations-tab" aria-expanded="false">
                                <?php $this->renderPartial("/grupos/_invitations"); ?>
                            </div>
                            <div class="tab-pane" id="files" role="tabpanel" aria-labelledby="files-tab" aria-expanded="false">
                                <?php $this->renderPartial("/grupos/_files"); ?>
                            </div>
                            <div class="tab-pane" id="payments" role="tabpanel" aria-labelledby="payments-tab" aria-expanded="false">
                                <?php $this->renderPartial("/grupos/_payments"); ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-start" id="cu-modal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modalLabel" v-if="hab_model.id_habitacion > 0">Actualizar habitación</h4>
                    <h4 class="modal-title" id="modalLabel" v-else>Nueva habitación</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <section>
                        <div class="row">
                            <div class="col">
                                <label class="form-label">Tipo habitación</label>
                                <input type="text" class="form-control" v-model="hab_model.tipo_habitacion">
                            </div>
                            <div class="col">
                                <label class="form-label">Estancia</label>
                                <input type="text" id="stay-date" class="form-control">
                            </div>
                            <div class="w-100 mt-1"></div>
                            <div class="col">
                                <label class="form-label">Tarifa Agencia</label>
                                <input type="text" class="form-control" v-model="hab_model.total_publico">
                            </div>
                            <div class="col">
                                <label class="form-label">Tarifa Pública</label>
                                <input type="text" class="form-control" v-model="hab_model.total_neto">
                            </div>
                        </div>
                        <hr>
                        <div style="text-align: right;">
                            <button class="btn btn-sm btn-primary" type="button" @click="addGuest()"><i data-feather="plus"></i> Huésped</button>
                        </div>
                        <div id="guests-data">
                            <div class="row mt-1" v-for="guest in hab_model.habitacionesHuespedes">
                                <div class="col">
                                    <div class="row">
                                        <div class="col">
                                            <label class="form-label">Nombre(s)</label>
                                            <input type="text" class="form-control" v-model="guest.nombres">
                                        </div>
                                        <div class="col">
                                            <label class="form-label">Apellidos</label>
                                            <input type="text" class="form-control" v-model="guest.apellidos">
                                        </div>
                                        <div class="col">
                                            <label class="form-label">Edad</label>
                                            <input type="number" class="form-control" v-model="guest.edad">
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col">
                                            <label class="form-label">Correo electrónico</label>
                                            <input type="email" class="form-control" v-model="guest.correo">
                                        </div>
                                        <div class="col">
                                            <label class="form-label">Teléfono</label>
                                            <input type="text" class="form-control" v-model="guest.telefono">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-1">
                                    <div class="d-grid gap-2" style="margin-top: 1.9rem;">
                                        <button class="btn btn-sm btn-primary" type="button" style="padding: 0.5rem 0.7rem;" @click="deleteGuest(guest.id_huesped)"><i data-feather="trash"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="saveHab()">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade text-start" id="invitations-modal" tabindex="-1" aria-labelledby="modalLabelInvitation" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modalLabelInvitation">Enviar invitaciones</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <section>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Invitado</th>
                                    <th>Email</th>
                                    <th>Teléfono</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="guest in hab_model.habitacionesHuespedes">
                                    <td>
                                        <input class="form-check-input" type="checkbox" :disabled="guest.correo == null || guest.correo == ''" v-model="invitations_model" :value="guest.id_huesped" />
                                    </td>
                                    <td v-text="guest.nombres + ' ' + guest.apellidos"></td>
                                    <td v-text="guest.correo"></td>
                                    <td v-text="guest.telefono"></td>
                                    <td>
                                        <a href="javascript:;" :class="[ guest.telefono == null || guest.telefono == '' ? 'disabled' : '', 'btn btn-sm btn-primary' ]" :aria-disabled="guest.telefono == null || guest.telefono == ''"><span class="fa fa-whatsapp"></span></a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </section>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="sendInvitation()" :disabled="!checkHabModel()">Enviar</button>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var group_code = '. $_GET["id"] .';
        var group_type = "'. $group_type .'";
    ', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/pickers/flatpickr/flatpickr.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/plugins/forms/pickers/form-flat-pickr.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/plugins/extensions/ext-component-tree.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/pages/app-file-manager.min.css');

    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/pickers/flatpickr/flatpickr.min.js', CClientScript::POS_END);
    //Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/scripts/pages/app-file-manager.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://npmcdn.com/flatpickr@4.6.9/dist/l10n/es.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile('https://cdn.ckeditor.com/ckeditor5/31.1.0/classic/ckeditor.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css');
    Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/file-uploaders/dropzone.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/css/plugins/forms/form-file-uploader.min.css');
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/file-uploaders/dropzone.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/grupos-eventos.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/grupos-view.js?v='. time(), CClientScript::POS_END);
?>