<?php
	$this->breadcrumbs = array(
		'Gruposes' => array('index'),
		$model->id_grupo,
	);
?>
<style type="text/css">
	.info {
		background-color: paleturquoise;
		padding: 5px;
		margin: 10px 0px;
		color: #333;
		font-size: 15px;
	}
</style>

<?php if (Yii::app()->user->hasFlash('success')) : ?>
	<div class="info">
		<?php echo Yii::app()->user->getFlash('success'); ?>
	</div>
<?php endif; ?>

<?php
	$this->beginWidget('zii.widgets.CPortlet', array(
		'htmlOptions' => array(
			'class' => ''
		)
	));

	$this->endWidget();
?>
<div class="">
	<!-- <a href="<?= Yii::app()->createUrl('grupos/misgrupos') ?>" class="btn mb-1 btn-warning btn-rounded my-1"><span class="btn-icon-left"><i class="icono fas fa-arrow-left"></i> </span>Regresar</a> -->

	<!-- Default Breadcrumb Starts -->
	<section id="default-breadcrumb">
		<div class="row">
			<div class="col-sm-12">
				<div class="card">
					<div class="card-header">
						<h4 class="card-title">Detalles del grupo #<?php echo $model->idVenta->folio; ?></h4>
					</div>
					<div class="card-body">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb">
								<li class="breadcrumb-item"><a href="/admin">Inicio</a></li>
								<li class="breadcrumb-item"><a href="<?= Yii::app()->createUrl('grupos/misgrupos') ?>">Lista de grupos</a></li>
								<li class="breadcrumb-item active" aria-current="page">Detalles del grupo</li>
							</ol>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Default Breadcrumb Ends -->
</div>
<section id="basic-tabs-components">
	<div class="row match-height">
		<!-- Basic Tabs starts -->
		<div class="col-xl-12">
			<div class="card">
				<div class="card-body">
					<ul class="nav nav-tabs" role="tablist">
						<li class="nav-item">
							<a class="nav-link active" id="grupo-tab" data-bs-toggle="tab" href="#venta" aria-controls="venta" role="tab" aria-selected="true">Datos del Grupo</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="rooms-tab" data-bs-toggle="tab" href="#rooms" aria-controls="rooms" role="tab" aria-selected="false">Detalles de Habitaciones</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="servicio-tab" data-bs-toggle="tab" href="#servicio" aria-controls="servicio" role="tab" aria-selected="false">Detalles de Huespedes</a>
						</li>
					</ul>

					<div class="tab-content">
						<div class="tab-pane active" id="venta" aria-labelledby="grupo-tab" role="tabpanel">
							<div class='printableArea'>

								<?php $this->widget('bootstrap.widgets.TbDetailView', array(
									'data' => $model,
									'attributes' => array(
										/* 'id_grupo',
										'id_venta', */
										'titulo_evento',
										'num_habitaciones',
										'noches',
										'hotel',
										'tipo_habitacion',
										'condiciones',
										'estatus',
									),
								)); ?>
							</div>
						</div>

						<!-- tab clientes -->
						<div class="tab-pane" id="rooms" aria-labelledby="rooms-tab" role="tabpanel">
							<h3>Datos de las Habitaciones de 
								<?php 
									echo $model->idVenta->pasajero_titular;
									echo ' #' . $model->idVenta->folio; 
								?>
							</h3>

							<?php $this->renderPartial('_habitaciones', array(
								'id_grupo' => $model->id_grupo,
							)); ?>

						</div>

						<!-- fin tab clientes -->

						<!-- tab servicios -->
						<div class="tab-pane" id="servicio" aria-labelledby="servicio-tab" role="tabpanel">
							<h3>Datos de Huespedes de <?php echo $model->idVenta->pasajero_titular;
														echo ' #' . $model->idVenta->folio; ?></h3>
							<a href="<?= Yii::app()->createUrl('ventas/updateServicio', array('id' => $model->id_venta)); ?>" class="btn btn-gradient-success">Agregar Nuevo Servicio</a>
							<?php $this->renderPartial('_huespedes', array(
								'id_venta' => $model->id_venta,
							));
							?>
						</div>
						<!-- fin tab servicios -->
					</div>
				</div>
			</div>
		</div>
		<!-- Basic Tabs ends -->
	</div>
</section>

<?php
	Yii::app()->clientScript->registerScript('gruposid', ' 
		var id_venta = "' . $_GET['id'] . '";
		var id_grupo = "' . $_GET['id'] . '";
	', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/grupos_agenciaVUE.js?v=' . time(), CClientScript::POS_END);
?>
<style type="text/css" media="print">
	body {
		visibility: hidden;
	}

	.printableArea {
		visibility: visible;
	}
</style>