<?php
	$controllerAction = Yii::app()->controller->id . "/" . Yii::app()->controller->action->id;
	//$baseUrl = "https://erp.2businesstravel.com/admin";
	$baseUrl = Yii::app()->baseUrl;
	$DatosAgencia = Agencia::model()->findByPk($_SESSION['Agencia']->id_agencia);
	$DatosFacturacion = DatosFacturacion::model()->find('id_agencia=' . $_SESSION['Agencia']->id_agencia);
	$allow_rols = array("Propietario", "Administrador");
?>

<!DOCTYPE html>
<html class="loading" lang="es-MX" data-textdirection="ltr" id="modo-oscuro">
<!-- BEGIN: Head-->

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
	<meta name="description" content="Vuexy admin is super flexible, powerful, clean &amp; modern responsive bootstrap 4 admin template with unlimited possibilities.">
	<meta name="keywords" content="admin template, Vuexy admin template, dashboard template, flat admin template, responsive admin template, web app">
	<meta name="author" content="PIXINVENT">

	<title><?= CHtml::encode($this->pageTitle); ?></title>
	<link rel="icon" type="image/png" sizes="16x16" href="<?= $baseUrl; ?>/template/vuexy/images/ico/2B.ico">
	<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">

	<!-- BEGIN: Vendor CSS-->
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/vendors/css/vendors.min.css">
	<!-- END: Vendor CSS-->

	<!-- Font Awesome -->
	<script src='https://kit.fontawesome.com/66f5e943e2.js' crossorigin='anonymous'></script>
	<!-- Fin Font Awesome -->

	<!-- BEGIN: Theme CSS-->
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/bootstrap-extended.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/colors.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/components.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/themes/dark-layout.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/themes/bordered-layout.min.css">
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/themes/semi-dark-layout.min.css">
	<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/@sweetalert2/theme-dark@4/dark.css">

	<!-- BEGIN: Page CSS-->
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/template/vuexy/css/core/menu/menu-types/vertical-menu.min.css">
	<!-- END: Page CSS-->

	<!-- Custom CSS -->
	<link rel="stylesheet" type="text/css" href="<?= $baseUrl; ?>/css/custom.css">
	<!-- Fi Custom CSS -->

	<style>
		/*.avatar-content {
			background-color: transparent;
			}*/

		.avatar {
			background-color: white;
		}

		/*.dark-layout .avatar, .dark-layout .list-group .list-group-item.list-group-item-action:not(.active):not(:active):focus, .dark-layout .list-group .list-group-item.list-group-item-action:not(.active):not(:active):hover {
			background-color: white !important; 
			}*/
		.avatar .feather {
			width: 2rem;
			height: 2rem;
		}

		.feather,
		[data-feather] {
			width: 1.2rem;
			height: 1.2rem;
		}
	</style>
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="" id="collapse-menu">
	<!-- BEGIN: Header-->
	<nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow container-xxl">
		<div class="navbar-container d-flex content">
			<div class="bookmark-wrapper d-flex align-items-center">
				<ul class="nav navbar-nav d-xl-none">
					<li class="nav-item"><a class="nav-link menu-toggle" href="#"><i class="fas fa-bars"></i></a></li>
				</ul>
                
				<ul class="nav navbar-nav bookmark-icons">
				    <?php if ($_SESSION['Usuario']->rol !== "Contabilidad") : ?>
					<li class="nav-item"><a class="nav-link" href="<?= Yii::app()->createUrl('solicitudes') ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Solicitudes"><i class="ficon fas fa-clipboard-list"></i></a></li>
					<li class="nav-item"><a class="nav-link" href="<?= Yii::app()->createUrl('cotizaciones') ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Cotizaciones"><i class="ficon fas fa-comments-dollar"></i></a></li>
					<li class="nav-item"><a class="nav-link" href="<?= Yii::app()->createUrl('ventas/create') ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Nueva venta"><i class="ficon fas fa-shopping-cart"></i></a></li>
					<?php endif;?>
				</ul>
			</div>
			<ul class="nav navbar-nav align-items-center ms-auto">
				<!-- <li class="nav-item dropdown dropdown-language"><a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="flag-icon flag-icon-mx"></i><span class="selected-language">Español</span></a>
					<div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">
						<button class="translate dropdown-item w-100" id="es"><i class="flag-icon flag-icon-mx"></i><span class="lang" key="Español">Español</span> </button>
						<button class="translate dropdown-item w-100" id="en"><i class="flag-icon flag-icon-us"></i><span class="lang" key="Ingles">Ingles</span> </button>
					</div>
				</li> -->
				<li class="nav-item mx-1">
					<button class="switch" id="switch">
						<span><i class="fas fa-sun"></i></span>
						<span><i class="fas fa-moon"></i></span>
					</button>
				</li>
				<li class="nav-item dropdown dropdown-user">
					<a class="nav-link dropdown-toggle dropdown-user-link" id="dropdown-user" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<div class="user-nav d-sm-flex d-none">
							<span class="user-name fw-bolder"><?= Yii::app()->getModule('user')->user()->profile->firstname; ?></span>
							<span class="user-status"><?= $_SESSION['Usuario']->rol; ?></span>
						</div>
						<?php if(is_null($_SESSION["Usuario"]["foto"])) : ?>
							<span style="background-color: transparent !important;">
								<i class="fas fa-user-circle" style="width:2.5rem; font-size: 2.5rem; background-color: transparent;"></i>
								<!-- <span class="avatar-status-online"></span> -->
							</span>
						<?php else : ?>
							<img class="avatar" style="height: 3rem; width: 3rem; object-fit: cover" src="<?= Yii::app()->baseUrl; ?>/images/usuarios/<?= $_SESSION["Usuario"]["foto"]; ?>" alt="user-img">
						<?php endif; ?>
					</a>
					<div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
						<a class="dropdown-item" href="<?= Yii::app()->createUrl('usuariosAgencias/update', ['id' => $_SESSION['Usuario']->id_usuario]) ?>"><i class="fas fa-user-circle me-50"></i>
							<span class="lang" key="Perfil"><?= Yii::t('app', 'Perfil'); ?></span></a>
						<!-- <a class="dropdown-item" href="<?= Yii::app()->createUrl('user/profile/edit') ?>"><i class="fas fa-cog me-50"></i><span class="lang" key="Configuración"><?= Yii::t('app', 'Configuración'); ?></span></a> -->
						<a class="dropdown-item" href="<?= Yii::app()->createUrl('user/logout') ?>"><i class="fas fa-power-off me-50"></i><span class="lang" key="Cerrar Sesión"><?= Yii::t('app', 'Cerrar sesion'); ?></span></a>
					</div>
				</li>
			</ul>
		</div>
	</nav>
	<!-- END: Header-->

	<style type="text/css">
		.cont_img {
			width: 100%;
			margin: auto;
			height: 100px;
			display: flex;
			/*padding: 20px;*/
			text-align: center;
			align-items: center;
			justify-content: center;
		}

		.logo_agencia {
			max-height: 60px;
			max-width: 100%;
		}
	</style>
	<!-- BEGIN: Main Menu-->
	<div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true" id="main-menu-collapse">
		<div class="shadow-bottom"></div>
		<div class="main-menu-content">
			<ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
				<div id="applogo" class="d-flex align-items-center px-1">
					<?php if ($DatosAgencia->logotipo == "" || $DatosAgencia->logotipo == null) : ?>
						<div class="d-flex justify-content-center my-2">
							<a class="btn btn-primary" href="<?= Yii::app()->createUrl('agencia/update', array('id' => $_SESSION['Agencia']->id_agencia)) ?>">
								Sube tu logo aquí
							</a>
						</div>
					<?php else : ?>
						<div style="width: 90%;">
							<a class="cont_img" href="/admin">
								<img class="logo_agencia" :src="baseUrl+'/images/agencia/' + logotipo">
							</a>
						</div>
					<?php endif; ?>

					<div>
						<a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse"><i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i><i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary" data-feather="disc" data-ticon="disc"></i></a>
					</div>
				</div>
				<?php if (Yii::app()->user->id == 2 || Yii::app()->user->id == 1) : ?>
					<div class="m-1">
						<select class="select2 form-select" id="select2-agencies">
							<?php
							$agencies_array = Agencia::model()->findAll();
							foreach ($agencies_array as $index => $agency) : ?>
								<option value="<?= $agency->id_agencia ?>" <?= $agency->id_agencia == $_SESSION['Agencia']['id_agencia'] ? "selected" : '' ?>><?= $agency->id_agencia . " - " . $agency->nombre_comercial ?><?= $agency->estatus != "Activo" ? " - " . $agency->estatus : ""; ?></option>
							<?php endforeach; ?>
						</select>
					</div>
				<?php endif; ?>

				<hr class="mt-0">
				<li class=" nav-item <?= $controllerAction == "site/index" ? "active" : ""; ?>">
					<a class="d-flex align-items-center" href="/admin">
						<i class="fas fa-home"></i><span class="menu-title text-truncate lang" key="Inicio">Inicio</span>
					</a>
				</li>

				<!-- Fin Inicio -->

				<?php if (in_array($_SESSION["Usuario"]->rol, $allow_rols)) : ?>
					<!-- Mi Agencia -->
					<li class=" nav-item <?= strpos($controllerAction, "agencia") !== false ? "open" : ""; ?>"><a class="d-flex align-items-center" href="#"><i class="far fa-building"></i><span class="menu-title text-truncate lang" key="Mi Agencia"><?= Yii::t('app', 'Mi Agencia'); ?></span></a>
						<ul class="menu-content">
							<li><a class="d-flex align-items-center <?= $controllerAction == "agencia/miAgencia" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/miAgencia') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Mi Agencia"><?= Yii::t('app', 'Mi agencia'); ?></span></a>
							</li>
							<li><a class="d-flex align-items-center <?= $controllerAction == "agencia/miAgencia" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/firmadigital') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Firma Digital"><?= Yii::t('app', 'Firma Digital'); ?></span></a>
							</li>
							<li><a class="d-flex align-items-center <?= $controllerAction == "agencia/usuarios" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/usuarios') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Usuarios"><?= Yii::t('app', 'Usuarios'); ?></span></a>
							</li>
							<li><a class="d-flex align-items-center <?= $controllerAction == "agencia/cuentas" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/cuentas') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Cuentas de banco"><?= Yii::t('app', 'Cuentas de banco'); ?></span></a>
							</li>
							<li><a class="d-flex align-items-center <?= $controllerAction == "agencia/update" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/update', array('id' => $_SESSION['Agencia']->id_agencia)) ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Configuración"><?= Yii::t('app', 'Configuración'); ?></span></a>
							</li>
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "agencia/terminos" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('agencia/terminos'); ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Términos y condiciones"><?= Yii::t('app', 'Términos y condiciones'); ?></span></a>
							</li>
						</ul>
					</li>
					<!-- Fin Mi Agencia -->
				<?php endif; ?>

                <?php if ($_SESSION["Usuario"]->rol !== "Contabilidad") : ?>
				<!-- Ventas -->
				<li class=" nav-item <?= strpos($controllerAction, "ventas") !== false ? "open" : ""; ?>"><a class="d-flex align-items-center" href="#"><i class="fas fa-shopping-cart"></i><span class="menu-title text-truncate lang" key="Contratos"><?= Yii::t('app', 'Contratos'); ?></span></a>
					<ul class="menu-content">
						<li><a class="d-flex align-items-center <?= $controllerAction == "ventas/create" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('ventas/create') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Nuevo contrato"><?= Yii::t('app', 'Nuevo contrato'); ?></span></a>
						</li>
						<li><a class="d-flex align-items-center <?= $controllerAction == "ventas/index" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('ventas') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Lista de contratos"><?= Yii::t('app', 'Lista de contratos'); ?></span></a>
						</li>
					</ul>
				</li>
				<!-- Fin Ventas -->

				<!-- Bodas -->
				<li class=" nav-item <?= strpos($controllerAction, "bodas") !== false ? "active" : ""; ?>">
					<a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('bodas') ?>">
						<i class="fas fa-ring"></i><span class="menu-title text-truncate lang" key="Bodas">Bodas</span>
					</a>
				</li>
				<!-- Fin Bodas -->

				<!-- Grupos -->
				<li class=" nav-item <?= strpos($controllerAction, "grupos") !== false ? "active" : ""; ?>">
					<a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('grupos') ?>">
						<i class="fas fa-users"></i><span class="menu-title text-truncate lang" key="Grupos"><?= Yii::t('app', 'Grupos'); ?></span>
					</a>
				</li>
				<!-- Fin Grupos -->

				<!-- Caja -->
				<li class=" nav-item <?= $controllerAction == "caja/index" ? "active" : ""; ?>"><a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('caja') ?>"><i class="fas fa-money-check-alt"></i><span class="menu-title text-truncate lang" key="Caja"><?= Yii::t('app', 'Caja'); ?></span></a>
				</li>
				<!-- Fin Caja -->

				<!-- Gastos -->
				<li class=" nav-item <?= $controllerAction == "gastos/index" ? "active" : ""; ?>"><a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('gastos') ?>"><i data-feather="dollar-sign"></i><span class="menu-title text-truncate lang" key="Gastos"><?= Yii::t('app', 'Gastos'); ?></span></a>
				</li>
				<!-- Fin Gastos -->

				<!-- Facturacion -->

				<li class=" nav-item <?= $controllerAction == "facturacion/facturacion" ? "active" : ""; ?>">
					<a class="d-flex align-items-center" href="http://facturacione.webcfdi.com/login.php?cliente=AAA010101AAA&token=<?= md5($DatosFacturacion->usuario) . md5($DatosFacturacion->password); ?>" target="_blank"><i class="far fa-credit-card"></i><span class="menu-title text-truncate lang" key="Facturación"><?= Yii::t('app', 'Facturación'); ?></span></a>

				</li> 
				<!-- <li class=" nav-item <?= $controllerAction == "facturacion/index" ? "active" : ""; ?>">
					<a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('facturacion/index') ?>"><i class="far fa-credit-card"></i><span class="menu-title text-truncate lang" key="Facturación">Facturación</span></a>
				</li> -->

				<!-- Fin Facturacion -->

				<!-- Proveedores -->
				<li class=" nav-item <?= strpos($controllerAction, "proveedores") !== false ? "open" : ""; ?>"><a class="d-flex align-items-center" href="#"><i class="fas fa-people-carry"></i><span class="menu-title text-truncate lang" key="Proveedores"><?= Yii::t('app', 'Proveedores'); ?></span></a>
					<ul class="menu-content">
						<li><a class="d-flex align-items-center <?= $controllerAction == "proveedores/create" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('proveedores/create') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Nuevo proveedor"><?= Yii::t('app', 'Nuevo proveedor'); ?></span></a>
						</li>
						<li><a class="d-flex align-items-center <?= $controllerAction == "proveedores/index" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('proveedores') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Lista de proveedores"><?= Yii::t('app', 'Lista de proveedores'); ?></span></a>
						<li><a class="d-flex align-items-center <?= $controllerAction == "proveedores/pago" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('proveedores/pago') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Pagos"><?= Yii::t('app', 'Pagos'); ?></span></a>
						</li>
					</ul>
				</li>
				<!-- Fin Proveedores -->

				<!-- Clientes -->
				<li class=" nav-item <?= strpos($controllerAction, "clientes") !== false ? "active" : ""; ?>"><a class="d-flex align-items-center" href="<?= Yii::app()->createUrl('clientes'); ?>"><i class="fas fa-comments-dollar"></i><span class="menu-title text-truncate lang" key="Clientes"><?= Yii::t('app', 'Clientes'); ?></span></a>
				</li>
				<!-- Fin Clientes -->
				<?php endif; ?>

				<?php if (in_array($_SESSION["Usuario"]->rol, $allow_rols) || $_SESSION["Usuario"]->rol === "Contabilidad") : ?>
					<!-- Reportes -->
					<li class=" nav-item <?= strpos($controllerAction, "reportes") !== false ? "open" : ""; ?>"><a class="d-flex align-items-center" href="#"><i class="fas fa-archive"></i><span class="menu-title text-truncate lang" key="Reportes"><?= Yii::t('app', 'Reportes'); ?></span></a>
						<ul class="menu-content">
						    <?php if ($_SESSION["Usuario"]->rol !== "Contabilidad") : ?>
							<li><a class="d-flex align-items-center <?= $controllerAction == "reportes/ventas" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/ventas') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Ventas"><?= Yii::t('app', 'Ventas'); ?></span></a>
							</li>
							<li><a class="d-flex align-items-center <?= $controllerAction == "reportes/cuentasPorCobrar" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/cuentasPorCobrar') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Cuentas por Cobrar"><?= Yii::t('app', 'Cuentas por Cobrar'); ?></span></a>
							</li>
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "reportes/cuentasPorPagar" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/cuentasPorPagar') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Cuentas por Pagar"><?= Yii::t('app', 'Cuentas por Pagar'); ?></span></a>
							</li>
							<?php endif; ?>
							
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "reportes/pagos" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/pagos') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Ingresos"><?= Yii::t('app', 'Ingresos'); ?></span></a>
							</li>
							
							<?php if ($_SESSION["Usuario"]->rol !== "Contabilidad") : ?>
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "reportes/pagosProveedores" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/pagosProveedores') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Pagos Proveedores"><?= Yii::t('app', 'Pagos Proveedores'); ?></span></a>
							</li>
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "reportes/pagosBoda" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/pagosBoda') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Pagos Boda"><?= Yii::t('app', 'Bodas / Grupos'); ?></span></a>
							</li>	
							<li>
								<a class="d-flex align-items-center <?= $controllerAction == "reportes/ventasproximas" ? "active" : ""; ?>" href="<?= Yii::app()->createUrl('reportes/ventasproximas') ?>"><i data-feather="circle"></i><span class="menu-item text-truncate lang" key="Contratos Proximos"><?= Yii::t('app', 'Contratos Próximos'); ?></span></a>
							</li>						
							<?php endif; ?>
						</ul>
					</li>
					<!-- Fin Reportes -->
				<?php endif; ?>
			</ul>
		</div>
	</div>
	<!-- END: Main Menu-->

	<!-- BEGIN: Content-->
	<div class="app-content content ">
		<div class="content-overlay"></div>
		<div class="header-navbar-shadow"></div>
		<div class="content-wrapper container-xxl p-0">
			<div class="content-body">
				<?= $content; ?>
			</div>
		</div>
	</div>
	<!-- END: Content-->

	<div class="sidenav-overlay"></div>
	<div class="drag-target"></div>

	<!-- BEGIN: Footer-->
	<footer class="footer footer-static footer-light">
		<p class="clearfix mb-0"><span class="float-md-start d-block d-md-inline-block mt-25">COPYRIGHT &copy; <?= date("Y"); ?><a class="ms-25" href="https://2businesstravel.com" target="_blank">2business Travel</a><span class="d-none d-sm-inline-block">, Todos los derechos reservados</span></span></p>
	</footer>
	<button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>
	<!-- END: Footer-->


	<!-- BEGIN: Vendor JS-->
	<script src="<?= $baseUrl; ?>/template/vuexy/vendors/js/vendors.min.js"></script>
	<!-- BEGIN Vendor JS-->

	<!-- BEGIN: Page Vendor JS-->
	<!-- END: Page Vendor JS-->

	<!-- BEGIN: Theme JS-->
	<script src="<?= $baseUrl; ?>/template/vuexy/js/core/app-menu.min.js"></script>
	<script src="<?= $baseUrl; ?>/template/vuexy/js/core/app.min.js"></script>
	<script src="<?= $baseUrl; ?>/template/vuexy/js/scripts/customizer.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
	<!-- <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script> -->
	<script src="https://cdn.jsdelivr.net/npm/vue@2.6.14/dist/vue.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/vue-resource@1.5.3"></script>
	<!-- END: Theme JS-->

	<!-- BEGIN: Page JS-->
	<!-- END: Page JS-->

	<!-- Dark mode -->
	<script type="text/javascript" src="<?= $baseUrl; ?>/js/dark-mode.js"></script>

	<!-- Fin Dark mode -->
	<script>
		$(window).on('load', function() {
			if (feather) {
				feather.replace({
					width: 14,
					height: 14
				});
			}
		})
	</script>
	<script src="<?= Yii::app()->baseUrl; ?>/js/logomenuVUE.js?v=<?= time(); ?>"></script>
	<script src="<?= Yii::app()->baseUrl; ?>/js/multilenguaje.js?v=<?= time(); ?>"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/imask/6.2.2/imask.min.js"></script>
	<script src="<?= Yii::app()->baseUrl; ?>/template/vuexy/vendors/js/forms/select/select2.full.min.js"></script>
	<script>
		var telefonoMask = document.getElementsByClassName("telefonoMask");
		for (var i = 0; i < telefonoMask.length; i++) {
			new IMask(telefonoMask[i], {
				mask: '(000)000-00-00',
				placeholder: {
					show: 'always'
				}
			});
		}
		var cpMask = document.getElementsByClassName("cpMask");
		for (var i = 0; i < cpMask.length; i++) {
			new IMask(cpMask[i], {
				mask: /^[1-9]\d{0,5}$/,
				placeholder: {
					show: 'always'
				}
			});
		}
	</script>
	<?php
		Yii::app()->clientScript->registerScript('headerslayout', '
			var baseUrl = "' . Yii::app()->baseUrl . '";
			var id_agencia = "' . $_SESSION['Agencia']->id_agencia . '";
			var id_usuario = "' . $_SESSION['Usuario']->id_usuario . '";
        	var user_info = '. CJSON::encode($_SESSION["Usuario"]) .';
		', CClientScript::POS_HEAD);

		if (Yii::app()->user->id == 2 || Yii::app()->user->id == 1) {
			$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
			Yii::app()->clientScript->registerScript('select-agencies', '
				$(document).ready(function () {
					$("#select2-agencies").select2().on("select2:select", function (e) {
						$.ajax({
							type: "POST",
							url: "' . Yii::app()->createUrl('site/changeAgency') . '",
							data: {
								id_agencia: $("#select2-agencies").val()
							},
							dataType: "json",
						})
						.always(function(response) {
							if(response.status == 200){
								window.location.href = "' . $actual_link . '";
							}
						});
					});
				});
			', CClientScript::POS_END);
		}
		Yii::app()->clientScript->registerCssFile($baseUrl . '/template/vuexy/vendors/css/forms/select/select2.min.css');
	?>
</body>

</html>