<?php
    $tipo_servicios = TipoServicios::model()->findAll();
    $form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
		'id' => 'proveedores-form',
		'enableAjaxValidation' => false,
		'method' => 'post',
		'type' => 'horizontal',
		'htmlOptions' => array(
			'enctype' => 'multipart/form-data'
		)
	));
?>

<!-- Basic multiple Column Form section start -->
<section id="multiple-column-form">
    <form class="form">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <?php echo $form->errorSummary($model, 'Opps!!!', null, array('class' => 'alert alert-error span12')); ?>
                    <div class="card-header">
                        <h4 class="card-title lang" key="Datos generales">Datos generales</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'nombre_comercial', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'nombre_comercial', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'correo', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'correo', array('class' => 'form-control', 'maxlength' => 50)); ?>
                                </div>
                            </div>

                            <div class="col-md-4 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'plataforma_url', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'plataforma_url', array('class' => 'form-control', 'maxlength' => 255)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'usuario_plataforma', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'usuario_plataforma', array('class' => 'form-control', 'maxlength' => 100)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'pwd_plataforma', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'pwd_plataforma', array('class' => 'form-control', 'maxlength' => 150)); ?>
                                </div>
                            </div>
                            <div class="col-md-2 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'comision', array("class" => "form-label")); ?>
                                    <div class="input-group">
                                        <?php echo $form->textField($model, 'comision', array('rows' => 6, 'cols' => 50, 'class' => 'form-control', 'aria-describedby' => 'basic-addon2')); ?>
                                        <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'cuidad', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'cuidad', array('class' => 'form-control', 'maxlength' => 25)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'estado', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'estado', array('class' => 'form-control', 'maxlength' => 25)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'tipo_proveedor', array("class" => "form-label")); ?>
						            <?php echo $form->dropDownList($model, 'tipo_proveedor', array('general' => 'General', 'turistico' => 'Turístico'), array('class' => 'form-control')); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
                                    <label class="form-label">Servicios vendidos</label>
                                    <select id="tipo-servicios" class="form-control" name="ProveedoresTipoServicioProveedor[]" multiple>
                                        <?php foreach ($tipo_servicios as $key => $tipo) : ?>
                                            <option value="<?= $tipo->id_servicio; ?>"><?= $tipo->tipo_servicio; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'detalles', array("class" => "form-label")); ?>
                                    <?php echo $form->textArea($model, 'detalles', array('rows' => 6, 'cols' => 50, 'class' => 'form-control')); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Datos de contacto</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Nombre" for="first-name-column">Nombre</label>
                                    <?php echo $form->textField($proveedoresContacto, 'nombre', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Correo" for="last-name-column">Correo</label>
                                    <?php echo $form->textField($proveedoresContacto, 'correo', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
                                    <label class="form-label" for="city-column"><span class="lang" key="Teléfono">Teléfono </span> 1</label>
                                    <?php echo $form->textField($proveedoresContacto, 'telefono_1', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
                                    <label class="form-label" for="country-floating"><span class="lang" key="Teléfono">Teléfono </span> 2</label>
                                    <?php echo $form->textField($proveedoresContacto, 'telefono_2', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Descripción" for="email-id-column">Descripción</label>
                                    <?php echo $form->textField($proveedoresContacto, 'descripcion', array('class' => 'form-control', 'maxlength' => 100)); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title lang" key="Datos bancarios">Datos bancarios</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
                                    <label class="form-label" for="first-name-column">Alias</label>
                                    <button type="button" class="p-0" data-bs-toggle="popover" data-bs-content="Nombre asignado a tu cuenta para identificarla fácilmente." title="Alias" data-bs-trigger="focus" style="margin-left: 3px; color: #7367F0; font-size: 15px; outline: none; border: none; background-color: transparent;">
                                        <i class="fas fa-question-circle"></i>
                                    </button>
                                    <?php echo $form->textField($proveedoresDetallesBanco, 'alias', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Banco" for="last-name-column">Banco</label>
                                    <?php echo $form->textField($proveedoresDetallesBanco, 'banco', array('class' => 'form-control', 'maxlength' => 20)); ?>
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Sucursal" for="city-column">Sucursal</label>
                                    <?php echo $form->textField($proveedoresDetallesBanco, 'sucursal', array('class' => 'form-control', 'maxlength' => 10)); ?>
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="mb-1">
                                    <label class="form-label lang" key="Cuenta" for="country-floating">Cuenta</label>
                                    <?php echo $form->textField($proveedoresDetallesBanco, 'cuenta', array('class' => 'form-control', 'maxlength' => 10)); ?>
                                </div>
                            </div>
                            <div class="col-md-4 col-12">
                                <div class="mb-1">
                                    <label class="form-label" for="email-id-column">Clabe</label>
                                    <?php echo $form->textField($proveedoresDetallesBanco, 'clabe', array('class' => 'form-control', 'maxlength' => 18)); ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <?php
                    $this->widget('bootstrap.widgets.TbButton', array(
                        'buttonType' => 'submit',
                        'type' => 'primary',
                        'icon' => 'ok white',
                        'label' => $model->isNewRecord ? 'Crear' : 'Guardar',
                    ));
                ?>
            </div>
        </div>
    </form>

</section>
<!-- Basic Floating Label Form section end -->

<?php $this->endWidget(); ?>


<?php  
    Yii::app()->clientScript->registerScript('headersproveedores', '
        var baseUrl = "' . Yii::app()->baseUrl . '";
    ', CClientScript::POS_HEAD);

    Yii::app()->clientScript->registerScript('select2', '
        $("#tipo-servicios").select2();
    ', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/forms/select/select2.min.css');
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/template/vuexy/vendors/js/forms/select/select2.full.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/scripts/forms/form-select2.min.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/core/app.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/scripts/components/components-popovers.min.js?v='. time(), CClientScript::POS_END);
?>