<?php 
    $tipo_servicios = TipoServicios::model()->findAll();
    $form = $this->beginWidget('bootstrap.widgets.TbActiveForm', array(
		'id' => 'proveedores-form',
		'enableAjaxValidation' => false,
		'method' => 'post',
		'type' => 'horizontal',
		'htmlOptions' => array(
			'enctype' => 'multipart/form-data'
		)
	));
    $model_tsp = array();
    foreach ($model->tiposerviciosProveedores as $key => $tsp) {
        array_push($model_tsp, $tsp->id_tipo_servicio);
    }
?>

<!-- Basic multiple Column Form section start -->
<section id="multiple-column-form">
    <form class="form">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <?php echo $form->errorSummary($model, 'Opps!!!', null, array('class' => 'alert alert-error span12')); ?>
                    <div class="card-header">
                        <h4 class="card-title lang" key="Datos del proveedor">Datos del proveedor</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'nombre_comercial', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'nombre_comercial', array('class' => 'form-control', 'maxlength' => 35)); ?>
                                </div>
                            </div>
                            <div class="col-md-6 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'correo', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'correo', array('class' => 'form-control', 'maxlength' => 50)); ?>
                                </div>
                            </div>

                            <div class="col-md-4 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'plataforma_url', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'plataforma_url', array('class' => 'form-control', 'maxlength' => 255)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'usuario_plataforma', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'usuario_plataforma', array('class' => 'form-control', 'maxlength' => 100)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'pwd_plataforma', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'pwd_plataforma', array('class' => 'form-control', 'maxlength' => 150)); ?>
                                </div>
                            </div>
                            <div class="col-md-2 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'comision', array("class" => "form-label")); ?>
                                    <div class="input-group">
                                        <?php echo $form->textField($model, 'comision', array('rows' => 6, 'cols' => 50, 'class' => 'form-control', 'aria-describedby' => 'basic-addon2')); ?>
                                        <span class="input-group-text" id="basic-addon2">%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'cuidad', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'cuidad', array('class' => 'form-control', 'maxlength' => 25)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'estado', array("class" => "form-label")); ?>
                                    <?php echo $form->textField($model, 'estado', array('class' => 'form-control', 'maxlength' => 25)); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'tipo_proveedor', array("class" => "form-label")); ?>
						            <?php echo $form->dropDownList($model, 'tipo_proveedor', array('general' => 'General', 'turistico' => 'Turístico'), array('class' => 'form-control')); ?>
                                </div>
                            </div>
                            <div class="col-md-3 col-12">
                                <div class="mb-1">
                                    <label class="form-label">Servicios vendidos</label>
                                    <select id="tipo-servicios" class="form-control" name="ProveedoresTipoServicioProveedor[]" multiple>
                                        <?php foreach ($tipo_servicios as $key => $tipo) : ?>
                                            <option value="<?= $tipo->id_servicio; ?>"><?= $tipo->tipo_servicio; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12 col-12">
                                <div class="mb-1">
								    <?php echo $form->labelEx($model, 'detalles', array("class" => "form-label")); ?>
                                    <?php echo $form->textArea($model, 'detalles', array('rows' => 6, 'cols' => 50, 'class' => 'form-control')); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">

                <?php $this->widget('bootstrap.widgets.TbButton', array(
                    'buttonType' => 'submit',
                    'type' => 'primary',
                    'icon' => 'ok white',
                    'label' => $model->isNewRecord ? 'Crear' : 'Guardar',
                )); ?>
            </div>
        </div>
    </form>

</section>
<!-- Basic Floating Label Form section end -->

<?php $this->endWidget(); ?>

<?php
    Yii::app()->clientScript->registerScript('select2', '
        $("#tipo-servicios").val('. json_encode($model_tsp) .');
        $("#tipo-servicios").select2();
    ', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/forms/select/select2.min.css');
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/template/vuexy/vendors/js/forms/select/select2.full.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/js/scripts/forms/form-select2.min.js', CClientScript::POS_END);
?>