<style>
	.invoice-add .invoice-total-wrapper,
	.invoice-edit .invoice-total-wrapper,
	.invoice-preview .invoice-total-wrapper {
		max-width: 100%;
	}
	.imgpagos{
		padding: 55px;
	}	
</style>

<div id="app-provider-payments" class="ecommerce-application">
	<div class="bs-stepper checkout-tab-steps">
		<!-- Wizard starts -->
		<div class="bs-stepper-header">
			<div class="step" data-target="#step-sales" role="tab" id="step-sales-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="shopping-cart" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Ventas</span>
						<span class="bs-stepper-subtitle">Con saldo por pagar</span>
					</span>
				</button>
			</div>
			<div class="line">
				<i data-feather="chevron-right" class="font-medium-2"></i>
			</div>
			<div class="step" data-target="#step-payment" role="tab" id="step-payment-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="credit-card" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Pago</span>
						<span class="bs-stepper-subtitle">Ingrese los detalles de pago</span>
					</span>
				</button>
			</div>
			<div class="line">
				<i data-feather="chevron-right" class="font-medium-2"></i>
			</div>
			<div class="step" data-target="#step-info" role="tab" id="step-info-trigger">
				<button type="button" class="step-trigger">
					<span class="bs-stepper-box">
						<i data-feather="home" class="font-medium-3"></i>
					</span>
					<span class="bs-stepper-label">
						<span class="bs-stepper-title">Información</span>
						<span class="bs-stepper-subtitle">Detalle de la venta</span>
					</span>
				</button>
			</div>
		</div>
		<!-- Wizard ends -->

		<div class="bs-stepper-content">
			<!-- sale selector tab -->
			<div id="step-sales" class="content" role="tabpanel" aria-labelledby="step-sales-trigger">
				<div id="place-order" class="list-view product-checkout">
					<!-- Checkout Place Order Left starts -->
					<div class="checkout-items">
						<div class="card">
							<div class="row p-1">
								<div class="col mb-1">
									<label class="form-label" for="name-filter">Cliente</label>
									<input type="text" class="form-control" id="name-filter" placeholder="José Peréz" v-model="name_filter" />
								</div>
								<div class="col mb-1">
									<label class="form-label">Proveedor</label>
									<select class="form-control" v-model="provider_filter">
										<option value="">Todos</option>
										<option v-for="provider in providers_array" :value="provider.id" v-text="provider.text"></option>
									</select>
								</div>
								<div class="col mb-1">
									<label class="form-label" for="service-filter">Servicio</label>
									<select class="form-control" id="service-filter" v-model="service_filter">
										<option value="">Todos</option>
										<option :value="service.id_servicio" v-text="service.tipo_servicio" v-for="service in services_array"></option>
									</select>
								</div>
							</div>
						</div>
						<div class="card ecommerce-card" v-for="service in filteredServices">
							<div class="item-img imgpagos">
								<a href="javascript:;">
									<img src="<?= Yii::app()->baseUrl; ?>/images/icons/pagoProveedores.png" class="w-100" alt="img-placeholder" />
								</a>
							</div>
							<div class="card-body">
								<div class="item-name">
									<h6 class="mb-0"><span class="text-body" v-text="service.idProveedor.nombre_comercial"></span></h6>
									<span class="item-company">Folio <span class="company-name" v-text="service.codigo"></span></span>
								</div>
								<p v-text="service.descripcion"></p>
								<span class="delivery-date text-muted" v-text="'Límite pago: ' + formatDate(service.fecha_limite)"></span>
							</div>
							<div class="item-options text-center">
								<div class="item-wrapper">
									<div class="item-cost">
										<h4 class="item-price" v-text="getSaleBalance(service) + service.idVenta.moneda"></h4>
									</div>
								</div>
								<button type="button" class="btn btn-primary btn-next btn-cart move-cart" @click="setSaleModels(service.id_ventaservicio)">
									<i data-feather="dollar-sign" class="align-middle me-25"></i>
									<span class="text-truncate">Agregar pago</span>
								</button>
							</div>
						</div>
					</div>
					<!-- Checkout Place Order Left ends -->

					<!-- Checkout Place Order Right starts -->
					<div class="checkout-options">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Detalle saldo total</h4>
							</div>
							<div class="card-body">
								<div class="price-details">
									<ul class="list-unstyled">
										<li class="price-detail">
											<div class="detail-title">Total</div>
											<div class="detail-amt" v-text="total_amount + ' MXN'"></div>
										</li>
										<li class="price-detail">
											<div class="detail-title">Pagos</div>
											<div class="detail-amt discount-amt text-success" v-text="total_payments + ' MXN'"></div>
										</li>
									</ul>
									<hr />
									<ul class="list-unstyled">
										<li class="price-detail">
											<div class="detail-title detail-total">Saldo</div>
											<div class="detail-amt fw-bolder" v-text="total_balance + ' MXN'"></div>
										</li>
									</ul>
								</div>
							</div>
						</div>
						<!-- Checkout Place Order Right ends -->
					</div>
				</div>
				<!-- Checkout Place order Ends -->
			</div>
			<!-- Checkout Payment Starts -->
			<div id="step-payment" class="content" role="tabpanel" aria-labelledby="step-payment-trigger">
				<div id="checkout-payment" class="list-view product-checkout" v-if="service_model.id_ventaservicio">
					<div class="payment-type">
						<div class="card">
							<div class="card-header flex-column align-items-start">
								<h4 class="card-title">Registrar nuevo pago</h4>
								<p class="card-text text-muted mt-25">Ingrese los datos del pago realizado
								</p>
							</div>
							<div class="card-body">
								<div class="row">
									<div class="col">
										<div class="mb-1">
											<label for="amount-input" class="form-label">Monto del pago</label>
											<input type="number" class="form-control" id="amount-input" placeholder="100.00" v-model="payment_model.monto">
										</div>
										<div class="mb-1" v-if="!wayToPayAccount(payment_model.id_forma_pago)">
											<label for="account-select">Cuenta pago</label>
											<select id="account-select" class="form-control" v-model="payment_model.id_cuenta">
												<option value="">--Seleccione--</option>
												<option v-for="account in accounts_array" :value="account.id_cuenta" v-text="account.descripcion"></option>
											</select>
										</div>
										<div class="mb-1">
											<label for="amount-input" class="form-label">Observaciones</label>
											<textarea class="form-control" v-model="payment_model.descripcion"></textarea>
										</div>
										<div class="d-grid gap-2">
											<button id="btn-save-payment" class="btn btn-primary" type="button" @click="savePayment()">Guardar</button>
										</div>
									</div>
									<div class="col">
										<ul class="other-payment-options list-unstyled">
											<li class="py-50" v-for="(way, index) in ways_to_pay">
												<div class="form-check">
													<input type="radio" :id="'rbn-way-' + way.id_tipo" class="form-check-input" :value="way.id_tipo" v-model="payment_model.id_forma_pago" />
													<label class="form-check-label" :for="'rbn-way-' + way.id_tipo" v-text="way.descripcion"></label>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="amount-payable checkout-options">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Saldo Venta</h4>
							</div>
							<div class="card-body">
								<ul class="list-unstyled price-details">
									<li class="price-detail">
										<div class="details-title">Total</div>
										<div class="detail-amt">
											<strong v-text="service_amount + ' MXN'"></strong>
										</div>
									</li>
									<li class="price-detail">
										<div class="details-title">Pagos</div>
										<div class="detail-amt discount-amt text-success" v-text="service_payments + ' MXN'"></div>
									</li>
								</ul>
								<hr />
								<ul class="list-unstyled price-details">
									<li class="price-detail">
										<div class="details-title">Saldo a pagar</div>
										<div class="detail-amt fw-bolder" v-text="service_balance + ' MXN'"></div>
									</li>
								</ul>
								<button type="button" class="btn btn-primary w-100 btn-next delivery-address" @click="nextStep()">
									Ver detalle
								</button>
							</div>
						</div>
					</div>
				</div>
				<div class="card mt-2" v-else>
					<div class="card-body">
						<h3>Seleccione una venta para realizar un pago</h3>
					</div>
				</div>
			</div>
			<!-- Checkout Payment Ends -->
			<!-- Checkout Customer Address Starts -->
			<div id="step-info" class="content" role="tabpanel" aria-labelledby="step-info-trigger">
				<div id="checkout-address" class="list-view product-checkout" v-if="service_model.id_ventaservicio">
					<!-- Checkout Customer Address Left starts -->
					<div class="card">
						<div class=invoice-preview>
							<div class="invoice-preview-card">
								<div class="card-body invoice-padding pb-0">
									<!-- Header starts -->
									<div class="d-flex justify-content-between flex-md-row flex-column invoice-spacing mt-0">
										<div>
											<?php $this->renderPartial("/site/_infoAgenciaInvoice"); ?>
										</div>
										<div class="mt-md-0 mt-2">
											<h4 class="invoice-title">
												Registro
												<span class="invoice-number" v-text="'# ' + service_model.id_venta"></span>
											</h4>
											<div class="invoice-date-wrapper">
												<p class="invoice-date-title">Realizada:</p>
												<p class="invoice-date" v-text="formatDate(service_model.idVenta.fecha)"></p>
											</div>
											<div class="invoice-date-wrapper">
												<p class="invoice-date-title">Guardado:</p>
												<p class="invoice-date" v-text="formatDate(service_model.log)"></p>
											</div>
										</div>
									</div>
									<!-- Header ends -->
								</div>

								<hr class="invoice-spacing" />

								<!-- Address and Contact starts -->
								<div class="card-body invoice-padding pt-0">
									<div class="row invoice-spacing">
										<div class="col-xl-6 p-0">
											<h6 class="mb-2">Información cliente:</h6>
											<h6 class="mb-25" v-text="service_model.idVenta.idCliente.nombre"></h6>
											<p class="card-text mb-25" v-text="service_model.idVenta.idCliente.telefono"></p>
											<p class="card-text mb-0" v-text="service_model.idVenta.idCliente.correo"></p>
										</div>
										<div class="col-xl-6 p-0 mt-xl-0 mt-2">
											<h6 class="mb-2">Información proveedor:</h6>
											<table>
												<tbody>
													<tr>
														<td class="pe-1">Nombre:</td>
														<td><span class="fw-bold" v-text="service_model.idProveedor.nombre_comercial"></span></td>
													</tr>
													<tr>
														<td class="pe-1">Dirección:</td>
														<td v-text="service_model.idProveedor.direccion"></td>
													</tr>
													<tr>
														<td class="pe-1">Ciudad, Estado:</td>
														<td v-text="service_model.idProveedor.cuidad + ', ' + service_model.idProveedor.estado"></td>
													</tr>
													<tr>
														<td class="pe-1">Email:</td>
														<td v-text="service_model.idProveedor.correo"></td>
													</tr>
												</tbody>
											</table>
										</div>
									</div>
								</div>
								<!-- Address and Contact ends -->

								<!-- Invoice Description starts -->
								<div class="table-responsive">
									<table class="table">
										<thead>
											<tr>
												<th class="py-1">Descripción</th>
												<th class="py-1">Servicio</th>
												<th class="py-1">Inicio</th>
												<th class="py-1">Fin</th>
												<th class="py-1">Total</th>
											</tr>
										</thead>
										<tbody>
											<tr>
												<td class="py-1">
													<p class="card-text fw-bold mb-25" v-text="service_model.idProveedor.nombre_comercial"></p>
													<p class="card-text text-nowrap" v-text="service_model.descripcion"></p>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="service_model.idTipoServicio.tipo_servicio"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="formatDate(service_model.inicio_servicio)"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="formatDate(service_model.fin_servicio)"></span>
												</td>
												<td class="py-1">
													<span class="fw-bold" v-text="formatPrice(service_model.tarifa_publica)"></span>
												</td>
											</tr>
										</tbody>
									</table>
								</div>

								<div class="card-body invoice-padding pb-0">
									<div class="row invoice-sales-total-wrapper">
										<div class="col-md-6 order-md-1 order-2 mt-md-0 mt-3">
										</div>
										<div class="col-md-6 d-flex justify-content-end order-md-2 order-1">
											<div class="invoice-total-wrapper">
												<div class="invoice-total-item">
													<p class="invoice-total-title">Total:</p>
													<p class="invoice-total-amount" v-text="service_amount + ' MXN'"></p>
												</div>
												<div class="invoice-total-item">
													<p class="invoice-total-title">Pagado:</p>
													<p class="invoice-total-amount" v-text="service_payments + ' MXN'"></p>
												</div>
												<hr class="my-50" />
												<div class="invoice-total-item">
													<p class="invoice-total-title">Saldo:</p>
													<p class="invoice-total-amount" v-text="service_balance + ' MXN'"></p>
												</div>
											</div>
										</div>
									</div>
								</div>
								<!-- Invoice Description ends -->
							</div>
						</div>
					</div>
					<!-- Checkout Customer Address Left ends -->

					<!-- Checkout Customer Address Right starts -->
					<div class="customer-card">
						<div class="card">
							<div class="card-header">
								<h4 class="card-title">Pagos realizados</h4>
							</div>
							<ul class="list-group list-group-flush" v-if="service_model.pagosProveedores.length > 0">
								<li class="list-group-item" v-for="payment in service_model.pagosProveedores">
									<div class="row">
										<div class="col" v-text="formatDate(payment.log)"></div>
										<div class="col" v-text="formatPrice(payment.monto)"></div>
									</div>
								</li>
							</ul>
							<div class="card-body actions">
								<p class="card-text" v-if="service_model.pagosProveedores.length == 0">No hay pagos registrados.</p>
							</div>
						</div>
					</div>
					<!-- Checkout Customer Address Right ends -->
				</div>
				<div class="card mt-2" v-else>
					<div class="card-body">
						<h3>Seleccione una venta para ver la información</h3>
					</div>
				</div>
			</div>
			<!-- Checkout Customer Address Ends -->
		</div>
	</div>
</div>

<?php
	Yii::app()->clientScript->registerScript('id0', '
			var baseUrl = "' . Yii::app()->baseUrl . '";
		', CClientScript::POS_END);

	$baseUrl = "https://erp.2businesstravel.com/admin/template/vuexy";
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/core/menu/menu-types/vertical-menu.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/pages/app-invoice.min.css');

	Yii::app()->clientScript->registerCssFile($baseUrl .'/vendors/css/forms/wizard/bs-stepper.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/pages/app-ecommerce.min.css');
	Yii::app()->clientScript->registerCssFile($baseUrl .'/css/plugins/forms/form-wizard.min.css');

	Yii::app()->clientScript->registerScriptFile($baseUrl .'/vendors/js/forms/wizard/bs-stepper.min.js', CClientScript::POS_END);
	//Yii::app()->clientScript->registerScriptFile($baseUrl .'/js/scripts/forms/form-wizard.min.js', CClientScript::POS_END);
	//Yii::app()->clientScript->registerScriptFile($baseUrl .'/js/scripts/pages/app-ecommerce-checkout.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/proveedor-pagos.js?v=' . time(), CClientScript::POS_END);
?>