<?php
	$this->breadcrumbs = array(
		'Proveedores' => array('index'),
		$model->id_proveedor,
	);
?>

<style type="text/css">
	.info {
		background-color: paleturquoise;
		padding: 5px;
		margin: 10px 0px;
		color: #333;
		font-size: 15px;
	}
	.nav-tabs .active {
		background-color: #7571f9 !important;
		color: #fff !important;
	}
	#toast-container>.toast-success {
		background-color: green !important;
	}
	.transaction-title {
		overflow-wrap: anywhere !important;
	}
	.card-shadow {
		box-shadow: 0 4px 24px 0 rgb(34 41 47 / 10%);
	}
</style>
<style type="text/css" media="print">
	.info {
		background-color: paleturquoise;
		padding: 5px;
		margin: 10px 0px;
		color: #333;
		font-size: 15px;
	}
	.nav-tabs .active {
		background-color: #7571f9 !important;
		color: #fff !important;
	}
	body {
		visibility: hidden;
	}
	.printableArea {
		visibility: visible;
		overflow-wrap: anywhere;
	}
	.card .table {
		overflow-wrap: anywhere !important;
	}
	.transaction-title {
		overflow-wrap: anywhere !important;
	}
</style>

<a href="<?= Yii::app()->createUrl('proveedores') ?>" class="btn mb-1 btn-warning btn-rounded my-1"><span class="btn-icon-left"><i class="icono fas fa-arrow-left"></i> </span>Regresar</a>

<!-- Default Breadcrumb Starts -->
<section id="default-breadcrumb">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header">
					<h4 class="card-title">Detalles del Proveedor <?= $model->nombre_comercial; ?></h4>
				</div>
				<div class="card-body">
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb">
							<li class="breadcrumb-item"><a href="/admin">Inicio</a></li>
							<li class="breadcrumb-item"><a href="<?= Yii::app()->createUrl('proveedores') ?>">Lista de proveedores</a></li>
							<li class="breadcrumb-item active" aria-current="page">Detalles del Proveedor <?= $model->nombre_comercial; ?></li>
						</ol>
					</nav>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- Default Breadcrumb Ends -->

<?php if (Yii::app()->user->hasFlash('success')) : ?>
	<div class="info">
		<?php echo Yii::app()->user->getFlash('success'); ?>
	</div>
<?php endif; ?>

<section id="basic-tabs-components">
	<div class="row match-height">
		<!-- Basic Tabs starts -->
		<div class="col-xl-12">
			<div class="card">
				<div class="card-body">
					<ul class="nav nav-tabs" role="tablist">
						<li class="nav-item">
							<a class="nav-link active" id="proveedor-tab" data-bs-toggle="tab" href="#proveedor" aria-controls="proveedor" role="tab" aria-selected="true">Datos del proveedor</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="contacto-tab" data-bs-toggle="tab" href="#contacto" aria-controls="contacto" role="tab" aria-selected="false">Datos de contacto</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="banco-tab" data-bs-toggle="tab" href="#banco" aria-controls="banco" role="tab" aria-selected="false">Detalles bancarios</a>
						</li>
					</ul>
					<div id="appproveedor" class="tab-content">
						<div class="tab-pane active" id="proveedor" aria-labelledby="proveedor-tab" role="tabpanel">
							<h3>Datos generales del Proveedor <?= $model->nombre_comercial; ?></h3>
							<div class='printableArea'>
								<div v-for="datosprov in datos_generales_proveedor" class="table-responsive">
									<table class="table">
										<tbody>
											<tr>
												<th>Nombre comercial</th>
												<td v-text="datosprov.nombre_comercial"></td>
											</tr>
											<tr>
												<th>Correo</th>
												<td v-text="datosprov.correo"></td>
											</tr>
											<tr>
												<th>Dirección</th>
												<td v-text="datosprov.direccion"></td>
											</tr>
											<tr>
												<th>Código postal</th>
												<td v-text="datosprov.codigo_postal"></td>
											</tr>
											<tr>
												<th>Ciudad</th>
												<td v-text="datosprov.cuidad"></td>
											</tr>
											<tr>
												<th>Estado</th>
												<td v-text="datosprov.estado"></td>
											</tr>
											<tr>
												<th>Detalles</th>
												<td v-text="datosprov.detalles"></td>
											</tr>
											<tr>
												<th>Comisión</th>
												<td v-text="datosprov.comision + '%'"></td>
											</tr>
										</tbody>
									</table>
								</div>
								<a href="<?= Yii::app()->createUrl('proveedores/update', array('id' => $model->id_proveedor)); ?>" class="btn btn-primary me-1">Editar</a>
							</div>
						</div>

						<div class="tab-pane" id="contacto" aria-labelledby="contacto-tab" role="tabpanel">
							<h3>Contactos del Proveedor <?php echo $model->nombre_comercial; ?></h3>
							<a href="<?= Yii::app()->createUrl('proveedoresContacto/create', array('id' => $model->id_proveedor)); ?>" class="btn btn-gradient-success">Nuevo Contacto</a>
							<?php $this->renderPartial("_datoscontacto", array(
								'id' => $_SESSION['Agencia']->id_agencia,
								'idproveedor' => $model->id_proveedor
							)); ?>
						</div>
						<div class="tab-pane" id="banco" aria-labelledby="banco-tab" role="tabpanel">
							<h3>Datos Bancarios del Proveedor <?php echo $model->nombre_comercial; ?></h3>
							<a href="<?= Yii::app()->createUrl('proveedoresDetallesBanco/create', array('id' => $model->id_proveedor)); ?>" class="btn btn-gradient-success">Nuevo Dato Bancario</a>

							<?php $this->renderPartial("_datosbancarios", array(
								'id' => $_SESSION['Agencia']->id_agencia,
								'idproveedor' => $model->id_proveedor
							)); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Basic Tabs ends -->
	</div>
</section>

<script type="text/javascript">
	function printDiv() {
		window.print();
	}
</script>
<?php
	Yii::app()->clientScript->registerScript('headers_proveedores', '
		var idproveedor = "' . $model->id_proveedor . '";     
	', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerCssFile('//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css');
	Yii::app()->clientScript->registerScriptFile('//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/proveedoresVUE.js?v=' . time(), CClientScript::POS_END);
?>