<?php
    setlocale(LC_TIME, "es_MX.UTF-8");
    // $this->pageTitle = Yii::app()->params['appTitle'];
    $this->pageTitle = Yii::app()->name . ' - ' . "Administrador de Agencia de Viajes";
    $this->addMetaProperty('og:title', Yii::app()->params['appTitle']);
    $this->addMetaProperty('og:type', 'website');
    $this->addMetaProperty('og:url', $this->createUrl('index'));
    $this->addMetaProperty('og:image', Yii::app()->request->getBaseUrl(true) . '/images/bootstrap-avatar_normal.png');
    $this->addMetaProperty('og:site_name', Yii::app()->name);
    $this->addMetaProperty('og:locale', Yii::app()->fb->locale);
    $this->addMetaProperty('fb:app_id', Yii::app()->fb->appID);

    Yii::app()->clientScript->registerScript('siteIndex', "
        // Prevent jumping to the top of the page when demo links are clicked.
        jQuery('.site-index a').on('click', function(e) {
            var element = $(this),
                href = element.attr('href'),
                toggle = element.attr('data-toggle');

            if ((href && (href.length === 0 || href === '#')) && !toggle) {
                    return false;
            }
        });

        // Prevent form submission.
        jQuery('.site-index form').on('submit', false);
    ");
?>

<div class="">
    <!-- Developer Meetup Card -->
    <div class="row match-height">
        <div class="col-lg-5 col-md-5 col-12">
            <div class="card card-developer-meetup">
                <div class="meetup-img-wrapper rounded-top text-center">
                    <img class="w-100" src="<?= Yii::app()->baseUrl; ?>/template/vuexy/images/email.svg" alt="Meeting Pic" height="170" />
                </div>
                <div class="card-body">
                    <div class="meetup-header d-flex align-items-center m-0">
                        <div class="meetup-day">
                            <h6 class="mb-0"><?php echo strftime("%a"); ?></h6>
                            <h3 class="mb-0"><?php echo strftime("%d"); ?></h3>
                        </div>
                        <div class="my-auto">
                            <h4 class="card-title mb-25"><span class="lang" key="Bienvenido">Bienvenido</span> <?= Yii::app()->getModule('user')->user()->profile->firstname; ?></h4>
                            <p class="card-text mb-0"><?= $_SESSION['Usuario']->rol; ?> <span class="lang" key="de">de</span> <?php echo $_SESSION['Agencia']->nombre_comercial; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/ Developer Meetup Card -->

        <!-- Bar Chart - Orders -->
        <?php $this->renderPartial('_cardsInfo'); ?>
        <!--/ Bar Chart - Orders -->

        <!-- Reportes -->
        <?php $this->renderPartial('ChartGanancias'); ?>

        <!-- Revenue Report Card -->
        <div class="col-xl-6 col-lg-6 col-12">
            <div class="card card-revenue-budget" id="apexchart">
                <div class="row mx-0">
                    <div class="col-lg-12 col-md-6 col-12 revenue-report-wrapper">
                        <div class="d-sm-flex justify-content-between align-items-center mb-3">
                            <div style="width:100%">
                                <?php $this->renderPartial('ChartVentas', ['altura' => '250']); ?>
                            </div>
                        </div>
                        <div id="ventas-chart"></div>
                    </div>
                </div>
            </div>
        </div>
        <!--/ Revenue Report Card -->
        <!-- Fin reportes -->
    </div>
</div>

<?php
    Yii::app()->clientScript->registerScript('headerindex', '
    var baseUrl = "' . Yii::app()->baseUrl . '";
    ', CClientScript::POS_HEAD);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/template/vuexy/vendors/js/extensions/toastr.min.js', CClientScript::POS_END);
    
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . '/js/chartsprueba.js', CClientScript::POS_END);
?>