<style>
    .dataTables_length {
		margin-left: 1rem;
	}

	.dataTables_info {
		margin-left: 1rem;
	}

	.dataTables_filter {
		margin-right: 1rem;
	}

	.dataTables_paginate {
		margin-right: 1rem !important;
	}
</style>

<section id="requests">
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <h2>Solicitudes</h2>
                </div>
                <div class="col-12 col-lg-1">
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#request-cu">
                        <span data-feather="plus"></span>
                    </button>
                </div>
                <div class="col-12 col-lg-3">
                    <div>
                        <input id="date-filter" class="form-control" type="text">
                    </div>
                </div>
                <div class="col-12 col-lg-3">
                    <div>
                        <select class="form-control" v-model="status_filter">
                            <option value="Seguimiento">Seguimiento</option>
                            <option value="En proceso">En proceso</option>
                            <option value="Contrato">Contrato</option>
                            <option value="Venta">Venta</option>
                            <option value="Cancelada">Cancelada</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <table id="requests-table" class="table tabled-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Descripción</th>
                    <th>Cliente</th>
                    <th>Usuarios</th>
                    <th>Solicitado</th>
                    <th>Estatus</th>
                    <th></th>
                </tr>
            </thead>
            <tbody v-if="filteredRequests.length > 0">
                <tr v-for="(request, index) in filteredRequests">
                    <td v-text="(index + 1)"></td>
                    <td v-text="request.descripcion"></td>
                    <td v-text="request.idCliente.nombre"></td>
                    <td v-text="request.idUsuario.profiles.firstname + ' ' + request.idUsuario.profiles.lastname"></td>
                    <td v-text="formatDate(request.log)"></td>
                    <td v-text="request.estatus"></td>
                    <td>
                        <a :href="baseUrl + '/solicitudes/' + request.id_solicitud"><i data-feather="eye"></i></a>
                        <a href="javascript:void(0)" @click="showDeleteAlert(request.id_solicitud)"><i data-feather="trash"></i></a>
                        <!-- <a href="javascript:;" class="delete-record ms-50" :data-request="request.id_solicitud"><i data-feather="trash"></i></a> -->
                    </td>
                </tr>
            </tbody>
            <tbody v-else>
                <tr>
                    <td colspan="7" class="text-center">Ninguna solicitud coincide con los filtros.</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="modal fade" id="request-cu" tabindex="-1" aria-labelledby="titleModalRequest" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="titleModalRequest">Nueva solicitud</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?php $this->renderPartial("_modalForm"); ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="createRequest()">Guardar</button>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $this->renderPartial("/clientes/_form"); ?>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var view = "modal";
    ', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('//cdn.datatables.net/plug-ins/1.12.1/dataRender/datetime.js', CClientScript::POS_END);

    Yii::app()->clientScript->registerCssFile('https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css');
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', CClientScript::POS_END);

	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/clientes-cu.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/solicitudes-index.js?v='. time(), CClientScript::POS_END);
?>