<style>
    .customer-name {
        text-decoration: none;
    }
</style>

<section id="request">
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-12 col-lg-2">
                    <h2>Solicitudes</h2>
                </div>
                <div class="col-12 col-lg-1">
                    <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#request-cu">
                        <span data-feather="plus"></span>
                    </button>
                </div>
                <div class="col-12 col-lg-3">
                    <div>
                        <input id="date-filter" class="form-control" type="text">
                    </div>
                </div>
                <div class="col-12 col-lg-3">
                    <div>
                        <select class="form-control" v-model="status_filter">
                            <option v-for="status in request_status" :value="status" v-text="status"></option>
                        </select>
                    </div>
                </div>
                <div class="col-12 col-lg-3">
                    <div >
                        <!-- <label class="form-label">Filtrar solicitudes</label> -->
                        <input type="text" class="form-control " v-model="request_filter" placeholder="Filtrar solicitudes">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row row-cols-1 row-cols-md-4 g-4" v-if="filteredRequests.length > 0">
        <div class="col" v-for="request in filteredRequests">
            <div class="card">
                <div class="card-body">
                    <a class="customer-name stretched-link" :href="baseUrl + '/solicitudes/' + request.id_solicitud"><h3 v-text="request.idCliente.nombre"></h3></a>
                    <h4 class="text-muted" v-text="'de ' + request.idUsuario.profiles.firstname + ' ' + request.idUsuario.profiles.lastname + ' (' + formatDate(request.log) + ')'"></h4>
                    <p class="card-text" v-text="request.descripcion"></p>
                </div>
            </div>
        </div>
    </div>
    <div class="row" v-else>
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4>Ninguna solicitud coincide con el filtro</h4>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="request-cu" tabindex="-1" aria-labelledby="titleModalRequest" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="titleModalRequest">Nueva solicitud</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <?php $this->renderPartial("_modalForm"); ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" @click="createRequest()">Guardar</button>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $this->renderPartial("/clientes/_form"); ?>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var view = "modal";
    ', CClientScript::POS_HEAD);

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.2/moment.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerCssFile('https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css');
    Yii::app()->clientScript->registerScriptFile('https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', CClientScript::POS_END);

    //Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/solicitudes-cu.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/solicitudes-index.js?v='. time(), CClientScript::POS_END);
?>