<style>
    .card .card-header {
        padding: 0.75rem 1.25rem;
    }
    .card .card-footer {
        padding: 0.75rem 1.25rem;
    }
    .price-header {
        border-bottom: 1px solid rgba(34, 41, 47, .125)!important;
    }
    .dark-layout .card .price-header {
        border-bottom: 1px solid #3B4253!important;
    }
    .total-footer {
        border-top: 1px solid rgba(34, 41, 47, .125)!important;
    }
    .dark-layout .card .total-footer {
        border-top: 1px solid #3B4253!important;
    }
    hr {
        height: 2px!important;
    }

    .dataTables_length {
		margin-left: 1rem;
	}
	.dataTables_info {
		margin-left: 1rem;
	}
	.dataTables_filter {
		margin-right: 1rem;
	}
	.dataTables_paginate {
		margin-right: 1rem !important;
	}
</style>

<section id="request-detail">
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">Información de la solicitud</h4>
            <?php $this->renderPartial("_modalForm"); ?>
            <div class="text-end mt-1">
                <button class="btn btn-primary" type="button" @click="updateRequest()">Aceptar</button>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <h3>Cotizaciones</h3>
                </div>
                <div class="col text-end">
                    <a :href="baseUrl + '/cotizaciones/create/' + request_code" class="btn btn-sm btn-outline-primary"><span data-feather="plus"></span></a>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <?php $this->renderPartial("/cotizaciones/_table"); ?>
    </div>

</section>

<div class="modal fade text-start" id="cu-prices" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modalLabel">Editar cotización</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mt-1">
                    <label class="form-label">Fecha de servicio</label>
                    <input class="form-control" type="text">
                </div>
                <div v-for="(detail, index) in price_model.cotizacionDetalles">
                    <hr v-if="index > 0">
                    <div class="mt-1">
                        <label class="form-label">Tipo de servicio</label>
                        <select class="form-control" v-model="detail.id_tipo_servicio">
                            <option value="" selected hidden>--Seleccione--</option>
                            <option v-for="service_type in service_types_array" :value="service_type.id_servicio" v-text="service_type.tipo_servicio"></option>
                        </select>
                    </div>
                    <div class="row" v-if="detail.id_tipo_servicio != 1">
                        <div class="col-4">
                            <div class="mt-1">
                                <label class="form-label">Adultos</label>
                                <input class="form-control" type="number" v-model="detail.desglose.adultos">
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mt-1">
                                <label class="form-label">Menores</label>
                                <input class="form-control" type="number" v-model="detail.desglose.menores">
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mt-1">
                                <label class="form-label">Infantes</label>
                                <input class="form-control" type="number" v-model="detail.desglose.infantes">
                            </div>
                        </div>
                        <div class="col">
                            <div class="mt-1">
                                <label class="form-label">Precio público</label>
                                <input class="form-control" type="text" v-model="detail.total_publico">
                            </div>
                        </div>
                        <div class="col">
                            <div class="mt-1">
                                <label class="form-label">Precio neto</label>
                                <input class="form-control" type="text" v-model="detail.total_neto">
                            </div>
                        </div>
                    </div>
                    <div v-else>
                        <div class="mt-1">
                            <label class="form-label">Hotel</label>
                            <input class="form-control" type="text" v-model="detail.desglose.hotel">
                        </div>
                        <div class="row">
                            <div class="col">
                                <div class="mt-1">
                                    <label class="form-label">Destino</label>
                                    <input class="form-control" type="text" v-model="detail.desglose.destino">
                                </div>
                            </div>
                            <div class="col">
                                <div class="mt-1">
                                    <label class="form-label">Estancia</label>
                                    <input class="form-control" type="text">
                                </div>
                            </div>
                        </div>
                        <div v-for="(hab, i) in detail.desglose.habitaciones">
                            <h6 class="text-center mt-1" v-text="'Habitación ' + (i + 1)"></h6>
                            <div class="row">
                                <div class="col-3">
                                    <label class="form-label">Adultos</label>
                                    <input class="form-control" type="number" v-model="hab.adultos">
                                </div>
                                <div class="col-3">
                                    <label class="form-label">Menores</label>
                                    <input class="form-control" type="number" v-model="hab.menores">
                                </div>
                                <div class="col-3">
                                    <label class="form-label">Infantes</label>
                                    <input class="form-control" type="number" v-model="hab.infantes">
                                </div>
                                <div class="col-3">
                                    <label class="form-label">Base hab.</label>
                                    <select class="form-control" v-model="hab.base_habitacion">
                                        <option value="" selected hidden>--Seleccione--</option>
                                        <option v-for="base in room_base" :value="base" v-text="base"></option>
                                    </select>
                                </div>
                                <div class="col-4">
                                    <div class="mt-1">
                                        <label class="form-label">Plan</label>
                                        <input class="form-control" type="text" v-model="hab.plan">
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="mt-1">
                                        <label class="form-label">Tipo habitación</label>
                                        <input class="form-control" type="text" v-model="hab.tipo_habitacion">
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="mt-1">
                                        <label class="form-label">Tipo cama</label>
                                        <input class="form-control" type="text" v-model="hab.tipo_cama">
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="mt-1">
                                        <label class="form-label">Precio público</label>
                                        <input class="form-control" type="number" step="any" v-model="hab.total_publico">
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="mt-1">
                                        <label class="form-label">Precio neto</label>
                                        <input class="form-control" type="number" step="any" v-model="hab.total_neto">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<?php
    Yii::app()->clientScript->registerScript('vars', '
        var baseUrl = "'. Yii::app()->baseUrl .'";
        var view = "view";
        var request_code = "'. $_GET["id"] .'";
    ', CClientScript::POS_HEAD);
    
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/dataTables.bootstrap5.min.css');
    Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/responsive.bootstrap5.min.css');
	Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl .'/template/vuexy/vendors/css/tables/datatable/buttons.bootstrap5.min.css');

	Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jquery.dataTables.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.bootstrap5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/dataTables.responsive.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/responsive.bootstrap5.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/datatables.buttons.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/jszip.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/pdfmake.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/vfs_fonts.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.html5.min.js', CClientScript::POS_END);
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/template/vuexy/vendors/js/tables/datatable/buttons.print.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('//cdn.datatables.net/plug-ins/1.12.1/dataRender/datetime.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/solicitudes-view.js?v='. time(), CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/vue/cotizaciones-cu.js?v='. time(), CClientScript::POS_END);
?>